#!/bin/sh
#
#	@author	Forrest Lin
#

CFGFILE=/mnt/sncfg.bak
LOGFILE=/var/log/sncfg-restore.log
LOCKFILE=/var/run/sncfg-restore.lock

error_exit()
{
	rm -f $CFGFILE
	rm -f $LOCKFILE
	exit 1	
}

set -o noclobber
while ! date 2>/dev/null > $LOCKFILE 2>/dev/null ; do
	echo "Configuration Restoration is in progress !!"
	exit 1
done
set +o noclobber

if [ "$1" == "" ] ; then
    echo "Usage : $0 [file | http url | ftp url | tftp url]"
    error_exit
fi

ARGV=$@
HTTPLINK=`echo $ARGV | grep "^http"`
FTPLINK=`echo $ARGV | grep "^ftp://"`
TFTPLINK=`echo $ARGV | grep "^tftp://"`

if [ -n "$HTTPLINK" ] || [ -n "$FTPLINK" ] ; then
	rm -f $CFGFILE
	echo "<< HTTP/FTP mode >>"
	echo "URL : $ARGV"
	echo "-----------------------------------------"
	echo -n "Downloading ... "
	wget --timeout=10 $ARGV -O $CFGFILE 2> $LOGFILE
    	ret=$?
    	if [ $ret == 0 ] ; then
        	echo "OK"
    	else
        	echo "Failed"
        	error_exit
    	fi
elif [ -n "$TFTPLINK" ] ; then
	rm -f $CFGFILE
	echo "<< TFTP mode >>"
	file=$ARGV
	file=${file#*/}
	file=${file#*/}
	path=${file#*/}
	addr=${file%%/*}
	echo "Server : $addr"
	echo "File   : $path"
	echo "-----------------------------------------"
	echo -n "Downloading ... "
	tftp -g -r "$path" -l $CFGFILE $addr 2> $LOGFILE
	ret=$?
	if [ $ret == 0 ] ; then
		echo "OK"
	else
		echo "Failed"
		error_exit
	fi
else
	echo "<< FILE mode >>"
	echo "File : $ARGV"
	echo "-----------------------------------------"
	echo -n "Coping ... "
	ret=$?
	cp $ARGV $CFGFILE 2> $LOGFILE
	if [ $ret == 0 ] ; then
		echo "OK"
	else
		echo "Failed"
		error_exit
	fi
fi

echo -n "Restore Configuration ... "
/sbin/sncfg restore $CFGFILE
ret=$?
if [ $ret == 0 ] ; then
	echo "OK"
	rm -f $CFGFILE
	rm -f $LOCKFILE
	exit 0
else
	echo "Failed"
	error_exit 
fi
