#!/bin/sh
#
# $Id: upnp.sh,v 1.22.6.1 2008-10-02 12:57:42 winfred Exp $
#
# usage: upnp.sh
#

conf_dir=/etc/miniupnpd
lan_if=bridge0
wan_if=`cfg get current_wan_interface`

cur_mod=`cfg get apsta_type`
sta_stutas=`cfg get ex_wifi_status`
#gw=`cfg get lan_ipaddr`
gw=`cfg get lan_ipaddr_for_current`
# here we check if datacard(nat) mode
product_type=`cfg get product_type`

conf_file="/etc/miniupnpd/miniupnpd.conf"
friendly_name=`cfg get upnp_friendly_name`
if [ "$friendly_name" != "" ]
then
  friendly_name_org=$(grep friendly_name= $conf_file)
  aim="friendly_name=$friendly_name"
  sed -i "s:$friendly_name_org:$aim:g" $conf_file
fi

serial=`cfg get imei`
if [ "$serial" != "" ]
then
  serial_org=$(grep serial= $conf_file)
  aim="serial=$serial"
  sed -i "s:$serial_org:$aim:g" $conf_file
fi

manufacturer=`cfg get upnp_manufacturer`

if [ "$manufacturer" != "" ]
then
  manufacturer_org=$(grep manufacturer= $conf_file)
  aim="manufacturer=$manufacturer"
  sed -i "s:$manufacturer_org:$aim:g" $conf_file
fi

manufacturer_url=`cfg get upnp_manufacturer_url`
if [ "$manufacturer_url" != "" ]
then
  manufacturer_url_org=$(grep manufacturer_url= $conf_file)
  aim="manufacturer_url=$manufacturer_url"
  sed -i "s:$manufacturer_url_org:$aim:g" $conf_file
fi

# only data card mode
if [ "ONLY_DATA_CARD" = "$product_type" ]
then
  echo "bridge_setup.sh: $product_type only data card mode, exit"
  exit
else
  echo "bridge_setup.sh: $product_type will check product type further"
fi

# datacard(nat), just setup usb0
if [ "NO_DRIVER_DATA_CARD" = "$product_type" -o "DRIVER_DATA_CARD" = "$product_type" ]
then
  echo "bridge_setup.sh: $product_type host(less) datacard, just setup usb0"
  lan_if=usb0
else
  echo "bridge_setup.sh: need set br0, just go"
fi

# stop all
killall miniupnpd
$conf_dir/iptables_removeall.sh

# upnp starting

if [ -f /var/run/miniupnp.pid ]
then
	rm -f /var/run/miniupnpd.pid
fi

#if [ "apsta" = "$cur_mod" -a "connect" = "$sta_stutas" ]; then
#	echo "miniupnpd.sh: now station is wan."
#	wan_if=`cfg get wifi_sta_net`
#fi

#$conf_dir/miniupnpd_extif.sh $wan_if
#$conf_dir/miniupnpd_listenips.sh $gw/16

route add -net 239.0.0.0 netmask 255.0.0.0 dev $lan_if
# route add default gw $gw dev $lan_if

$conf_dir/iptables_init.sh $wan_if
miniupnpd -f /etc/miniupnpd/miniupnpd.conf -i $wan_if -a $gw/16 &