#!/bin/sh

#usuage:$0 WlanType[ap, apsta, apap]
WlanType=$1
echo wlan config with wlan type $WlanType

begin_time="Begin   `date`"
#step 1 : load wlan driver begin
rmmod dhd
echo msm_hsic_host > /sys/bus/platform/drivers/msm_hsic_host/unbind
sleep 1
echo msm_hsic_host > /sys/bus/platform/drivers/msm_hsic_host/bind
sleep 1
bcmdl -n /etc/bcm43241/nvram_hsic.txt /etc/bcm43241/fw_hsic.bin.trx
insmod /etc/bcm43241/dhd.ko
#step 1 : load wlan driver   end

export WlanBand=`cfg get wifi_band`
export WlanMode=`cfg get WirelessMode`
export WlanChannel=`cfg get Channel`
export TxpowerMode=`cfg get wifi_coverage`

bcm_wlan_set_txpower()
{
	if [ "$TxpowerMode" = "long_mode" ]; then
		echo "set long mode txpower"
		wl txpwr1 -1 
	elif [ "$TxpowerMode" = "medium_mode" ]; then
		echo "set medium mode txpower"
		wl txpwr1 -o -d 12
	elif [ "$TxpowerMode" = "short_mode" ]; then
		echo "set short mode txpower"
        wl txpwr1 -o -d 9
	else
		echo "set long mode txpower"
        wl txpwr1 -1
	fi
}

#modified by liu peng for Optimization
bcm_wlan_auto_channel()
{
	echo "bcm_wlan_auto_channel function: "
	i=0
	wl down
	wl spect 0
	wl ssid ""
	wl up
	wl autochannel 1
	wl channel
	ret_val=`wl autochannel`
	while [ -z "$ret_val" ]
	do
	    i=$(($i+1))
		usleep 200000
		ret_val=`wl autochannel`
		echo "*  $ret_val"
		if [ "$i" -eq 30 ]; then
			echo "wait 30 times,timeout"
			return
	    fi
	done
	wl autochannel 2
	wl channel	
	wl down
	wl spect 1
	wl up
}

#modified by liu peng for Optimization
bcm_wlan_config_channel()
{
	echo "bcm_wlan_config_channel function:"
	if [ "$WlanChannel" = "0" ]; then
		bcm_wlan_auto_channel
	else
		wl channel $WlanChannel
	fi
}

#modified by liu peng for Optimization
bcm_wlan_config_n_channel()
{
	echo "bcm_wlan_config_n_channel function:"
	ht_cap=`cfg get wifi_11n_cap`
	
	
	wl mimo_bw_cap $ht_cap
	if [ "$WlanBand" = "a" ]; then
		wl obss_coex 0
		wl sgi_tx -1
		wl sgi_rx 3
		wl a_rate auto
		if [ "$WlanChannel" = "0" ]; then
			bcm_wlan_auto_channel
		else
			#Testing
			wl channel $WlanChannel
		fi
		return 0
	fi
	if [ "$ht_cap" = "1" ]; then
		wl obss_coex 1
		wl sgi_tx -1
		wl sgi_rx 3
		wl bg_rate auto
		if [ "$WlanChannel" = "0" ]; then
			bcm_wlan_auto_channel
			return 0
		fi
		if [ "$WlanChannel" -gt "0" ] && [ "$WlanChannel" -lt "7" ]; then
			wl chanspec ${WlanChannel}l
		elif [ "$WlanChannel" -gt "6" ] && [ "$WlanChannel" -lt "14" ]; then
			wl chanspec ${WlanChannel}u
		fi
	else
		wl obss_coex 0
		wl sgi_tx -1
		wl sgi_rx 3
		wl bg_rate auto
		if [ "$WlanChannel" = "0" ]; then
			bcm_wlan_auto_channel
			return 0
		fi
		wl channel $WlanChannel
	fi
}

#modified by liu peng for Optimization
bcm_wlan_config_band_phymode()
{	
	echo "bcm_wlan_config_band_phymode function:"
	if [ "$WlanBand" = "a" ]; then
		wl band a
	else
		wl band b
	fi	
	
	if [ "$WlanMode" = "0" ] && [ "$WlanBand" = "b" ]; then
		echo "config b only (2.4G) mode"
		wl nmode 0
		wl gmode 0
		wl bg_rate auto
		bcm_wlan_config_channel
	elif [ "$WlanMode" = "1" ] && [ "$WlanBand" = "b" ]; then
		echo "config g only (2.4G) mode"
		wl nmode 0
		wl gmode 2
		wl bg_rate auto
		bcm_wlan_config_channel
	elif [ "$WlanMode" = "3" ] && [ "$WlanBand" = "b" ]; then
		echo "config b/g auto (2.4G) mode"
		wl nmode 0
		wl gmode 1
		wl bg_rate auto
		bcm_wlan_config_channel
	elif [ "$WlanMode" = "2" ] && [ "$WlanBand" = "b" ]; then
		echo "config n only(2.4G) mode"
		wl nmode 1
		wl nreqd 1
		bcm_wlan_config_n_channel
	elif [ "$WlanMode" = "2" ] && [ "$WlanBand" = "a" ]; then
		echo "config n only(5G) mode"
		wl nmode 1
		wl nreqd 1
		bcm_wlan_config_n_channel		
	elif [ "$WlanMode" = "4" ] && [ "$WlanBand" = "b" ]; then
		echo "config b/g/n auto(2.4G) mode"
		wl nmode 1
		wl nreqd 0
		bcm_wlan_config_n_channel		
	elif [ "$WlanMode" = "4" ] && [ "$WlanBand" = "a" ]; then
		echo "config a/n auto(5G) mode"
		wl nmode 1
		wl nreqd 0
		bcm_wlan_config_n_channel		
	elif [ "$WlanMode" = "5" ] && [ "$WlanBand" = "a" ]; then
		echo "config a only(5G) mode"
		wl nmode 0
		wl a_rate auto
		bcm_wlan_config_channel
	else
		echo "config a/b/g/n auto mode"
		wl nmode 1
		wl nreqd 0
		bcm_wlan_config_n_channel
	fi
	
}

wait_interface()
{
	echo "wait_interface function: "
	i=0
	interface="$1"
	ifconfig "$interface"
	while true
	do
	i=$(($i+1))
	if [ $? -ne 0 ]; then
		sleep 1
		ifconfig "$interface"
	else
		return
	fi
	if [ "$i" -eq 10 ]; then
		echo "wait 10 seconds for $interface to show up, timeout"
		return
	fi
	done
}

bcm_wlan_config_acl()
{
	echo "bcm_wlan_config_acl function: "
	interface=$1
	acl_mode=`cfg get ACL_mode`
	wl -i $interface mac none
	if [ "$acl_mode" -eq 0 ]; then
		wl -i $interface macmode 0
		return
	elif [ "$acl_mode" -eq 2 ]; then
		wl -i $interface macmode 1
		maclist=`cfg get wifi_mac_black_list`
	elif [ "$acl_mode" -eq 1 ]; then
		wl -i $interface macmode 2
		maclist=`cfg get wifi_mac_white_list`
	else
		wl -i $interface macmode 0
		return
	fi	
	wl -i $interface mac `echo $maclist | sed 's/;/ /g'`
}

#modified by liu peng for Optimization
bcm_wlan_config_security_main()
{
	echo "bcm_wlan_config_security_main function: "
	interface=$1
	cmd="wl -i $interface"
	auth_mode=`cfg get AuthMode`
	encry_type=`cfg get EncrypType`
	if [ "NONE" = "$encry_type" ]; then
		$cmd auth 0
		$cmd wsec 0
	elif [ "WEP" = "$encry_type" ]; then
		if [ "SHARED" = "$auth_mode" ]; then
			$cmd auth 1
		else
			$cmd auth 0
		fi
		$cmd wsec 1
		$cmd wpa_auth 0
		$cmd sup_wpa 0
		key_id=`cfg get DefaultKeyID`
		wep_key=`cfg get Key$(($key_id+1))Str1`
		$cmd addwep $key_id $wep_key
		$cmd primary_key $key_id
	elif [ "TKIP" = "$encry_type" ]; then		
		if [ "WPAPSK" = "$auth_mode" ]; then
			$cmd wpa_auth 4
		elif [ "WPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 128
		elif [ "WPAPSKWPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 132
		else
			$cmd wpa_auth 4
		fi
		$cmd wsec 2
		$cmd sup_wpa 1
		$cmd auth 0 
		$cmd set_pmk `cfg get WPAPSK1`			
	elif [ "CCMP" = "$encry_type" ]; then
		if [ "WPAPSK" = "$auth_mode" ]; then
			$cmd wpa_auth 4
		elif [ "WPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 128
		elif [ "WPAPSKWPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 132
		else
			$cmd wpa_auth 128
		fi
		$cmd wsec 4
		$cmd sup_wpa 1
		$cmd auth 0
		$cmd set_pmk `cfg get WPAPSK1`
	else
		if [ "WPAPSK" = "$auth_mode" ]; then
			$cmd wpa_auth 4
		elif [ "WPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 128
		elif [ "WPAPSKWPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 132
		else
			$cmd wpa_auth 132
		fi
		$cmd wsec 6
		$cmd sup_wpa 1
		$cmd auth 0
		$cmd set_pmk `cfg get WPAPSK1`
	fi
}

#modified by liu peng for Optimization
bcm_wlan_config_security_sub()
{
	echo "bcm_wlan_config_security_sub function:"
	interface=$1
	cmd="wl -i $interface"
	auth_mode=`cfg get m_AuthMode`
	encry_type=`cfg get m_EncrypType`
	if [ "NONE" = "$encry_type" ]; then
		$cmd auth 0
		$cmd wsec 0
	elif [ "WEP" = "$encry_type" ]; then
		if [ "SHARED" = "$auth_mode" ]; then
			$cmd auth 1
		else
			$cmd auth 0
		fi
		$cmd wsec 1
		$cmd wpa_auth 0
		$cmd sup_wpa 0
		key_id=`cfg get m_DefaultKeyID`
		wep_key=`cfg get m_Key$(($key_id+1))Str1`
		$cmd addwep $key_id $wep_key
		$cmd primary_key $key_id
	elif [ "TKIP" = "$encry_type" ]; then		
		if [ "WPAPSK" = "$auth_mode" ]; then
			$cmd wpa_auth 4
		elif [ "WPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 128
		elif [ "WPAPSKWPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 132
		else
			$cmd wpa_auth 4
		fi
		$cmd wsec 2
		$cmd sup_wpa 1
		$cmd auth 0
		$cmd set_pmk `cfg get m_WPAPSK1`			
	elif [ "CCMP" = "$encry_type" ]; then
		if [ "WPAPSK" = "$auth_mode" ]; then
			$cmd wpa_auth 4
		elif [ "WPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 128
		elif [ "WPAPSKWPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 132
		else
			$cmd wpa_auth 128
		fi
		$cmd wsec 4
		$cmd sup_wpa 1
		$cmd auth 0
		$cmd set_pmk `cfg get m_WPAPSK1`
	else
		if [ "WPAPSK" = "$auth_mode" ]; then
			$cmd wpa_auth 4
		elif [ "WPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 128
		elif [ "WPAPSKWPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 132
		else
			$cmd wpa_auth 132
		fi
		$cmd wsec 6
		$cmd sup_wpa 1
		$cmd auth 0
		$cmd set_pmk `cfg get m_WPAPSK1`
	fi

}

#step 2 : send wlan parameter begin

#Remove old interface from bridge if needed
wl ver
brctl delif bridge0 eth0
brctl delif bridge0 wl0.1
ifconfig eth0 up
ifconfig wl0.1 down

if [ "$WlanType" = "apsta" ]; then
	#Turn off the radio
	wl down
	
	#Configure the WiFi working mode: AP-STA
	wl ap 1
	wl apsta 1
	wl mbss 1
	wl mpc 0

	#Configure the country, channel,and the 802.11 mode
	wl country `cfg get CountryCode`
	bcm_wlan_config_band_phymode
	#wl bg_rate auto	
	
	#Configure the encryption information, SSID feature
	max_access_stas=`cfg get MAX_Access_num`
	echo "max_access_stas = $max_access_stas"
	wl maxassoc $max_access_stas
	
	#create the interface
	wl bss -C 1 down
	wl ssid -C 1 "`cfg get SSID1`"
	wait_interface "wl0.1"
	
	#set encryption
	bcm_wlan_config_security_main "wl0.1"	
	echo "config security done"
	
	#set other feature
	wl -i wl0.1 closed `cfg get HideSSID`	
	wl -i wl0.1 ap_isolate `cfg get NoForwarding`
	wl -i wl0.1 bss_maxassoc `cfg get MAX_Access_num`
	
	#set mac filter
	bcm_wlan_config_acl "wl0.1"
	echo "config acl done"
	
	#Take all parameter effect
	wl down
	wl up
	usleep 200000
	wl bss -C 1 up	
	
	#Do extra work accordingly
	#ifconfig wl0.1 hw ether `wl -i wl0.1 cur_etheraddr | cut -b 15-32`
	brctl addif bridge0 wl0.1
	ifconfig wl0.1 up
	bcm_wlan_set_txpower
	
	#For STA -- eth0
	wpa_supplicant -ieth0 -Dwext -dddd -c/usr/zte/zte_conf/config/wpa_supplicant.conf -lwpa_supplicant.log&
	
elif [ "$WlanType" = "ap" ]; then
	#Turn off the radio
	wl down
	
	#Configure the WiFi working mode: AP-Only
	wl ap 1
	wl apsta 0
	wl mbss 0
	wl mpc 0
	
	#Configure the country, channel,and the 802.11 mode
	countryCode=`cfg get CountryCode`
	echo "countryCode = $countryCode"
	wl country 	$countryCode
	bcm_wlan_config_band_phymode
	
	#Configure the encryption information, SSID feature
	max_access_stas=`cfg get MAX_Access_num`
	echo "max_access_stas = $max_access_stas"
	wl maxassoc $max_access_stas
	
	#create the interface
	wl bss -C 0 down
	wl ssid -C 0 "`cfg get SSID1`"
	wait_interface "eth0"
	
	#set encryption
	bcm_wlan_config_security_main "eth0"
	echo "config security done"
	
	#set other feature
	wl -i eth0 closed `cfg get HideSSID`
	wl -i eth0 ap_isolate `cfg get NoForwarding`
	wl -i eth0 bss_maxassoc `cfg get MAX_Access_num`
	
	#set mac filter
	bcm_wlan_config_acl "eth0"	
	echo "config acl done"	
	
	#Take all parameter effect
	wl down
	wl up
	usleep 200000
	wl bss -C 0 up
	
	#Do extra work accordingly
	#ifconfig eth0 hw ether `wl -i eth0 cur_etheraddr | cut -b 15-32`
	brctl addif bridge0 eth0
	ifconfig eth0 up
	bcm_wlan_set_txpower
elif [ "$WlanType" = "apap" ]; then
	#Turn off the radio
	wl down
	
	#Configure the WiFi working mode: AP-Only
	wl ap 1
	wl apsta 0
	wl mbss 1
	wl mpc 0
	
	#Configure the country, channel,and the 802.11 mode
	countryCode=`cfg get CountryCode`
	echo "countryCode = $countryCode"
	wl country 	$countryCode
	bcm_wlan_config_band_phymode	

	#Configure the encryption information, SSID feature
	max_access_stas1=`cfg get MAX_Access_num`
	max_access_stas2=`cfg get m_MAX_Access_num`
	max_access_stas=`expr $max_access_stas1 + $max_access_stas2`
	echo "max_access_stas = $max_access_stas"
	wl maxassoc $max_access_stas
	
	## configure the sub interface -- eth0
	# create the interface 
	wl bss -C 0 down
	wl ssid -C 0 "`cfg get m_SSID`"
	wait_interface "eth0"
	
	# set encryption
	bcm_wlan_config_security_sub "eth0"
	
	#set other feature
	wl -i eth0 closed `cfg get m_HideSSID`	
	wl -i eth0 ap_isolate `cfg get m_NoForwarding`
	wl -i eth0 bss_maxassoc `cfg get m_MAX_Access_num`
	
	# set mac filter
	bcm_wlan_config_acl "eth0"		
	
	## configure the main interface -- wl0.1
	# create the interface
	wl bss -C 1 down
	wl ssid -C 1 "`cfg get SSID1`"
	wait_interface "wl0.1"
	
	# set encryption
	bcm_wlan_config_security_main "wl0.1"
	
	# set other feature 
	wl -i wl0.1 closed `cfg get HideSSID`	
	wl -i wl0.1 ap_isolate `cfg get NoForwarding`
	wl -i wl0.1 bss_maxassoc `cfg get MAX_Access_num`
	
	# set mac filter
	bcm_wlan_config_acl "wl0.1"		
	
	## Take all parameter effect
	wl down
	wl up
	usleep 200000
	# enable the interface, and note enable the second interface first!!!
	wl bss -C 1 up
	wl bss -C 0 up
	
	## Do extra work accordingly 
	#ifconfig eth0 hw ether `wl -i eth0 cur_etheraddr | cut -b 15-32`
	brctl addif bridge0 eth0
	ifconfig eth0 up 	
	
	#ifconfig wl0.1 hw ether `wl -i wl0.1 cur_etheraddr | cut -b 15-32`
	brctl addif bridge0 wl0.1
	ifconfig wl0.1 up 
	
	bcm_wlan_set_txpower
fi

echo $begin_time
echo "End   `date`"
#step 2 : send wlan parameter   end

