#!/system/bin/busybox sh
# ===========================================================
# bridge_setup.sh
# create by zhangyuelong10100551 2012.5.2

mod_dss='dss'
ppp_mod=`cfg get ppp_dial_method`
#for mtk wifi ap interface begin
if_ap='ap0'
cfg set wifi_ap_net=$if_ap
#for station
#if_sta='sta0'
#cfg set wifi_ap_net=$if_sta
# end

if [ "$mod_dss" = "$ppp_mod" ]
then
  echo "bridge_setup.sh: good, mode[$ppp_mod]"
else
  echo "bridge_setup.sh: not dss mode, maybe sap!"
#  exit
fi

busybox ifconfig usb0 0.0.0.0
busybox ifconfig usb0 up
# here we setup br0, and add eth0 usb0 to br0
if [ -d "/sys/class/net/br0" ]
then
  echo "bridge_setup.sh: br0 exist ..."
else
  echo "bridge_setup.sh: setup br0 ..."
  busybox brctl addbr br0
  busybox brctl addif br0 usb0
fi

station_mod=$1

ap_stat_mod='apsta'
if_sta=`cfg get wifi_sta_net`
if_ap=`cfg get wifi_ap_net`
if_map='wl0.1'
cur_mod=`cfg get apsta_type`

echo "bridge_setup.sh: cur_mod[$cur_mod], if_ap[$if_ap], if_map[$if_map],apsta_type[$apsta_type]..."

if [ "bridge" = "$station_mod" ]
then
  busybox ifconfig $if_sta 0.0.0.0
  busybox ifconfig $if_sta up
  busybox brctl addif br0 $if_sta  
elif [ "$cur_mod" = "ap" ] 
  busybox ifconfig $if_ap up
  busybox brctl addif br0 $if_ap
  busybox ifconfig $if_ap 0.0.0.0
then
  echo "bridge_setup.sh: router mod, del[$if_sta] from bridge "
  busybox brctl delif br0 $if_sta    
  #busybox ifconfig $if_stat down
fi



if [ "$cur_mod" = "$ap_stat_mod" ]
then
busybox ifconfig $if_ap up
busybox brctl addif br0 $if_ap
busybox ifconfig $if_ap 0.0.0.0
fi


if [ "$ap_stat_mod" = "$cur_mod" ]
then
  echo "bridge_setup.sh: apsta mod, no up if_map"
else
  busybox ifconfig $if_map up
fi

if [ "$ap_stat_mod" = "$cur_mod" ]
then
  echo "bridge_setup.sh: apsta mod, del if_map from bridge "
  busybox brctl delif br0 $if_map
else
  busybox ifconfig $if_map 0.0.0.0  
  busybox brctl addif br0 $if_map 
fi

#lan_ipaddr=`cfg get lan_ipaddr_for_current`
lan_ipaddr=`cfg get lan_ipaddr`
echo "bridge_setup.sh: here bridge get lan ip is $lan_ipaddr"
mask=`cfg get lan_netmask`
busybox ifconfig br0 $lan_ipaddr netmask $mask up
# =============================================================
