#!/bin/sh 
## 
# $Id: zte_qrcode_create.sh,v 0.0.0.1 2013.05.06 liuweipeng Exp $ 
# 
# usage: zte_qrcode_create.sh
# 

wifi_ssid_qrcode_name='/mnt/zte/zte_conf/qrcode_ssid_wifikey.png'
multi_wifi_ssid_qrcode_name='/mnt/zte/zte_conf/qrcode_multi_ssid_wifikey.png'

local_domain_qrcode_name='/mnt/zte/zte_conf/qrcode_local_domaind.png'



############zte qrcode create shell entry#################

case $1 in 
 "wifi_create") 
   
 	echo "enter the wifi_create function"
	
	rm -rf  $wifi_ssid_qrcode_name
	
	wifi_ssid_name=`cfg get SSID1`	 # wifi ssid 
	wifi_auth_mode=`cfg get AuthMode`  # wifi auth mode 
	wifi_encry_type=`cfg get EncrypType` #wifi encry type
	wifi_password=`cfg get WPAPSK1`  #wifi password

	auth_wpa=`echo $wifi_auth_mode | sed  -n '/WPA/p'`
	
	if [ -n "$auth_wpa" ];then  # wpa
		qrcode_text='WIFI:T:WPA;S:'$wifi_ssid_name';P:'$wifi_password';'
		echo "qrcode_text = $qrcode_text"
	elif [ "$wifi_encry_type" = "WEP" ];then
		qrcode_text='WIFI:T:WEP;S:'$wifi_ssid_name';P:'$wifi_password';'
		echo "qrcode_text = $qrcode_text"
	elif [ "$wifi_encry_type" = "NONE" ];then
		qrcode_text='WIFI:S:'$wifi_ssid_name';'
		echo "qrcode_text = $qrcode_text"	
	else
		echo "the auth_wpa is NULL or values is wrong"	
		qrcode_text=' '
	fi
	
	qrencode -o $wifi_ssid_qrcode_name "$qrcode_text"
	
	
	;;
 
 "multi_wifi_create") 
	echo "enter the multi_wifi_create function"
	
	rm -rf  $multi_wifi_ssid_qrcode_name
	
	multi_wifi_ssid_name=`cfg get m_SSID`	  # multi wifi ssid 
	multi_wifi_auth_mode=`cfg get m_AuthMode`  #multi wifi auth mode 
	multi_wifi_encry_type=`cfg get m_EncrypType` #multi wifi encry type
	multi_wifi_password=`cfg get m_WPAPSK1`  #multi wifi password
	
	auth_wpa=`echo $multi_wifi_auth_mode | sed  -n '/WPA/p'`
		
	if [ -n "$auth_wpa" ];then  # wpa
		qrcode_text='WIFI:T:WPA;S:'$multi_wifi_ssid_name';P:'$multi_wifi_password';'
		echo "qrcode_text = $qrcode_text"
	elif [ "$multi_wifi_encry_type" = "WEP" ];then
		qrcode_text='WIFI:T:WEP;S:'$multi_wifi_ssid_name';P:'$multi_wifi_password';'
		echo "qrcode_text = $qrcode_text"
	elif [ "$multi_wifi_encry_type" = "NONE" ];then
		qrcode_text='WIFI:S:'$multi_wifi_ssid_name';'
		echo "qrcode_text = $qrcode_text"	
	else
		echo "the auth_wpa is NULL or values is wrong"	
		qrcode_text=' '
	fi
	
	qrencode -o $multi_wifi_ssid_qrcode_name "$qrcode_text"
	
	;;
	
 "local_domain_create") 
	echo "enter the local_url_create function"
	
	rm -rf  $local_domain_qrcode_name
	
	local_domain_url=`cfg get LocalDomain`	  #local domain name
	local_domain_username=`cfg get admin_user`  #local domain username
	local_domain_passwd=`cfg get admin_Password` #local domain password	
 
	qrcode_text='http://'$local_domain_url
	echo "qrcode_text = $qrcode_text"	
			
	qrencode -o $local_domain_qrcode_name "$qrcode_text"
 
	;;
esac