#!/bin/busybox sh

#set up usb0
busybox ifconfig usb0 0.0.0.0
busybox ifconfig usb0 up
# here we setup br0, and add usb0 to br0
if [ -d "/sys/class/net/br0" ]
then
  echo "bridge_setup.sh: br0 exist ..."
else
  echo "bridge_setup.sh: setup br0 ..."
  busybox brctl addbr br0
  busybox brctl addif br0 usb0
fi

lan_ipaddr=`cfg get lan_ipaddr`
echo "usb0_setup.sh: here bridge get lan ip is $lan_ipaddr"
mask=`cfg get lan_netmask`
busybox ifconfig br0 $lan_ipaddr netmask $mask up

#check dhcp is enabled
dhcp_enable=`cfg get dhcpEnabled`

if [ "$dhcp_enable" = "1" ]
then
	killall -9 dnsmasq
	mknod /dev/urandom c 1 9
	dnsmasq -C /mnt/zte/zte_conf/config/dnsmasq.conf
fi


