﻿/**
 * STK module
 *
 * @module STK
 * @class STK
 */
define([ 'jquery', 'service', 'knockout'], function ($, service, ko) {

    var menu_num_array = [];
    var menu_name_array = [];
    var input_str_array = [];
    var menu_name;
    var isPopuping = false;

    /**
     * @class STKInformationViewModel
     * @constructor
     */
    function StkInformationViewModel() {
        var self = this;
        self.STKInfo = ko.observable();
        self.menu_name_array_0 = ko.observable();
        self.stkMessageText = ko.observable();
        self.main_menu_infos = ko.observableArray();
        self.radio_select_submit_value = ko.observable("");
        self.child_menu_radio_value = ko.observable("");

        var main_menu_info_arr = [];

        function push_menu_info() {
            main_menu_info_arr = [];
            for (k = 0; k < menu_num_array[0]; k++) {
                i = k + 1;
                var obj = {};
                obj.main_menu_value = stk_codeChange_main(menu_name_array[i]);
                obj.main_num_value = menu_num_array[i];
                main_menu_info_arr.push(obj);
            }
        }

        function analyse_string(menu_name_str, i) {
            menu_num_array[i] = menu_name_str.substr(0, menu_name_str.indexOf(","));
            menu_name = menu_name_str.substr(menu_name_str.indexOf(",") + 1);
            menu_name_array[i] = menu_name_str.substr(menu_name_str.indexOf(",") + 1);
        }

        function stk_codeChange_main(str) {
            var len_str = str.length;
            if (str.substr(0, 2) == "80") {
                return bytesToUnicode(str.substr(2, len_str));
            } else {
                return decoding_ASCII(str);
            }
        }

        function bytesToUnicode(bs) {
            var result = "";
            if (bs == "" || bs == null) {
                return result;
            }
            for (var i = 0; i < bs.length; i += 4) {
                var subbs = bs.substring(i, i + 4);
                var subbs_int = parseInt(subbs, 16);
                result += String.fromCharCode(subbs_int);
            }
            return result;
        }

        function decoding_ASCII(num_string) {
            var subbs = "";
            var subbs_int = "";
            var result = "";
            for (var i = 0; i < num_string.length; i += 2) {
                subbs = num_string.substring(i, i + 2);
                subbs_int = parseInt(subbs, 16);
                result += String.fromCharCode(subbs_int);
            }
            return result;
        }

        self.select_main_menu = function (main_menu_info) {
            page_num_submit = main_menu_info.main_num_value;
            showLoading();
            var params = {};
            params.operator = "stk_menu";
            params.item_no = page_num_submit;
            service.setSTKMenuInfo(params, function (result) {
                hideLoading();
                if (result.result == "success") {
                    loadSTKWriteFlag();
                } else {
                    errorOverlay();
                }
            });
        };

        self.select_main_menu_radio = function () {
            if (self.radio_select_submit_value() == "") {
                return;
            }
            showLoading();
            var params = {};
            params.operator = "stk_menu";
            params.item_no = self.radio_select_submit_value();
            service.setSTKMenuInfo(params, function (result) {
                hideLoading();
                if (result.result == "success") {
                    loadSTKWriteFlag();
                } else {
                    errorOverlay();
                }
            });
        };

        function stk_codeChange_text(stkMessageText) {
            var len_str = stkMessageText.length;
            if (stkMessageText.substr(2, 2) == "80") {
                return bytesToUnicode(stkMessageText.substr(4, len_str - 4) + '');
            } else {
                return decoding_ASCII(stkMessageText.substr(2, len_str - 2) + '');
            }
        }

        self.submit_text = function () {
            showLoading();
            service.setSTKMenuInfo({operator: "stk_text"}, function (result) {
                hideLoading();
                if (result.result == "success") {
                    loadSTKWriteFlag();
                } else {
                    errorOverlay();
                }
            });
        };

        self.back_submit_button = function () {
            showLoading();
            $("#input_content").val("");
            service.setSTKMenuInfo({operator: "stk_back"}, function (result) {
                hideLoading();
                if (result.result == "success") {
                    loadSTKWriteFlag();
                } else {
                    errorOverlay();
                }
            });
        };

        function cut_down_number(value_stk) {
            var str = value_stk.toString();
            var i = 0;
            var menu_name_str_end;
            var menu_name_str;
            while (str) {
                menu_name_str_end = str.indexOf(";");
                menu_name_str = str.substr(0, menu_name_str_end);
                str = str.substr(menu_name_str_end + 1);
                if (menu_name_str != "") {
                    analyse_string(menu_name_str, i);
                    i++;
                } else {
                    break;
                }
            }
        }

        function writeHTML() {
            var i;
            for (var k = 0; k < menu_num_array[0]; k++) {
                i = k + 1;
                $("#menu_child_" + i).val(stk_codeChange_main(menu_name_array[i]));
            }
        }

        self.select_menu_item = function (main_menu_info) {
            showLoading();
            var params = {
                operator: "stk_menu_item",
                item_no: main_menu_info.main_num_value
            };
            service.setSTKMenuInfo(params, function (result) {
                hideLoading();
                if (result.result == "success") {
                    loadSTKWriteFlag();
                } else {
                    errorOverlay();
                }
            });
        };

        self.select_main_item_radio = function () {
            if (self.child_menu_radio_value() == "") {
                return;
            }
            showLoading();
            var params = {
                operator: "stk_menu_item",
                item_no: self.child_menu_radio_value()
            };
            service.setSTKMenuInfo(params, function (result) {
                hideLoading();
                if (result.result == "success") {
                    loadSTKWriteFlag();
                } else {
                    errorOverlay();
                }
            });
        };

        self.exit_submit_button = function () {
            showLoading();
            service.setSTKMenuInfo({operator: "stk_exit"}, function (result) {
                hideLoading();
                if (result.result == "success") {
                    loadSTKWriteFlag();
                } else {
                    errorOverlay();
                }
            });
        };

        function exit_submit_init() {
            showLoading();
            service.setSTKMenuInfo({operator: "stk_exit"}, function (result) {
                hideLoading();
                if (result.result != "success") {
                    errorOverlay();
                }
            });
        }

        function stk_codeChange_message(stkMessageText) {
            var len_str = stkMessageText.length;
            var new_str = "";
            if (stkMessageText == "#") {
                new_str = "Message Sending";
            } else {
                if (stkMessageText.substr(0, 2) == "80") {
                    new_str = bytesToUnicode(stkMessageText.substr(2, len_str));
                } else {
                    new_str = decoding_ASCII(stkMessageText);
                }
            }
            return new_str;
        }

        self.submit_text_ZSMSR = function () {
            showLoading();
            loadSTKWriteFlag();
        };

        function stk_codeChange_input(value_stk) {
            var i = 0;
            var str = value_stk.toString();
            while (str) {
                var str_end = str.indexOf(",");
                if (str_end != -1) {
                    str = str.substr(str_end + 1);
                    input_str_array[i] = str.substr(0, str_end);
                } else {
                    input_str_array[i] = str;
                    break;
                }
                i++;
            }
            var len_str = input_str_array[0].length;
            if (input_str_array[0].substr(0, 2) == "80") {
                input_str_array[0] = input_str_array[0].substr(2, len_str);
                input_str_array[0] = bytesToUnicode(input_str_array[0]);
                return input_str_array[0];
            }
            else {
                input_str_array[0] = decoding_ASCII(input_str_array[0]);
                return input_str_array[0];
            }
        }

        function text_style() {
            var length = parseInt(input_str_array[2]);
            if (length > 35) {
                document.getElementById("input_content").rows = "4";
            } else {
                document.getElementById("input_content").rows = "1";
            }
        }

        function initInputBox() {
            $("#input_max").html(input_str_array[2]);
            $("#input_min").html(input_str_array[3]);
        }

        function update_maxNum() {
            var $inputContent = $("#input_content");
            var content = $inputContent.val();
            var unicodeNum = parseInt(input_str_array[2] / 2, 10);
            var $inputMax = $("#input_max");
            if ("" == content) {
                $inputMax.html(input_str_array[2]);
            } else {
                var isUnicode = encodeType(content);
                if ("UNICODE" == isUnicode) {
                    $inputMax.html(unicodeNum);
                    if (content.length > unicodeNum) {
                        $inputContent.val(content.substr(0, unicodeNum));
                        alert($.i18n.prop("input_too_long"));
                    } else {
                        $inputMax.html(unicodeNum);
                    }
                } else {
                    $inputMax.html(input_str_array[2]);
                    if (content.length > input_str_array[2]) {
                        $inputContent.val(content.substr(0, input_str_array[2]));
                        alert($.i18n.prop("input_too_long"));
                    } else {
                        $inputMax.html(input_str_array[2]);
                    }
                }
            }
        }

        function encodeType(input) {
            var flag = "ASCII";
            if (input == null || input == "") {
                return flag;
            }
            for (var i = 0; i < input.length; i++) {
                var c = input.charCodeAt(i).toString(16);
                if (c.length >= 3) {
                    flag = "UNICODE";
                    break;
                }
            }
            return flag;
        }

        function isRightNum() {
            var input = $("#input_content").val();
            var strLen = input.length;
            var tmpChar, i;

            for (i = 0; i < strLen; i++) {
                tmpChar = input.charAt(i);
                if ((tmpChar == "0") || (tmpChar == "1") || (tmpChar == "2") ||
                    (tmpChar == "3") || (tmpChar == "4") || (tmpChar == "5") ||
                    (tmpChar == "6") || (tmpChar == "7") || (tmpChar == "8") ||
                    (tmpChar == "9") || (tmpChar == "#") || (tmpChar == "*") ||
                    (tmpChar == "+")) {
                    //continue;
                } else {
                    return false;
                }
            }
            return true;
        }

        window.stkUtil = {
            input_apply: function () {
                var $inputContent = $("#input_content");
                var input = $inputContent.val();
                $inputContent.val("");

                if (input.length < input_str_array[3]) {
                    alert($.i18n.prop("input_too_short"));
                    return false;
                }
                if (input.length > input_str_array[2]) {
                    alert($.i18n.prop("input_too_long"));
                    return false;
                }

                if (input_str_array[1] == 3) {
                    input = input_coding_UNICODE(input);
                } else if (input_str_array[1] == 2) {
                    if (isRightNum() == false) {
                        alert($.i18n.prop("form_number_wrong"));
                        return false;
                    }
                } else if (input_str_array[1] == 0) {
                    input = input_coding_ASCII(input);
                }

                showLoading();
                var params = {};
                params.operator = "stk_get_input";
                params.stk_content = input;
                params.stk_encode_type = input_str_array[1];
                service.setSTKMenuInfo(params, function (result) {
                    hideLoading();
                    if (result.result == "success") {
                        loadSTKWriteFlag();
                    } else {
                        errorOverlay();
                    }
                });
                return true;
            },
            input_update: function () {
                if (input_str_array[1] == 3) {
                    update_maxNum();
                } else if (input_str_array[1] == 2) {
                    isRightNum();
                }
            }
        };

        function input_coding_UNICODE(input) {
            var UNICODE_encode = "";
            for (var i = 0; i < input.length; i++) {
                var c = input.charCodeAt(i).toString(16);
                if (c.length == 1) {
                    c = "000" + c;
                } else if (c.length == 2) {
                    c = "00" + c;
                } else if (c.length == 3) {
                    c = "0" + c;
                }
                UNICODE_encode = UNICODE_encode + c;
            }
            return UNICODE_encode.toUpperCase();
        }

        function input_coding_ASCII(input) {
            var ASCII_encode = "";
            for (var i = 0; i < input.length; i++) {
                var c = input.charCodeAt(i).toString(16);
                if (c.length == 2) {
                    ASCII_encode += c;
                } else if (c.length == 1) {
                    ASCII_encode += "0" + c;
                }
            }
            return ASCII_encode.toUpperCase();
        }

        function loadSTKWriteFlag() {
            var STKFlag = service.getSTKFlagInfo().stk_write_flag;
            if ("2" != STKFlag && "9" != STKFlag) {
                isPopuping = false;
                hideLoading();
            }
            var name_stk;
            var value_stk;
            var stk = service.getSTKInfo().stk.toString();
            if ("ZEND" == stk.toUpperCase()) {
                name_stk = stk;
            } else {
                name_stk = stk.substr(0, stk.indexOf(":"));
                value_stk = stk.substr(stk.indexOf(":") + 1);
            }
            var STKMenu = service.getSTKMenuInfo().stk_menu.toString();
            var name_STKMenu = STKMenu.substr(0, STKMenu.indexOf(":"));
            var value_STKMenu = STKMenu.substr(STKMenu.indexOf(":") + 1);
            if ("99" == STKFlag) {
                self.STKInfo(0);
            } else if ("1" == STKFlag) {
                self.STKInfo(1);
            } else if ("2" == STKFlag || "9" == STKFlag) {
                if (!isPopuping) {
                    isPopuping = true;
                    showLoading();
                }
                addTimeout(loadSTKWriteFlag, 1000);
            } else if ("3" == STKFlag) {
                cut_down_number(value_STKMenu);
                push_menu_info();
                self.menu_name_array_0(stk_codeChange_main(menu_name_array[0]));
                self.main_menu_infos(main_menu_info_arr);
                self.STKInfo(2);
            } else if ("0" == STKFlag) {
                if ("ZSTM" == name_stk) {
                    cut_down_number(value_STKMenu);
                    push_menu_info();
                    self.menu_name_array_0(stk_codeChange_main(menu_name_array[0]));
                    self.main_menu_infos(main_menu_info_arr);
                    self.STKInfo(2);
                } else if ("ZDIST" == name_stk || "ZFDIST" == name_stk) {
                    self.stkMessageText(stk_codeChange_text(value_stk));
                    self.STKInfo(3);
                } else if ("ZSTI" == name_stk) {
                    cut_down_number(value_stk);
                    push_menu_info();
                    if (menu_name_array[0] == "#") {
                        menu_name_array[0] = "";
                    } else {
                        self.menu_name_array_0(stk_codeChange_main(menu_name_array[0]));
                        self.main_menu_infos(main_menu_info_arr);
                    }
                    self.STKInfo(4);
                } else if ("ZSMSR" == name_stk) {
                    push_menu_info();
                    self.menu_name_array_0(stk_codeChange_message(value_stk));
                    self.STKInfo(5);
                } else if ("ZGINP" == name_stk) {
                    stk_codeChange_input(value_stk);
                    self.menu_name_array_0(input_str_array[0]);
                    text_style();
                    initInputBox();
                    self.STKInfo(6);
                } else if ("ZEND" == name_stk) {
                    self.STKInfo(2);
                    cut_down_number(value_STKMenu);
                    push_menu_info();
                    self.menu_name_array_0(stk_codeChange_main(menu_name_array[0]));
                    self.main_menu_infos(main_menu_info_arr);
                }
            } else {
                self.STKInfo(0);
            }
        }

        exit_submit_init();
        loadSTKWriteFlag();
    }

    /**
     * 初始化
     * @method init
     */
    function init() {
        var container = $('#container')[0];
        ko.cleanNode(container);
        var vm = new StkInformationViewModel();
        ko.applyBindings(vm, container);
    }

    return {
        init: init
    };
});