#!/bin/sh

DEBUG_DIR=/data/debug
DTMF_DEBUG_FILE=/data/debug/flag

killall aplay
killall arec

para1=$1

if [ "$para1" = "-S" ]
then
  echo "Start CS Voice setting using alsaucm_test"
  echo "set _dismod Play VoLTE" > /data/alsaucm_test
  echo "set _enamod Play Voice" > /data/alsaucm_test
  sleep 2
else
  echo "Because CS Voice state is still on, so don't set again"
fi

amix 'AUX_PCM_RX Audio Mixer MultiMedia1' 0
amix 'MultiMedia1 Mixer AUX_PCM_UL_TX' 0
amix 'Voice Topology Disable' 0 281022464
amix 'HPCM_Voice tappoint direction samplerate' 2 2 8000
echo txgain 18 > /sys/devices/f9924000.spi/spi_master/spi0/spi0.0/slic/slic-0/ioctl
#echo rxgain 18 > /sys/devices/f9924000.spi/spi_master/spi0/spi0.0/slic/slic-0/ioctl
sleep 1
aplay -D hw:0,2 -P 1>>/data/voice.log 2>&1 &
arec -D hw:0,2 -P -R 8000 -C 1 1>>/data/voice.log 2>&1 &
sleep 2

if [ ! -f "$DTMF_DEBUG_FILE" ]; then
   #the normal command
   arec -Z -D hw:0,11 -R 8000 -C 1 | aplay -D hw:0,12 -R 8000 -C 1 &
else
   #the debug command
   time=$(cat $DTMF_DEBUG_FILE)
   arec -Z -V -S 2 -T $time -D hw:0,11 -R 8000 -C 1 2>>$DEBUG_DIR/dtmf.log | aplay -D hw:0,12 -R 8000 -C 1 &
fi

