#!/bin/sh
#
# 
#
# usage: for dynamic dns set
# added by myc for ddns set

u=`cfg get DDNSAccount`
pw=`cfg get DDNSPassword`
srv=`cfg get DDNSProvider`
ddns=`cfg get DDNS`
ddns_hash=`cfg get DDNS_Hash_Value`
ddns_enable=`cfg get DDNS_Enable`

killall -9 zte_topsw_ddns

if [ "$ddns_enable" = "0" ]; then
	echo "ddns_set.sh: ddns enable is off, exit"
	exit 0
fi

if [ "$srv" = "" -o "$srv" = "none" ]; then
	echo "ddns_set.sh: $ddns_provider is null, exit"
	exit 0
fi

if [ "$ddns" = "" -o "$u" = "" -o "$pw" = "" ]; then
	exit 0
fi

echo "srv=$srv"
echo "ddns=$ddns"
echo "ddns_hash=$ddns_hash"
echo "u=$u"
echo "pw=$pw"

if [ "$srv" = "dyndns.org" ]; then
	zte_topsw_ddns -u $u -p $pw -a $ddns --dyndns_system dyndns@$srv &
elif [ "$srv" = "freedns.afraid.org" ]; then
	zte_topsw_ddns -u $u -p $pw -a $ddns,$ddns_hash --dyndns_system default@$srv &
elif [ "$srv" = "zoneedit.com" ]; then
	zte_topsw_ddns -u $u -p $pw -a $ddns --dyndns_system default@$srv &
elif [ "$srv" = "no-ip.com" ]; then
	zte_topsw_ddns -u $u -p $pw -a $ddns --dyndns_system default@$srv &
else
	zte_topsw_ddns -u $u -p $pw -a $ddns --dyndns_system default@$srv &
	echo "unknown DDNS provider: $srv"
fi
