#!/bin/sh
# ===========================================================
# usb0_2_bridge.sh
# create by zhangyuelong10100551 2012.6.26

echo "usb0_2_bridge.sh.sh: start..."

# here we check if datacard(nat) mode
product_type=`cfg get product_type`

# only data card mode
if [ "ONLY_DATA_CARD" = "$product_type" ]
then
  echo "usb0_2_bridge.sh: $product_type only data card mode, exit"
  exit
else
  echo "usb0_2_bridge.sh: $product_type will check product type further"
fi

# datacard(nat), just setup usb0
if [ "NO_DRIVER_DATA_CARD" = "$product_type" -o "DRIVER_DATA_CARD" = "$product_type" ]
then
  echo "usb0_2_bridge.sh: $product_type host(less) datacard, just setup usb0"
  usb_ipaddr=`cfg get lan_ipaddr_for_current`
  ifconfig usb0 $usb_ipaddr up
# xiu mian huanxing, pc usb xiumian shihou daidian, radish youyu meiyou usb0 er tuichu
  sh /usr/zte/zte_conf/scripts/ipv6_init.sh
  exit
else
  echo "usb0_2_bridge.sh: need set bridge0, just go"
fi

# here we setup bridge0, and add usb0 to bridge0
if [ -d "/sys/class/net/bridge0" ]
then
  echo "usb0_2_bridge.sh: bridge0 exist ..."
else
  echo "usb0_2_bridge.sh: setup bridge0 ..."
  brctl addbr bridge0
  lan_ipaddr=`cfg get lan_ipaddr_for_current`
  lan_netmask=`cfg get lan_netmask`
  echo "usb0_2_bridge.sh: here bridge get lan ip is $lan_ipaddr"
  ifconfig bridge0 $lan_ipaddr netmask $lan_netmask up
  echo 1 > /proc/sys/net/ipv4/conf/bridge0/proxy_arp
  iptables -A FORWARD --in-interface bridge0 -j ACCEPT
fi

echo "usb0_2_bridge.sh: ifup usb0 iface  ..."
ifconfig usb0 169.254.3.1 netmask 255.255.255.0 up
route del -net 169.254.3.0 netmask 255.255.255.0 dev usb0
ip -6 route del fe80::/64 dev usb0
echo "usb0_2_bridge.sh: add usb0 to bridge ..."
brctl addif bridge0 usb0
echo "usb0_2_bridge.sh: done ..."
# =============================================================
