# 
# Created by LiuWei @ 2010.8.27 
# init firewall
#

#FMT_ECHO=1>/dev/null 2>&1

ZTE_FILTER_CHAIN=macipport_filter

#clear filter
iptables -t filter -F
iptables -t filter -X $ZTE_FILTER_CHAIN

iptables -P INPUT ACCEPT
iptables -P OUTPUT ACCEPT
iptables -P FORWARD ACCEPT

#make a new chain for filter
iptables -t filter -N $ZTE_FILTER_CHAIN
iptables -t filter -A FORWARD -j $ZTE_FILTER_CHAIN

# begin - zhangyuelong10100551 for ipv6 firewall 2012.08.30
#clear filter
ip6tables -t filter -F
ip6tables -t filter -X $ZTE_FILTER_CHAIN

ip6tables -P INPUT ACCEPT
ip6tables -P OUTPUT ACCEPT
ip6tables -P FORWARD ACCEPT

ip6tables -t filter -N $ZTE_FILTER_CHAIN
ip6tables -t filter -A FORWARD -j $ZTE_FILTER_CHAIN
# end - zhangyuelong10100551 for ipv6 firewall 2012.08.30

#just set mtu/mss
mss_del_path="/tmp/mss_del.sh"

wan_if=$1

mtu=`zte_nvc_apps read mtu`
tcp_mss=`zte_nvc_apps read tcp_mss`

if [ "$wan_if" = "" ]
then
	wan_if=rmnet0
fi

if [ "$mtu" = "" ]
then
	mtu=1500
fi

if [ "$tcp_mss" = "" ]
then
    let tcp_mss=mtu-40
fi

sh $mss_del_path

if echo $wan_if | grep -q rmnet
then
    echo "$0: set mtu, wan=[$wan_if], mtu=[$mtu], tcp_mss=[$tcp_mss]"
    busybox ifconfig $wan_if mtu $mtu
    #iptables -t mangle -D POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --clamp-mss-to-pmtu
    #iptables -t mangle -I POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --clamp-mss-to-pmtu
	
    if [ "$tcp_mss" != 1460 ]
    then
       iptables -t mangle -I POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $tcp_mss
       echo iptables -t mangle -D POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $tcp_mss > $mss_del_path
    else
	   iptables -t mangle -I POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --clamp-mss-to-pmtu
	   echo iptables -t mangle -D POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --clamp-mss-to-pmtu > $mss_del_path
    fi
else
    echo "$0: not rmnet*, dont set mtu"
fi

echo "firewall init done"
#nat.sh




