#!/bin/sh
# ===========================================================
# usage: tc_control.sh
# traffic control by tc_uplink and tc_downlink
UPLINK=$2
DOWNLINK=$1
IN=`zte_nvc_apps read in_device`
OUT=`zte_nvc_apps read out_device`
GATEWAY=`zte_nvc_apps read lan_ipaddr_for_current`
#echo "gateway=$GATEWAY"
if [ "$UPLINK" = " " ] || [ "$DOWNLINK" = " " ]
then
	echo "no need to traffic control!"
	exit
fi
if [ "$IN" = "" ]
then
	IN=br0
fi
if [ "$OUT" = "" ]
then
	OUT=rmnet0
fi

if [ "$DOWNLINK" = "0" -a "$UPLINK" = "0" ] 
then
	echo "no need to traffic control,start ipacm"
	#killall -SIGUSR2 ipacm
fi

tc qdisc del dev $IN root
tc qdisc del dev $OUT root

SUM=$((${DOWNLINK}+512))

if [ "$DOWNLINK" != "0" ] 
then
	#killall -SIGUSR1 ipacm
	ifconfig $IN txqueuelen 1000
	tc qdisc add dev $IN root handle 1: htb default 20
	tc class add dev $IN parent 1: classid 1:1 htb rate ${SUM}kbps 
	tc class add dev $IN parent 1:1 classid 1:20 htb rate ${DOWNLINK}kbps 
	tc class add dev $IN parent 1:1 classid 1:10 htb rate 512kbps 	
	tc qdisc add dev $IN parent 1:10 handle 10: sfq perturb 10
	tc qdisc add dev $IN parent 1:20 handle 20: sfq perturb 10
	#echo "======================="
	tc filter add dev $IN protocol ip parent 1:0 prio 1 u32 match ip src ${GATEWAY}/32 match ip sport 80 0xffff flowid 1:10
	#echo "=======${GATEWAY}======${SUM}======= ${DOWNLINK}===="
fi
  
if [ "$UPLINK" != "0" ] 
then
	#killall -SIGUSR1 ipacm
	tc qdisc add dev $OUT root handle 1: htb default 1
	tc class add dev $OUT parent 1: classid 1:1 htb rate ${UPLINK}kbps ceil ${UPLINK}kbps
fi