﻿/**
 * setting--device seeting--USSD module
 * 
 * @module ussd
 * @class ussd
 */
define([ 'jquery', 'service', 'knockout'], function($, service, ko) {
	
	var initUSSD=true;
	var reply_flag=false;//是否已经得到回复
	var USSDLocation = {SEND:0, REPLY:1};
	var callbackTemp;
	var ussd_action=1;//初始化为成功获得返回消息

    /**
     * @class USSDInformationViewModel
     * @constructor
     */
	function USSDInformationViewModel() {
		var self = this;
		
		self.ussd_action=ko.observable(ussd_action);
		self.USSDLocation=ko.observable(USSDLocation.SEND);
		self.USSDReply=ko.observable("");
		self.USSDSend=ko.observable("");
		
		
		/**
		 * 发送USSD命令
		 * @method sendToNet
		 */
		self.sendToNet = function(){
			var command = self.USSDSend();
			if (('string' != typeof (command)) || ('' == command)) {
				showAlert("ussd_error_input");
				return;
			}
			
			showLoading();	
			
			var params = {};
                params.operator = "ussd_send";
                params.strUSSDCommand = command;
				params.sendOrReply = "send";
			
			service.getUSSDResponse(params, function(result, content){
				hideLoading();				
				if(result){
					resetUSSD();
					self.USSDLocation(USSDLocation.REPLY);
					self.ussd_action(content.ussd_action);
					$("#USSD_Content").val(decodeMessage(content.data, true));
					reply_flag=false;
				}else{
					showAlert(content);
				}
			});
		};
		
		/**
		 * 回复USSD消息
		 * @method replyToNet
		 */
		self.replyToNet = function(){
			var command = self.USSDReply();
			if (('string' != typeof (command)) || ('' == command)) {
				showAlert("ussd_error_input");
				return;
			}
			
			showLoading();	
			
			var params = {};
                params.operator = "ussd_reply";
                params.strUSSDCommand = command;
				params.sendOrReply = "reply";
			
			service.getUSSDResponse(params, function(result, content){
				hideLoading();
				if(result){
					self.ussd_action(content.ussd_action);
					$("#USSD_Content").val(decodeMessage(content.data, true));
					reply_flag=false;
					resetUSSD();
				}else{
					showAlert(content);
				}	
			});
		};
		
		/**
		 * 取消回复USSD消息
		 * @method noReplyCancel
		 */
		self.noReplyCancel = function(){
			reply_flag=true;
			service.USSDReplyCancel(function(result){
				if(result){
					resetUSSD();
					self.USSDLocation(USSDLocation.SEND);
				}else{
					showAlert("ussd_fail");
				}
			});
		};
		
		cancelUSSD = function(){
			service.USSDReplyCancel(function(result){
			});
		};
		
		/**
		 * 重置USSD输入命令
		 * @method resetUSSD
		 */
		resetUSSD = function(){
			self.USSDReply("");
			self.USSDSend("");
		};		
		
		//如果首次进入USSD菜单，先发送USSD取消命令，进行初始化
		if(initUSSD){
			cancelUSSD();
			initUSSD=false;
		}
	}

    /**
     * 初始化
     * @method init
     */
	function init() {
		var container = $('#container')[0];
		ko.cleanNode(container);
		var vm = new USSDInformationViewModel();
		ko.applyBindings(vm, container);	
		
	}	
	
	return {
		init : init
	};
});