﻿define([ 'jquery', 'service', 'knockout', 'config/config' ], function ($, service, ko, config) {

    function DeviceInformationViewModel() {
        var self = this;
        var data = service.getDeviceInfo();
        self.ssid = ko.observable(verifyDeviceInfo(data.ssid));
        self.m_ssid = ko.observable(verifyDeviceInfo(data.m_ssid));
        self.m_max_access_num = ko.observable(verifyDeviceInfo(data.m_max_access_num));
        self.showMssid = ko.observable(data.multi_ssid_enable == "1" && config.HAS_MULTI_SSID);
        self.ipAddress = ko.observable(verifyDeviceInfo(data.ipAddress));
        self.wanIpAddress = ko.observable();
		self.simNumberinfo = ko.observable("If the SIM Card Number does not display properly,please send the SMS \"myno\"to number\"51619\"to get it.");
        self.ipv6WanIpAddress = ko.observable();
        self.macAddress = ko.observable(verifyDeviceInfo(data.macAddress));
        self.simSerialNumber = ko.observable(verifyDeviceInfo(data.simSerialNumber));
        self.lanDomain = ko.observable(verifyDeviceInfo(data.lanDomain));
        self.imei = ko.observable(verifyDeviceInfo(data.imei));
        self.sw_version = ko.observable(verifyDeviceInfo(data.web_version));
        self.fw_version = ko.observable(verifyDeviceInfo(data.fw_version));
        self.hw_version = ko.observable(verifyDeviceInfo(data.hw_version));
        self.max_access_num = ko.observable(verifyDeviceInfo(data.max_access_num));
        self.showMacAddress = ko.observable(config.SHOW_MAC_ADDRESS);
        self.hasWifi = ko.observable(config.HAS_WIFI);
        var ipv6Mode = data.ipv6PdpType.toLowerCase().indexOf("v6") > 0;
        //self.showIpv6WanIpAddr = ko.observable(config.IPV6_SUPPORT && ipv6Mode);
        self.showIpv6WanIpAddr = ko.observable();
        self.showIpv4WanIpAddr = ko.observable();
        self.imsi = ko.observable(verifyDeviceInfo(data.imsi));
        self.signal = ko.observable(signalFormat(data.signal));
		self.rssi = ko.observable(Format(data.rssi,data.network_type));
		self.rscp = ko.observable(rscpFormat(data.rscp,data.network_type));
		self.Ec_Io = ko.observable(ecioFormat(data.Ec_Io,data.network_type));
		self.rsrp = ko.observable(rsrpFormat(data.rsrp,data.network_type));
		self.sinr = ko.observable(ltepcFormat(data.sinr,data.network_type));
		self.lte_pci = ko.observable(ltepcFormat(data.lte_pci,data.network_type));
		self.cell_id = ko.observable(DeviceInfo(data.cell_id,data.network_type));
		self.plmn = ko.observable(DeviceInfo(data.plmn,data.network_type));
		self.network_type= ko.observable(data.network_type);
		self.info_visible = ko.computed(function(){
				if(self.network_type() == 'GSM' || self.network_type() == 'GPRS' || self.network_type() == 'EDGE'){
					return '2G';
				} else if(self.network_type() == 'UMTS' || self.network_type() == 'HSDPA' || self.network_type() == 'HSUPA' || self.network_type() == 'HSPA' || self.network_type() == 'HSPA+' || self.network_type() == 'DC-HSPA+'){
					return '3G';
				} else if(self.network_type() == 'LTE'){
					return '4G';
				}
			});
		self.NetworkType= ko.observable(getNetworkType(data.network_type));
		self.ConnectionStatus = ko.observable(deviceConnectStatus(data.connectStatus));
        var info = service.getStatusInfo();
		var roamStatus=info.roamingStatus?true:false;
			self.networkOperator = ko.observable(getNetWorkProvider(info.spn_b1_flag,info.spn_name_data,info.spn_b2_flag,info.networkOperator,roamStatus));
			self.roamingStatus = ko.observable(info.roamingStatus ? "ON" : "OFF");

	    var deviceinfo = service.getLanInfo();
			self.DHCPServer = ko.observable(dhcpFormat(deviceinfo.dhcpServer));
			self.SubnetMask = ko.observable(deviceinfo.subnetMask);
        if (config.IPV6_SUPPORT) {//支持IPV6
            if (data.pdpType == "IP") {//ipv4
                self.showIpv6WanIpAddr(false);
                self.showIpv4WanIpAddr(true);
            } else if (ipv6Mode) {//ipv6(&ipv4)
                if (data.ipv6PdpType == "IPv6") {
                    self.showIpv6WanIpAddr(true);
                    self.showIpv4WanIpAddr(false);
                } else {
                    self.showIpv6WanIpAddr(true);
                    self.showIpv4WanIpAddr(true);
                }
            }
        } else {//不支持IPV6
            self.showIpv6WanIpAddr(false);
            self.showIpv4WanIpAddr(true);
        }
        //联网时显示万网地址，否则为空
        var connectStatus = getConnectStatus(data.connectStatus);
        if (connectStatus == 1) {
            self.wanIpAddress(verifyDeviceInfo(data.wanIpAddress));
            self.ipv6WanIpAddress("— —");
        } else if (connectStatus == 2) {
            self.wanIpAddress("— —");
            self.ipv6WanIpAddress(verifyDeviceInfo(data.ipv6WanIpAddress));
        } else if (connectStatus == 3) {
            self.wanIpAddress(verifyDeviceInfo(data.wanIpAddress));
            self.ipv6WanIpAddress(verifyDeviceInfo(data.ipv6WanIpAddress));
        } else {
            self.wanIpAddress("— —");
            self.ipv6WanIpAddress("— —");
        }

        self.wifiRange = ko.observable("wifi_" + data.wifiRange);
    }
    function deviceConnectStatus(status){
	    var connectStatus = getConnectStatus(status);
        if (connectStatus == 1) {
			return "Connected";
			//self.ConnectionStatus("Connected");
        } else if (connectStatus == 2) {
			//self.ConnectionStatus("Connected");
			return "Connected";
        } else if (connectStatus == 3) {
			//self.ConnectionStatus("Connected");
			return "Connected";
        } else {
			//self.ConnectionStatus("Disconnected");
			return "Disconnected";
        }
	}
	function getNetWorkProvider(spn_b1_flag,spn_name_data,spn_b2_flag,network_provider,roamStatus){
		if(!roamStatus){
			if(spn_name_data==""){
				return network_provider;
			  }else{
				  if(spn_name_data=="-"){
					return "— —";
				  }else{
					  return spn_name_data=decodeMessage(spn_name_data);
					}
			  }
		}
		else{
		    if(network_provider=="" || network_provider=="-"){
			   return "— —";
			}else{
				return network_provider;
			}
		}
		/*if(spn_name_data==""){
			return network_provider;
		}else{
			spn_name_data=decodeMessage(spn_name_data);

			if(spn_b1_flag=="1" && spn_b2_flag=="1"){
				if(roamStatus){//漫游
					return network_provider;
				}else{//不漫游
					return network_provider+"  "+spn_name_data;
				}
			}else if(spn_b1_flag=="1"){
				if(roamStatus){//漫游
					return network_provider+"  "+spn_name_data;
				}else{//不漫游
					return network_provider+"  "+spn_name_data;
				}
			}else if(spn_b2_flag=="1"){
				if(roamStatus){//漫游
					return network_provider;
				}else{//不漫游
					return spn_name_data;
				}
			}else if(spn_b1_flag=="0" && spn_b2_flag=="0"){
				if(roamStatus){//漫游
					return network_provider+"  "+spn_name_data;
				}else{//不漫游
					return spn_name_data;
				}
			}
			return "— —";
		}*/
	}
	/**
	 * 获取当前网络状态
	 *
	 * @method getNetworkType
	 */
	getNetworkType = function(NetworkType) {
		var networkTypeTmp = NetworkType.toLowerCase();
		if (networkTypeTmp == '') {
			networkTypeTmp = 'limited_service';
		}
		if (networkTypeTmp == 'limited_service' || networkTypeTmp == 'no_service') {
			$("#NetworkType").attr("trans", "network_type_" + networkTypeTmp);
			return $.i18n.prop("network_type_" + networkTypeTmp);
		} else {
			$("#NetworkType").removeAttr("trans");
			return NetworkType;
		}
	};
    function verifyDeviceInfo(field) {
        if (field && field != "") {
            return field;
        } else {
            return "— —";
        }
    }
    function DeviceInfo(field,networktype) {
		if(networktype == 'limited_service' || networktype == 'no_service'){
			return 'N/A';
			}else{
				return field;
			}
       /* if (field && field != "") {
            return field;
        } else {
            return "N/A";
        }*/
    }
    function getConnectStatus(status) {
        if (status == "ppp_disconnected" || status == "ppp_connecting" || status == "ppp_disconnecting") {
            return 0;
        } else if (status == "ppp_connected") {
            return 1;
        } else if (status == "ipv6_connected") {
            return 2;
        } else if (status == "ipv4_ipv6_connected") {
            return 3;
        }
    }

    function signalFormat(signal) {
        if (signal) {
            return signal + " dBm";
        } else {
            return "— —";
        }
    }
	function dhcpFormat(dhcp){
		if(dhcp == "1"){
			return "Enable";
		} else{
			return "Disable"
		}
	}
	function rscpFormat(rscp,networktype){
		if(networktype == 'UMTS' || networktype == 'HSDPA' || networktype == 'HSUPA' || networktype == 'HSPA' || networktype == 'HSPA+' || networktype == 'DC-HSPA+'){
			return rscp+ " dBm";
		} else {
			return 'N/A';
		}
	}
	function ecioFormat(ecio,networktype){
		if(networktype == 'UMTS' || networktype == 'HSDPA' || networktype == 'HSUPA' || networktype == 'HSPA' || networktype == 'HSPA+' || networktype == 'DC-HSPA+'){
			return ecio;
		} else {
			return 'N/A';
		}
	}
	
	function rsrpFormat(rsrp,networktype){
		if(networktype == 'LTE'){
			return rsrp+ " dBm";
		} else {
			return 'N/A';
		}
	}
	function ltepcFormat(ltepc,networktype){
		if(networktype == 'LTE'){
			return ltepc;
		} else {
			return 'N/A';
		}
	}
	function Format(value,networktype){
		if(networktype == 'limited_service' || networktype == 'no_service'){
			return 'N/A';
			}else{
				return value + " dBm";
			}
       /* if (value) {
            return value + " dBm";
        } else {
            return "N/A";
        }*/
    }
    function init() {
        var container = $('#container')[0];
        ko.cleanNode(container);
        var vm = new DeviceInformationViewModel();
        ko.applyBindings(vm, container);

        addInterval(function () {
            service.getDeviceInfo({}, function (data) {
                vm.signal(signalFormat(data.signal));
				vm.rssi(Format(data.rssi,data.network_type));
				vm.sinr(ltepcFormat(data.sinr,data.network_type));
				vm.lte_pci(ltepcFormat(data.lte_pci,data.network_type));
				vm.rscp(rscpFormat(data.rscp,data.network_type));
				vm.Ec_Io(ecioFormat(data.Ec_Io,data.network_type));
				vm.rsrp(rsrpFormat(data.rsrp,data.network_type));
				vm.cell_id(DeviceInfo(data.cell_id,data.network_type));
				vm.NetworkType(getNetworkType(data.network_type));
				vm.plmn(DeviceInfo(data.plmn,data.network_type));
				vm.ConnectionStatus(deviceConnectStatus(data.connectStatus));
            });
        }, 1000);
		addInterval(function () {
            var info = service.getStatusInfo();
			vm.networkOperator(getNetWorkProvider(info.spn_b1_flag,info.spn_name_data,info.spn_b2_flag,info.networkOperator,info.roamingStatus));
			vm.roamingStatus(info.roamingStatus ? "ON" : "OFF");
        }, 1000);
    }
    return {
        init:init
    };
});