/**
 * @module url filter setting
 * @class url filter
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore' ],

function($, ko, config, service, _) {

    /**
     * system url filter setting VM
     * @class UrlFilterSettingVM
     */
	function UrlFilterSettingVM() {
        var self = this;
        var info = service.getUrlFilterList();
		var columnsTmpl = [
			{ columnType:"checkbox", rowText:"index", width:"30%"},
			{ headerTextTrans:"url", rowText:"url", width:"70%"}
		];
		self.rules = ko.observableArray(info.urlFilterRules);
		
		self.gridTemplate = new ko.simpleGrid.viewModel({
            data:self.rules(),
            idName:"index",
            columns:columnsTmpl,
            tmplType:'list',
            pageSize: 10
        });

        self.clear = function() {
            $("#addURLFilter").val("");
        };
		/*
			������ɾ��ص�����
			@method callback
		*/
		
		self.callback = function(data){
			if(data.result == "success") {
				self.clear();
				init();
				successOverlay();
				$("#urlFilters").translate();
			} else {
				errorOverlay();
			}
		}

        self.addRule = function() {
			if(self.rules().length >= config.urlFilterMax) {
				showAlert({msg: "url_filter_max", params: config.urlFilterMax});
				return false;
			}
			var tempArray = [];
			for(var i = 0; i < self.rules().length; i++) {
				tempArray.push(self.rules()[i].url);
			}
			if($.inArray($("#addURLFilter").val(), tempArray) != -1) {
				showAlert("url_repeated");
				return false;
			}
			
            showLoading();
            var params = {
				goformId : "URL_FILTER_ADD",
				addURLFilter : $("#addURLFilter").val()
			};
            service.addUrlFilterRule(params, self.callback);
        };
		
		self.deleteRule = function(){
            showConfirm('confirm_data_delete', function() {
                showLoading();
                var params = {
                    goformId: "URL_FILTER_DELETE",
                    url_filter_delete_id: self.gridTemplate.selectedIds().join(";") + ";"
                };
                service.deleteSelectedRules(params, self.callback);
            });
		}
    }

    /**
     * ��ʼ�� UrlFilterSettingVM model
     * @method init
     */
	function init() {
		var container = $('#container');
		ko.cleanNode(container[0]);
		var vm = new UrlFilterSettingVM();
		ko.applyBindings(vm, container[0]);
        $('#urlFilterForm').validate({
            submitHandler : function() {
                vm.addRule();
            },
            rules: {
                addURLFilter: 'url_filter_check'
            }
        });
		
		$("#urlFilterListForm").validate({
			submitHandler : function(){
				vm.deleteRule();
			}
		});
	}

	return {
		init : init
	};
});