/**
 * sim 模块
 * @module simVM
 * @class simVM
 */
define(['knockout', 'service', 'jquery', 'config/config', 'home', 'opmode/opmode'], function (ko, service, $, config, home, opmode) {
    function simVM() {
        var self = this;
        self.pageState = {NO_SIM:0, WAIT_PIN:1, WAIT_PUK:2, PUK_LOCKED:3, LOADING:4};
        self.isSupportSD = config.SD_CARD_SUPPORT;
        self.isCPE = config.DEVICE.toLowerCase().indexOf("cpe") !=-1;
        self.showQRCode = config.WIFI_SUPPORT_QR_CODE;
        self.hasPhonebook = config.hasPhonebook;
        self.qrcodeSrc = './img/qrcode_ssid_wifikey.png?_=' + $.now();
        self.isHomePage = ko.observable(false);
        if(window.location.hash=="#home"){
            self.isHomePage(true);
        }

        var info = service.getLoginData();
        self.PIN = ko.observable();
        self.PUK = ko.observable();
        self.newPIN = ko.observable();
        self.confirmPIN = ko.observable();
        self.pinNumber = ko.observable(info.pinnumber);
        self.pukNumber = ko.observable(info.puknumber);
        self.simSerialNumber = ko.observable('');
        self.imei = ko.observable('');
        self.imsi = ko.observable('');
        self.wifiLongMode = ko.observable('');
        self.connectStatus = ko.observable(info.connectStatus);
        var state = computePageState(info);
        self.page = ko.observable(state);
        if (state == self.pageState.LOADING) {
            addTimeout(refreshPage, 500);
        }
        var popoverShown = false;
            $('#showDetailInfo').popover({
                html: true,
                placement: 'top',
                trigger: 'focus',
                title: function () {
                    return $.i18n.prop('device_info')
                },
                content: function () {
                    return getDetailInfoContent();
                }
            }).on('shown.bs.popover', function () {
                popoverShown = true;
                var scrollTopHeight = $("#topContainer").outerHeight();
                if ($(window).scrollTop() > scrollTopHeight) {
                    $(window).scrollTop(scrollTopHeight);
                }
            }).on('hidden.bs.popover', function () {
                popoverShown = false;
            });
            function fetchDeviceInfo() {
                var data = service.getDeviceInfo();
                self.simSerialNumber(verifyDeviceInfo(data.simSerialNumber));
                self.imei(verifyDeviceInfo(data.imei));
                self.imsi(verifyDeviceInfo(data.imsi));
                self.wifiLongMode("wifi_des_" + data.wifiRange);
                return data;
            }

            fetchDeviceInfo();
		    function getDetailInfoContent() {
                var data = fetchDeviceInfo();
                homeUtil.initShownStatus(data);
                var addrInfo = homeUtil.getWanIpAddr(data);
                var compiled = _.template($("#detailInfoTmpl").html());
                var tmpl = compiled({
                    simSerialNumber: verifyDeviceInfo(data.simSerialNumber),
                    imei: verifyDeviceInfo(data.imei),
                    imsi: verifyDeviceInfo(data.imsi),
                    signal: signalFormat(data.signal),
                    hasWifi: config.HAS_WIFI,
                    isCPE: config.DEVICE.toLowerCase().indexOf("cpe") !=-1,
                    showMultiSsid: config.HAS_MULTI_SSID && data.multi_ssid_enable == "1",
                    ssid: verifyDeviceInfo(data.ssid),
                    max_access_num: verifyDeviceInfo(data.max_access_num),
                    m_ssid: verifyDeviceInfo(data.m_ssid),
                    m_max_access_num: verifyDeviceInfo(data.m_max_access_num),
                    wifi_long_mode: "wifi_des_" + data.wifiRange,
                    lanDomain: verifyDeviceInfo(data.lanDomain),
                    ipAddress: verifyDeviceInfo(data.ipAddress),
                    showMacAddress: config.SHOW_MAC_ADDRESS,
                    macAddress: verifyDeviceInfo(data.macAddress),
                    showIpv4WanIpAddr: homeUtil.initStatus.showIpv4WanIpAddr,
                    wanIpAddress: addrInfo.wanIpAddress,
                    showIpv6WanIpAddr: homeUtil.initStatus.showIpv6WanIpAddr,
                    ipv6WanIpAddress: addrInfo.ipv6WanIpAddress,
                    sw_version: verifyDeviceInfo(data.sw_version),
                    fw_version: verifyDeviceInfo(data.fw_version),
                    hw_version: verifyDeviceInfo(data.hw_version)
                });
                return  $(tmpl).translate();
            }
        /**
         * 验证输入PIN事件处理
         *
         * @event enterPIN
         */
        self.enterPIN = function () {
            showLoading();
            self.page(self.pageState.LOADING);
            var pin = self.PIN();
            service.enterPIN({
                PinNumber:pin
            }, function (data) {
                if (!data.result) {
                    hideLoading();
                    showAlert("pin_error", function () {
                        refreshPage();
                    });
                    self.PIN('');
                }
                refreshPage();
                if (self.page() == self.pageState.WAIT_PUK) {
                    hideLoading();
                }
            });
        };
        /**
         * 输入PUK设置新PIN事件处理
         *
         * @event enterPUK
         */
        self.enterPUK = function () {
            showLoading();
            self.page(self.pageState.LOADING);
            var newPIN = self.newPIN();
            var confirmPIN = self.confirmPIN();
            var params = {};
            params.PinNumber = newPIN;
            params.PUKNumber = self.PUK();
            service.enterPUK(params, function (data) {
                if (!data.result) {
                    hideLoading();
                    showAlert("puk_error", function () {
                        refreshPage();
                        if (self.page() == self.pageState.PUK_LOCKED) {
                            hideLoading();
                        }
                    });
                    self.PUK('');
                    self.newPIN('');
                    self.confirmPIN('');
                }else{
                    refreshPage();
                    if (self.page() == self.pageState.PUK_LOCKED) {
                        hideLoading();
                    }
                }
            });
        };
        /**
         * 刷新页面状态
         *
         * @method refreshPage
         */
        function refreshPage() {
            var data = service.getLoginData();
            var state = computePageState(data);
            if (state == self.pageState.LOADING) {
                addTimeout(refreshPage, 500);
            } else {
                self.page(state);
                self.pinNumber(data.pinnumber);
                self.pukNumber(data.puknumber);
            }
        }

        /**
         * 根据登录状态和SIM卡状态设置页面状态
         * @method computePageState
         */
        function computePageState(data) {
            var state = data.modem_main_state;
            if (state == "modem_sim_undetected" || state == "modem_undetected" || state == "modem_sim_destroy") {
                return self.pageState.NO_SIM;
            } else if ($.inArray(state, config.TEMPORARY_MODEM_MAIN_STATE) != -1) {
                return self.pageState.LOADING;
            } else if (state == "modem_waitpin") {
                return self.pageState.WAIT_PIN;
            } else if ((state == "modem_waitpuk" || data.pinnumber == 0) && (data.puknumber != 0)) {
                return self.pageState.WAIT_PUK;
            } else if ((data.puknumber == 0 || state == "modem_sim_destroy")
                && state != "modem_sim_undetected" && state != "modem_undetected") {
                return self.pageState.PUK_LOCKED;
            } else {
                location.reload();
            }
        }
        addInterval(function () {
            service.getSignalStrength({}, function (data) {
                var signalTxt = signalFormat(config.DEVICE.toLowerCase().indexOf("cpe") !=-1? data.rssi : convertSignal(data));
                $("#fresh_signal_strength").text(signalTxt);
                if (popoverShown) {
                    $("#popoverSignalTxt").text(signalTxt);
                }
            });
        }, 1000);

    }

    var homeUtil = {
        initStatus: null,

        initShownStatus: function (data) {
            this.initStatus = {};
            if (config.DEVICE.toLowerCase().indexOf("cpe") !=-1) {
                if (data.opms_wan_mode == "BRIDGE") {
                    this.initStatus.showIpv6WanIpAddr = false;
                    this.initStatus.showIpv4WanIpAddr = false;
                } else if (data.opms_wan_mode == "DHCP" || data.opms_wan_mode == "PPPOE") {
                    this.initStatus.showIpv6WanIpAddr = false;
                    this.initStatus.showIpv4WanIpAddr = true;
                } else if (data.opms_wan_mode == "STATIC") {
                    this.initStatus.showIpv6WanIpAddr = false;
                    this.initStatus.showIpv4WanIpAddr = true;
                } else if (config.IPV6_SUPPORT) {//支持IPV6
                    if(data.pdpType.toUpperCase()=="IPV6"){
                        this.initStatus.showIpv6WanIpAddr = true;
                        this.initStatus.showIpv4WanIpAddr = false;
                    }else if(data.pdpType.toUpperCase()=="IPV4V6"){
                        this.initStatus.showIpv6WanIpAddr = true;
                        this.initStatus.showIpv4WanIpAddr = true;
                    }else{
                        this.initStatus.showIpv6WanIpAddr = false;
                        this.initStatus.showIpv4WanIpAddr = true;
                    }
                } else {//不支持IPV6
                    this.initStatus.showIpv6WanIpAddr = false;
                    this.initStatus.showIpv4WanIpAddr = true;
                }
            } else {
                if (config.IPV6_SUPPORT) {//支持IPV6
                    if(data.pdpType.toUpperCase()=="IPV6"){
                        this.initStatus.showIpv6WanIpAddr = true;
                        this.initStatus.showIpv4WanIpAddr = false;
                    }else if(data.pdpType.toUpperCase()=="IPV4V6"){
                        this.initStatus.showIpv6WanIpAddr = true;
                        this.initStatus.showIpv4WanIpAddr = true;
                    }else{
                        this.initStatus.showIpv6WanIpAddr = false;
                        this.initStatus.showIpv4WanIpAddr = true;
                    }
                } else {//不支持IPV6
                    this.initStatus.showIpv6WanIpAddr = false;
                    this.initStatus.showIpv4WanIpAddr = true;
                }
            }
        },
        getWanIpAddr: function (data) {
            var addrInfo = {
                wanIpAddress: '',
                ipv6WanIpAddress: ''
            };
            if (data.opms_wan_mode == "DHCP" || data.opms_wan_mode == "PPPOE") {
                addrInfo.wanIpAddress = verifyDeviceInfo(data.wanIpAddress);
            } else if (data.opms_wan_mode == "STATIC") {
                addrInfo.wanIpAddress = verifyDeviceInfo(data.staticWanIpAddress);
            } else/* if (data.opms_wan_mode == "PPP")*/ {
                var connectStatus = this.getConnectStatus(data.connectStatus);
                if (connectStatus == 1) {
                    addrInfo.wanIpAddress = verifyDeviceInfo(data.wanIpAddress);
                    addrInfo.ipv6WanIpAddress = "— —";
                } else if (connectStatus == 2) {
                    addrInfo.wanIpAddress = "— —";
                    addrInfo.ipv6WanIpAddress = verifyDeviceInfo(data.ipv6WanIpAddress);
                } else if (connectStatus == 3) {
                    addrInfo.wanIpAddress = verifyDeviceInfo(data.wanIpAddress);
                    addrInfo.ipv6WanIpAddress = verifyDeviceInfo(data.ipv6WanIpAddress);
                } else {
                    addrInfo.wanIpAddress = "— —";
                    addrInfo.ipv6WanIpAddress = "— —";
                }
            }
            return addrInfo;
        },

        getConnectStatus: function (status) {
            if (status == "ppp_disconnected" || status == "ppp_connecting" || status == "ppp_disconnecting") {
                return 0;
            } else if (status == "ppp_connected") {
                return 1;
            } else if (status == "ipv6_connected") {
                return 2;
            } else if (status == "ipv4_ipv6_connected") {
                return 3;
            }
        }
    }

    function init() {
        var container = $('#container')[0];
        ko.cleanNode(container);
        var vm = new simVM();
        ko.applyBindings(vm, container);

        $('#frmPIN').validate({
            submitHandler:function () {
                vm.enterPIN();
            },
            rules:{
                txtPIN:"pin_check"
            }
        });

        $('#frmPUK').validate({
            submitHandler:function () {
                vm.enterPUK();
            },
            rules:{
                txtNewPIN:"pin_check",
                txtConfirmPIN:{equalToPin:"#txtNewPIN"},
                txtPUK:"puk_check"
            }
        });

        if(window.location.href.indexOf("?no_connect") != -1 || window.location.href.indexOf("?flow_beyond") != -1 || window.location.href.indexOf("?fota_upgrade") != -1){
            manualLogout = true;
            service.logout({}, function(){
                window.location.reload();
            });
        }
    }

    return {
        init:init
    };
});