/**
 * network_lock 模块
 * @module network_lock
 * @class network_lock
 */
define(['knockout', 'service', 'jquery', 'config/config', 'home'], function (ko, service, $, config, home) {

    function lockVM() {
        var self = this;
        self.isSupportSD = config.SD_CARD_SUPPORT;
        self.deviceInfo = ko.observable([]);
        self.showQRCode = config.WIFI_SUPPORT_QR_CODE;
        self.hasPhonebook = config.hasPhonebook;
        self.qrcodeSrc = './img/qrcode_ssid_wifikey.png?_=' + $.now();
        self.isHomePage = ko.observable(false);
        if(window.location.hash=="#home"){
            self.isHomePage(true);
        }

        self.supportUnlock = config.NETWORK_UNLOCK_SUPPORT;
        self.unlockCode = ko.observable();

        var info = service.getNetworkUnlockTimes();
        self.times = ko.observable(info.unlock_nck_time);

        self.unlock = function () {
            showLoading();
            service.unlockNetwork({
                unlock_network_code: self.unlockCode()
            }, function (data) {
                self.unlockCode("");
                if (data && data.result == "success") {
                    successOverlay();
                    if (window.location.hash == "#home") {
                        setTimeout(function () {
                            window.location.reload();
                        }, 500);
                    } else {
                        window.location.hash = "#home";
                    }
                } else {
                    var info = service.getNetworkUnlockTimes();
                    self.times(info.unlock_nck_time);
                    errorOverlay();
                }
            })
        };
    }

    function init() {
        var container = $('#container')[0];
        ko.cleanNode(container);
        var vm = new lockVM();
        ko.applyBindings(vm, container);

        $("#frmNetworkLock").validate({
            submitHandler: function () {
                vm.unlock();
            },
            rules: {
                txtLockNumber: "unlock_code_check"
            }
        });

        if(window.location.href.indexOf("?no_connect") != -1 || window.location.href.indexOf("?flow_beyond") != -1 || window.location.href.indexOf("?fota_upgrade") != -1){
            manualLogout = true;
            service.logout({}, function(){
                window.location.reload();
            });
        }
    }

    return {
        init: init
    };
});