# 
# Created by LiuWei @ 2010.8.27 
# init firewall
#
ZTE_FILTER_CHAIN=macipport_filter
firewall_enable=`cfg get IPPortFilterEnable`
fw_app_rules=`cfg get fw_app_filter_rules`
forward_policy=`cfg get DefaultFirewallPolicy`
fw_app_enable=`cfg get fw_app_enable`
if [ "$fw_app_enable" != "1" ];then
	exit
fi

iptables -t filter -D INPUT -p tcp --dport 53  -j DROP
iptables -t filter -D INPUT -p tcp --sport 53  -j DROP
iptables -t filter -D INPUT -p udp --dport 53  -j DROP
iptables -t filter -D INPUT -p udp --sport 53  -j DROP

# firewall open, default policy drop, no choice dns, this sitution means that user doesn't use dns. 
if [ "$firewall_enable" == "1" -a "$forward_policy" == "1" -a "${fw_app_rules/dns/}" == "$fw_app_rules" ];then
	iptables -t filter -I INPUT -p tcp --dport 53  -j DROP
	iptables -t filter -I INPUT -p tcp --sport 53  -j DROP
	iptables -t filter -I INPUT -p udp --dport 53  -j DROP
	iptables -t filter -I INPUT -p udp --sport 53  -j DROP
fi

if [ "$fw_app_rules" == "" -o "$firewall_enable" == "0" -o "$fw_app_rules" == ";;;;;;" ];then
	exit
fi

if [[ "${fw_app_rules/dns/}" != "$fw_app_rules" ]];then
	if [ "$forward_policy" == 0 ]; then
		iptables -t filter -A $ZTE_FILTER_CHAIN -p udp --dport 53 -j DROP
		iptables -t filter -A $ZTE_FILTER_CHAIN -p tcp --dport 53 -j DROP
		iptables -t filter -I INPUT -p tcp --dport 53  -j DROP
		iptables -t filter -I INPUT -p tcp --sport 53  -j DROP
		iptables -t filter -I INPUT -p udp --dport 53  -j DROP
		iptables -t filter -I INPUT -p udp --sport 53  -j DROP
	else
		iptables -t filter -A $ZTE_FILTER_CHAIN -p udp --dport 53 -j ACCEPT
		iptables -t filter -A $ZTE_FILTER_CHAIN -p tcp --dport 53 -j ACCEPT
	fi
fi

if [[ "${fw_app_rules/email/}" != "$fw_app_rules" ]];then
	if [ "$forward_policy" == 0 ]; then
		iptables -t filter -A $ZTE_FILTER_CHAIN -p tcp --dport 25 -j DROP
		iptables -t filter -A $ZTE_FILTER_CHAIN -p tcp --sport 25 -j DROP
	else
		iptables -t filter -A $ZTE_FILTER_CHAIN -p tcp --dport 25 -j ACCEPT
		iptables -t filter -A $ZTE_FILTER_CHAIN -p tcp --sport 25 -j ACCEPT
	fi
fi

if [[ "${fw_app_rules/ftp/}" != "$fw_app_rules" ]];then
	if [ "$forward_policy" == 0 ]; then
		iptables -t filter -A $ZTE_FILTER_CHAIN -p tcp --dport 21 -j DROP
	else
		iptables -t filter -A $ZTE_FILTER_CHAIN -p tcp --dport 21 -j ACCEPT
	fi
fi

if [[ "${fw_app_rules/http/}" != "$fw_app_rules" ]];then
	if [ "$forward_policy" == 0 ]; then
		iptables -t filter -A $ZTE_FILTER_CHAIN -p tcp --dport 80 -j DROP
	else
		iptables -t filter -A $ZTE_FILTER_CHAIN -p tcp --dport 80 -j ACCEPT
	fi
fi

if [[ "${fw_app_rules/https/}" != "$fw_app_rules" ]];then
	if [ "$forward_policy" == 0 ]; then
		iptables -t filter -A $ZTE_FILTER_CHAIN -p tcp --dport 433 -j DROP
	else
		iptables -t filter -A $ZTE_FILTER_CHAIN -p tcp --dport 433 -j ACCEPT
	fi
fi

if [[ "${fw_app_rules/telnet/}" != "$fw_app_rules" ]];then
	if [ "$forward_policy" == 0 ]; then
		iptables -t filter -A $ZTE_FILTER_CHAIN -p tcp --dport 23 -j DROP
	else
		iptables -t filter -A $ZTE_FILTER_CHAIN -p tcp --dport 23 -j ACCEPT
	fi
fi