/**
 * @module wifi basic
 * @class wifi basic
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore' ],

    function ($, ko, config, service, _) {
        var isWifi = false;

        var securityModes = _.map(config.AUTH_MODES, function (item) {
            return new Option(item.name, item.value);
        });

        function maxStationOption(max) {
            var options = [];
            for (var i = 1; i <= max; i++) {
                options.push(new Option(i, i));
            }
            return options;
        }

        /**
         * wifi basic view model
         * @class WifiBasicVM
         */
        function WifiBasicVM() {
            var self = this;
            var info = getWifiBasic();
			self.hasWifiSwitch = config.WIFI_SWITCH_SUPPORT;
			self.hasMultiSSID = config.HAS_MULTI_SSID;
            self.hasApStation = config.AP_STATION_SUPPORT;
            self.showIsolated = config.SHOW_WIFI_AP_ISOLATED;
            self.isUfi = ko.observable(config.DEVICE.toLowerCase().indexOf("ufi") !=-1);
            self.hasMacFilter = config.HAS_MAC_FILTER;
            self.origin_wifi_enable = info.wifi_enable;
            self.wifi_enable = ko.observable(info.wifi_enable);
			self.isShowSSIDInfoDiv = ko.observable(false);
			if(config.WIFI_SWITCH_SUPPORT) {
				if(info.wifi_enable == "1") {
					self.isShowSSIDInfoDiv(true);
				} else {
					self.isShowSSIDInfoDiv(false);
				}
			} else {
				self.isShowSSIDInfoDiv(true);//如果不支持软开关，整个SSID信息块显示
			}
         
            self.multi_ssid_enable = ko.observable(info.multi_ssid_enable);
            self.origin_multi_ssid_enable = info.multi_ssid_enable;
            self.supportQrCode = ko.observable(config.WIFI_SUPPORT_QR_CODE);
            var pwdEmpty = info.AuthMode == 'OPEN';
            self.securityModeChangeHandler = function () {
                if (pwdEmpty) {
                    self.passPhrase('');
                    clearValidateMsg('#passwordContainer');
                }
                pwdEmpty = self.selectedMode() == 'OPEN';
            };

            self.maxStationNumber = ko.computed(function () {
                return config.MAX_STATION_NUMBER;
//            if (self.hasMultiSSID && self.origin_multi_ssid_enable == "1") {
//                return config.MAX_STATION_NUMBER - 1;
//            } else {
//                return config.MAX_STATION_NUMBER;
//            }
            });

            self.modes = ko.observableArray(securityModes);
            self.selectedMode = ko.observable(info.AuthMode);
            self.passPhrase = ko.observable(info.passPhrase);
            self.showPassword = ko.observable(false);
            self.ssid = ko.observable(info.SSID);
            self.broadcast = ko.observable(info.broadcast == '1' ? '1' : '0');
			self.apIsolation = ko.observable(info.apIsolation == '1' ? '1' : '0');
            self.cipher = info.cipher;
            self.selectedStation = ko.observable(info.MAX_Access_num);
            self.maxStations = ko.observableArray(maxStationOption(info.MAX_Station_num));

            self.m_modes = ko.observableArray(securityModes);
            self.m_selectedMode = ko.observable(info.m_AuthMode);
            self.m_passPhrase = ko.observable(info.m_passPhrase);
            self.m_showPassword = ko.observable(false);
            self.m_ssid = ko.observable(info.m_SSID);
            self.m_broadcast = ko.observable(info.m_broadcast == '1' ? '1' : '0');
			self.m_apIsolation = ko.observable(info.m_apIsolation == '1' ? '1' : '0');
            self.m_cipher = info.m_cipher;
            self.m_selectedStation = ko.observable(info.m_MAX_Access_num);
            self.m_maxStations = ko.observableArray(maxStationOption(info.MAX_Station_num));
            self.qrcode_ssid1 = ko.observable(getRQCodeImage(true));
            self.qrcode_ssid2 = ko.observable(getRQCodeImage(false));
			self.showQrCode = ko.observable(true);
			self.m_showQrCode = ko.observable(true);

            self.clear = function (option) {
                if (option == "switch") {
                    self.multi_ssid_enable(info.multi_ssid_enable);
					self.wifi_enable(info.wifi_enable);
                } else if (option == "ssid1") {
                    self.selectedMode(info.AuthMode);
                    self.passPhrase(info.passPhrase);
                    self.ssid(info.SSID);
                    self.broadcast(info.broadcast == '1' ? '1' : '0');
                    self.cipher = info.cipher;
                    self.selectedStation(info.MAX_Access_num);
                    self.apIsolation(info.apIsolation == '1' ? '1' : '0');
                } else if (option == "ssid2") {
                    self.m_selectedMode(info.m_AuthMode);
                    self.m_passPhrase(info.m_passPhrase);
                    self.m_ssid(info.m_SSID);
                    self.m_broadcast(info.m_broadcast == '1' ? '1' : '0');
                    self.m_cipher = info.m_cipher;
                    self.m_selectedStation(info.m_MAX_Access_num);
                    self.m_apIsolation(info.m_apIsolation == '1' ? '1' : '0');
                } else {
                    clearTimer();
                    clearValidateMsg();
                    init();
                }
            };

            /**
             * 检测wps是否开启，最大接入数是否超过最大值。
             *
             * @event checkSettings
             */
            self.checkSettings = function (ssid) {
                var wifi_dfs_status = service.getStatusInfo().wifi_dfs_status;
                if(wifi_dfs_status == '1'){
                    showAlert('cannot_set_when_radar_scaning');
                    return true;
                }

                var status = getWpsInfo();
                if (status.wpsFlag == '1') {
                    showAlert('wps_on_info');
                    return true;
                }

                var data = service.getCurrentlyAttachedDevicesInfo();
                var ssid1Attached = [];
                $.each(data.attachedDevices,function(i,n){
                    if(n.ssid_index=="1"){
                        ssid1Attached.push(n);
                    }
                });
                if(ssid1Attached.length > self.selectedStation()){
                    showAlert('can_not_modify_less_attached');
                    return true;
                }

                if (config.HAS_MULTI_SSID && info.multi_ssid_enable == "1") {
                    if ((ssid == "ssid1" && parseInt(self.selectedStation()) + parseInt(info.m_MAX_Access_num) > info.MAX_Station_num)
                        || (ssid == "ssid2" && parseInt(self.m_selectedStation()) + parseInt(info.MAX_Access_num) > info.MAX_Station_num)) {
                        showAlert({msg:'multi_ssid_max_access_number_alert', params: info.MAX_Station_num});
                        return true;
                    }
                }

                return false;
            };

            self.saveSSID1 = function () {
                if (self.checkSettings("ssid1")) {
                    return;
                }
                showConfirm('wifi_disconnect_confirm', function(){
                    self.saveSSID1Action();
                });
            };
            /**
             * 保存SSID1的设置
             *
             * @event saveSSID1
             */
            self.saveSSID1Action = function () {
                showLoading();

                var dirverCount = 0;
                function checkWifiDirver() {
                    service.getWpsInfo({},function(data){
                        if (data.radioFlag=='0' || data.radioFlag=='1') {
                            successOverlay();
                            clearTimer();
                            clearValidateMsg();
                            init();
                        } else {
                            if (dirverCount <= 20) {
                                dirverCount = dirverCount + 1;
                                addTimeout(function(){
                                    checkWifiDirver();
                                }, 2000);
                            } else {
                                successOverlay();
                                clearTimer();
                                clearValidateMsg();
                                init();
                            }
                        }
                    })
                }

                self.broadcast($("#broadcastCheckbox:checked").length > 0? '0' : '1');
                self.apIsolation($("#apisolatedCheckbox:checked").length);
                var params = {};
                params.AuthMode = self.selectedMode();
                params.passPhrase = self.passPhrase();
                params.SSID = self.ssid();
                params.broadcast = self.broadcast();
                params.station = self.selectedStation();
                params.cipher = self.selectedMode() == "WPA2PSK" ? 1: 2;
				params.NoForwarding = self.apIsolation();
                service.setWifiBasic(params, function (result) {
                    if (result.result == "success") {
                        setTimeout(function () {
                            if (isWifi) {
                                successOverlay();
                                setTimeout(function () {
                                    window.location.reload();
                                }, 1000);
                            } else {
                                setTimeout(function(){
                                    checkWifiDirver();
                                },2000);
                            }
                            //self.clear();
                            self.qrcode_ssid2(getRQCodeImage(false));
                        }, isWifi ? 15000 : 0);
                    } else {
                        errorOverlay();
                        self.qrcode_ssid2(getRQCodeImage(false));
                    }
                });
            };

            /**
             * 设置多SSID开关
             *
             * @event setMultiSSIDSwitch
             */
            self.setMultiSSIDSwitch = function () {
				var data = service.getOpMode();
				if(data.ip_passthrough_enabled == "1"){
					showAlert("cannot_operate_when_LTE_bridge_mode");
					return;
				}
			
                if (self.checkSettings("switch")) {
                    return;
                }

                var dirverCount = 0;
                function checkWifiDirver() {
                    service.getWpsInfo({},function(data){
                        if (data.radioFlag=='0' || data.radioFlag=='1') {
                            successOverlay();
                            clearTimer();
                            clearValidateMsg();
                            init();
                        } else {
                            if (dirverCount <= 20) {
                                dirverCount = dirverCount + 1;
                                addTimeout(function(){
                                    checkWifiDirver();
                                }, 2000);
                            } else {
                                successOverlay();
                                clearTimer();
                                clearValidateMsg();
                                init();
                            }
                        }
                    })
                }

                var setSwitch = function () {
                    var setSwitchIn = function() {
                        showLoading();
                        var params = {};
                        params.m_ssid_enable = self.multi_ssid_enable();
                        if(config.WIFI_SWITCH_SUPPORT) {
                            params.wifiEnabled = self.wifi_enable();
                        }
                        service.setWifiBasicMultiSSIDSwitch(params, function (result) {
                            if (result.result == "success") {
                                setTimeout(function () {
                                    if (isWifi) {
                                        successOverlay();
                                        setTimeout(function () {
                                            window.location.reload();
                                        }, 1000);
                                    } else {
                                        setTimeout(function(){
                                            checkWifiDirver();
                                        },2000);
                                    }
                                    //self.clear();
                                    self.qrcode_ssid1(getRQCodeImage(true));
                                    self.qrcode_ssid2(getRQCodeImage(false));
                                }, isWifi ? 15000 : 0);
                            } else {
                                errorOverlay();
                                self.qrcode_ssid1(getRQCodeImage(true));
                                self.qrcode_ssid2(getRQCodeImage(false));
                            }
                        });
                    }
                    if(self.isUfi() && service.getStatusInfo().wifi_onoff_func_control == "1" && self.wifi_enable() == "0"){
                        showConfirm("wifi_off_alert", function () {
                            setSwitchIn();
                        });
                    }else{
                        setSwitchIn();
                    }
                };

                var checkAlertCloseAP = function(){
                    if (self.multi_ssid_enable() == "1" && self.wifi_enable() == "1") {
                        var info = service.getAPStationBasic();
                        if (config.AP_STATION_SUPPORT && info.ap_station_enable == "1") {
                            showConfirm("multi_ssid_enable_confirm", function () {
                                setSwitch();
                            });
                        } else {
                            setSwitch();
                        }
                    } else {
                        setSwitch();
                    }
                }

                if(self.origin_wifi_enable == "1" && self.wifi_enable() == "1" && config.HAS_MULTI_SSID){
                    showConfirm("wifi_disconnect_confirm", function () {
                        checkAlertCloseAP();
                    });
                } else {
                    checkAlertCloseAP();
                }
            };

            /**
             * SSID1密码显示事件
             *
             * @event showPasswordHandler
             */
            self.showPasswordHandler = function () {
                $("#passShow").parent().find(".error").hide();
                var checkbox = $("#showPassword:checked");
                if (checkbox && checkbox.length == 0) {
                    self.showPassword(true);
                } else {
                    self.showPassword(false);
                }
            };
            /**
             * SSID2密码显示事件
             *
             * @event m_showPasswordHandler
             */
            self.m_showPasswordHandler = function () {
                $("#m_passShow").parent().find(".error").hide();
                var checkbox = $("#m_showPassword:checked");
                if (checkbox && checkbox.length == 0) {
                    self.m_showPassword(true);
                } else {
                    self.m_showPassword(false);
                }
            };

			 /**
             * SSID1二维码显示事件
             *
             * @event showQrCodeHandler
             */
			self.showQrCodeHandler = function () {
                $("#showQrCode").parent().find(".error").hide();
                var checkbox = $("#showQrCode:checked");
                if (checkbox && checkbox.length == 0) {
                    self.showQrCode(true);
                } else {
                    self.showQrCode(false);
                }
            };
			
			 /**
             * SSID1二维码显示事件
             *
             * @event m_showQrCodeHandler
             */
			self.m_showQrCodeHandler = function () {
                $("#m_showQrCode").parent().find(".error").hide();
                var checkbox = $("#m_showQrCode:checked");
                if (checkbox && checkbox.length == 0) {
                    self.m_showQrCode(true);
                } else {
                    self.m_showQrCode(false);
                }
            };

            function getRQCodeImage(isSSID1){
                if(self.supportQrCode()){
                    var timestamp = new Date().getTime();
                    if (isSSID1) {
                        return './img/qrcode_ssid_wifikey.png?_=' + timestamp;
                    } else if (config.HAS_MULTI_SSID) {
                        return './img/qrcode_multi_ssid_wifikey.png?_=' + timestamp;
                    } else {
                        return './img/menu_normal1.png';
                    }
                } else {
                    return './img/menu_normal1.png';
                }
            }
        }

        /**
         * 获取wifi基本信息
         * @method getWifiBasic
         * @return {Object}
         */
        function getWifiBasic() {
            return service.getWifiBasic();
        }

        /**
         * 获取wps信息
         * @method getWpsInfo
         */
        function getWpsInfo() {
            return service.getWpsInfo();
        }

        function checkConnectedDevice(){
            service.getParams({nv: 'user_ip_addr'}, function (dataIp) {
                service.getParams({nv: 'station_list'}, function (dataList) {
                    isWifi = isWifiConnected(dataIp.user_ip_addr, dataList.station_list);
                });
            });
        }
        /**
         * 初始化wifi基本view model
         * @method init
         */
        function init() {
            var container = $('#container');
            ko.cleanNode(container[0]);
            var vm = new WifiBasicVM();
            ko.applyBindings(vm, container[0]);
            addTimeout(function(){
                checkConnectedDevice();
            }, 600);

            function checkWifiStatus() {
                var info = service.getAPStationBasic();
                if (info.ap_station_enable == "1") {
                    $('#frmMultiSSID :input').each(function () {
                        $(this).prop("disabled", true);
                    });
                } else {
                    $('#frmMultiSSID :input').each(function () {
                        $(this).prop("disabled", false);
                    });
                }
            }
			
			function checkWifiStatusAccordingToWDS() {
				var info = service.getWdsInfo();
				if(info.currentMode != "0") {
					$('#frmWifiSwitch :input').each(function () {
                        $(this).prop("disabled", true);
                    });
					$('#frmSSID1 :input').each(function () {
                        $(this).prop("disabled", true);
                    });	
					$('#frmSSID2 :input').each(function () {
                        $(this).prop("disabled", true);
                    });
				} else {
					$('#frmWifiSwitch :input').each(function () {
                        $(this).prop("disabled", false);
                    });
					$('#frmSSID1 :input').each(function () {
                        $(this).prop("disabled", false);
                    });	
					$('#frmSSID2 :input').each(function () {
                        $(this).prop("disabled", false);
                    });
				}
			}

            if(config.AP_STATION_SUPPORT) {
                //P82M上ap与多ssid之间直接切换, 不做禁灰处理
				//checkWifiStatus();
			} else if(config.WDS_SUPPORT) {
				checkWifiStatusAccordingToWDS();
			}
			//clearTimer();
            //addInterval(checkWifiStatus, 1000);
			
			$('#frmWifiSwitch').validate({
				submitHandler:function () {
                    vm.setMultiSSIDSwitch();
                }
			});

            $('#frmSSID1').validate({
                submitHandler:function () {
                    vm.saveSSID1();
                },
                rules:{
                    ssid:'ssid',
                    pass:'wifi_password_check',
                    passShow:'wifi_password_check'
                },
                errorPlacement:function (error, element) {
                    var id = element.attr("id");
                    if (id == "pass" || id == "passShow") {
                        error.insertAfter("#lblShowPassword");
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        }

        return {
            init:init
        };
    });