/**
 * operation mode popup ģ��
 * @module opmode
 * @class opmode
 */

define(['knockout', 'service', 'jquery', 'config/config', 'underscore'],
    function (ko, service, $, config, _) {

    /**
	 * opModeViewModel
	 * @class opModeViewModel
	 */
     
    function opModeViewModel() {
		var self = this;
		var mode = "";
		self.selectedMode = ko.observable("0");	
		
		service.getOpMode({}, function(data){
			if(data.ip_passthrough_enabled == "1"){
				mode = "LTE_BRIDGE";
			} else{
				mode = "PPP";
			}
            self.selectedMode(mode);
		});
		
		self.changeOpMode = function(){
			 var dirverCount = 0;
			function checkWifiDirver() {
				service.getWpsInfo({},function(data){
					if (data.radioFlag=='0' || data.radioFlag=='1') {
						successOverlay();
					} else {
						if (dirverCount <= 20) {
							dirverCount = dirverCount + 1;
							addTimeout(function(){
								checkWifiDirver();
							}, 2000);
						} else {
							successOverlay();
						}
					}
				})
			}
		
			var userSelectedMode = $('input:radio[name="opMode"]:checked').val();
            var txt = "";
			var ip_passthrough_enabled = "0";
            if(userSelectedMode == mode) {
				hidePopupSettingWindow();
				return;
			}
            if(userSelectedMode == "LTE_BRIDGE"){
                txt = "opmode_msg3";
				ip_passthrough_enabled = "1";
				showConfirm(txt, function(){
					showLoading();
					service.SetOperationMode({
						ip_passthrough_enabled: ip_passthrough_enabled
					},function(data){
						if (data && data.result == "success") {
							var currentOpMode = "";
							switch(userSelectedMode){
								case "LTE_BRIDGE":
									currentOpMode = "opmode_bridge"
									break;
								case "PPPOE":
									currentOpMode = "opmode_cable";
									break;
								case "PPP":
									currentOpMode = "opmode_gateway";
									break;
								default:
									break;
							}
							$("#opmode").attr("data-trans", currentOpMode).text($.i18n.prop(currentOpMode));
							var params = {};
							params.wifiEnabled = "0";
							service.setWifiBasicMultiSSIDSwitch(params, function (result) {
								if (result.result == "success") {
									setTimeout(function(){
										checkWifiDirver();
									},2000);
								} else {
									errorOverlay();
								}
							});	
						} else {
							errorOverlay();
						}
					});
				});
            }else{
				ip_passthrough_enabled = "0";
				hidePopupSettingWindow();
				showLoading();
				service.SetOperationMode({
					ip_passthrough_enabled: ip_passthrough_enabled
				},function(data){
					if (data && data.result == "success") {
						var currentOpMode = "";
						switch(userSelectedMode){
							case "LTE_BRIDGE":
								currentOpMode = "opmode_bridge"
								break;
							case "PPPOE":
								currentOpMode = "opmode_cable";
								break;
							case "PPP":
								currentOpMode = "opmode_gateway";
								break;
							default:
								break;
						}
						$("#opmode").attr("data-trans", currentOpMode).text($.i18n.prop(currentOpMode));
						var params = {};
						params.wifiEnabled = "1";
						service.setWifiBasicMultiSSIDSwitch(params, function (result) {
							if (result.result == "success") {
								setTimeout(function(){
									checkWifiDirver();
								},2000);
							} else {
								errorOverlay();
							}
						});	
					} else {
						errorOverlay();
					}
				});
            }
			
		}
		
	}

	/**
	 * ��ʼ�� ViewModel�������а�
	 * @method init
	 */
	function init() {
		var vm = new opModeViewModel();
		ko.applyBindings(vm, $('#popupSettingWindow')[0]);
		
		$("#opmode_form").validate({
			submitHandler: function(){
				vm.changeOpMode();
			}
		});
	}

	return {
		init:init
	};
});
