/**
 * network_lock 模块
 * @module network_lock
 * @class network_lock
 */
define(['knockout', 'service', 'jquery', 'config/config', 'home'], function (ko, service, $, config, home) {

    function lockVM() {
        var self = this;
        self.isSupportSD = config.SD_CARD_SUPPORT;
        self.deviceInfo = ko.observable([]);
        self.showQRCode = config.WIFI_SUPPORT_QR_CODE;
        self.hasPhonebook = config.hasPhonebook;
        self.qrcodeSrc = './img/qrcode_ssid_wifikey.png?_=' + $.now();
        self.isHomePage = ko.observable(false);
        if(window.location.hash=="#home"){
            self.isHomePage(true);
        }

        self.supportUnlock = config.NETWORK_UNLOCK_SUPPORT;
        self.unlockCode = ko.observable();

        var info = service.getNetworkUnlockTimes();
        self.times = ko.observable(info.unlock_nck_time);

        self.unlock = function () {
            showLoading();
            service.unlockNetwork({
                unlock_network_code: self.unlockCode()
            }, function (data) {
                self.unlockCode("");
                if (data && data.result == "success") {
                    successOverlay();
                    if (window.location.hash == "#home") {
                        setTimeout(function () {
                            window.location.reload();
                        }, 500);
                    } else {
                        window.location.hash = "#home";
                    }
                } else {
                    var info = service.getNetworkUnlockTimes();
                    self.times(info.unlock_nck_time);
                    errorOverlay();
                }
            })
        };
		setTimeout(function(){
			var info = service.getParams({nv:'password_remind'});
			if(info.password_remind == "1" && config.ClickorNot == false){
				showConfirm($.i18n.prop("password_prompt")+"</br><p style='margin-top: 20px;'></p><input  style='margin-left: 3px;' type='checkbox' id='isChangePwd' onclick='setAllowChangePwd(this.checked)' class='cursorhand'" +
					"/>" + "&nbsp;" + $.i18n.prop("passwd_changed_prompt"),{ok:function () {
					config.ClickorNot = true;
					window.location.hash = "#password_management";
				}, no:function () {
					config.ClickorNot = true;
					if (config.checkFlag == true) {
						service.setNotAlert({}, function (data) {
							if (data && data.result == "success") {
							} else {
							}
						}, $.noop);
					}
				}});
			}
		},1000);
		/*******是否修改密码提示 END*************/
    }

    function init() {
        var container = $('#container')[0];
        ko.cleanNode(container);
        var vm = new lockVM();
        ko.applyBindings(vm, container);

        $("#frmNetworkLock").validate({
            submitHandler: function () {
                vm.unlock();
            },
            rules: {
                txtLockNumber: "unlock_code_check"
            }
        });
        home.initRedirectPath();
    }

    return {
        init: init
    };
});