/**
 * 选网模块
 * @module net_select
 * @class net_select
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore'],

function($, ko, config, service, _) {
    
	var lockOptions = _.map(config.LOCK_BAND, function(item) {
		return new Option(item.name, item.value);
	});
	
	function LockBandVM() {
		var self = this;
		self.lockOptions = ko.observableArray(lockOptions);
		self.lockBandType = ko.observable();
        
		
		setLockBand = function(){			
			showLoading();
			
			var params = {};
                params.lockBandType = converseUnit("toM",self.lockBandType());
			
			service.setLockBandType(params, function(data){
				hideLoading();				
				if(data.result=="success"){
					successOverlay();
				}else{					
					errorOverlay();
				}
				initLockBandType();
			});
		}
		
		var initLockBandType = function() {
			var lockBandType=service.getLockBandType();
			if(lockBandType){
				self.lockBandType(lockBandType.lte_band_lock==""?"0x8080045":converseUnit("",lockBandType.lte_band_lock));
			}
		}
		
		initLockBandType();
		
	}

	function converseUnit(flag,lockData){
		if(flag=="toMHz"){
			return lockData+"Hz";
		}else if(flag=="toM"){
			return lockData.replace("MHz","M");
		}else{
			return lockData;
		}
	}

    /**
     * 初始化选网功能view model
     * @method init
     */
	function init() {
		var container = $('#container');
		ko.cleanNode(container[0]);
		var vm = new LockBandVM();
		ko.applyBindings(vm, container[0]);
		
	}

	return {
		init : init
	};
});