/**
 * 选网模块
 * @module net_select
 * @class net_select
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore'],

function($, ko, config, service, _) {
    
	
	function LockBandVM() {
		var self = this;
		var mode = "";
		self.selectedMode = ko.observable("0");	
		
		service.getOpMode({}, function(data){
			if(data.ip_passthrough_enabled == "1"){
				mode = "LTE_BRIDGE";
			} else{
				mode = "PPP";
			}
            self.selectedMode(mode);
		});
		
		self.setModeChange = function(){
			var userSelectedMode = $('input:radio[name="changeMode"]:checked').val();
            var txt = "";
			var ip_passthrough_enabled = "0";
			
            if(userSelectedMode == "LTE_BRIDGE"){
                txt = "opmode_msg3";
				ip_passthrough_enabled = "1";
				showConfirm(txt, function(){
					showLoading();
					service.SetOperationMode({
						ip_passthrough_enabled: ip_passthrough_enabled
					},function(data){
						if (data && data.result == "success") {
							var currentOpMode = "";
							switch(userSelectedMode){
								case "LTE_BRIDGE":
									currentOpMode = "opmode_bridge"
									break;
								case "PPPOE":
									currentOpMode = "opmode_cable";
									break;
								case "PPP":
									currentOpMode = "opmode_gateway";
									break;
								default:
									break;
							}
							successOverlay();						
						} else {
							errorOverlay();
						}
					});
				});
            }else{
                txt = "opmode_msg2";
				ip_passthrough_enabled = "0";
				showLoading();
				service.SetOperationMode({
					ip_passthrough_enabled: ip_passthrough_enabled
				},function(data){
					if (data && data.result == "success") {
						var currentOpMode = "";
						switch(userSelectedMode){
							case "LTE_BRIDGE":
								currentOpMode = "opmode_bridge"
								break;
							case "PPPOE":
								currentOpMode = "opmode_cable";
								break;
							case "PPP":
								currentOpMode = "opmode_gateway";
								break;
							default:
								break;
						}
						successOverlay();						
					} else {
						errorOverlay();
					}
				});
            }
		};
		
	}


    /**
     * 初始化选网功能view model
     * @method init
     */
	function init() {
		var container = $('#container');
		ko.cleanNode(container[0]);
		var vm = new LockBandVM();
		ko.applyBindings(vm, container[0]);
		
	}

	return {
		init : init
	};
});