/**
 * restore 模块
 * @module restore
 * @class restore
 */

define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore' ],

    function ($, ko, config, service, _) {
        /**
         * restoreViewModel
         * @class restoreVM
         */
        function othersVM() {
            var self = this;
            self.wanMode = config.opms_wan_mode;
            self.isUFI = config.DEVICE.toLowerCase().indexOf("ufi") != -1;
            self.hasFastboot = config.HAS_FASTBOOT;
            self.showFastboot = self.isUFI && self.hasFastboot;
            self.showUSSD = config.HAS_USSD;
            self.showSTK = config.HAS_STK;
            self.showDDNS = config.HAS_DDNS;
            var inChildGroup = false;
            if (config.HAS_PARENTAL_CONTROL) {
                inChildGroup = service.checkCurrentUserInChildGroup().result;
            }
            self.currentUserInChildGroup = ko.observable(inChildGroup);

            /**
             * 恢复出厂设置
             * @event restore
             */
            self.restore = function () {
//                var connectStatus = service.getConnectionInfo().connectStatus;
//                if (checkConnectedStatus(connectStatus)) {
//                    showAlert("restore_when_connected");
//                    return;
//                }
                showConfirm("restore_confirm", function () {
                    showLoading("restoring");
                    service.restoreFactorySettings({}, function (data) {
                        if (data && data.result == "success") {
                            successOverlay();
                        } else {
                            errorOverlay();
                        }
                    }, function (result) {
                        if (isErrorObject(result) && result.errorType == 'no_auth') {
                            errorOverlay();
                        }
                    });
                });
            };

            self.restart = function () {
//                var connectStatus = service.getConnectionInfo().connectStatus;
//                if (checkConnectedStatus(connectStatus)) {
//                    showAlert("restart_when_connected");
//                    return;
//                }
                showConfirm("restart_confirm", function () {
                    showLoading("restarting");
                    service.restart({}, function (data) {
                        if (data && data.result == "success") {
                            successOverlay();
                        } else {
                            errorOverlay();
                        }
                    }, $.noop);
                });
            };
        }
        /**
         * 初始化 ViewModel，并进行绑定
         * @method init
         */
        function init() {
            var vm = new othersVM();
            ko.applyBindings(vm, $('#container')[0]);
        }

        return {
            init:init
        }
    });