#!/bin/sh

echo "begin to start wifi"	
SET_WLAN="iwpriv wlan0"

insmod /usr/lib/modules/3.18.20/kernel/drivers/net/wireless/rtl8189es.ko

echo "begin to set rf parameters!" 
CONFIG_DIR="/usr/wlan_backups/wlan0"

set_default_parameters()
{
	$SET_WLAN  set_mib pwrlevelCCK_A=3131313131313131313130303030
	$SET_WLAN  set_mib pwrlevelHT40_1S_A=2F2F2F2F2F2F2F2F2F2F25252525
	$SET_WLAN  set_mib pwrdiffHT20=0000000000000000000000000000
	$SET_WLAN  set_mib pwrdiffOFDM=2222222222222222222222222222
	$SET_WLAN  set_mib ther=0x1F
	$SET_WLAN  set_mib xcap=0x21
}

if [ ! -d "$CONFIG_DIR" ]; then
	echo "$CONFIG_DIR not exist!" 
	set_default_parameters	
else	
	GET_TX_POWER_CCK_A=`cat $CONFIG_DIR/tx_power_cck_a`
	if [ "$GET_TX_POWER_CCK_A" != "0000000000000000000000000000" ]; then
		GET_TX_POWER_HT40_1S_A=`cat $CONFIG_DIR/tx_power_ht40_1s_a`		
		GET_TX_POWER_DIFF_HT20=`cat $CONFIG_DIR/tx_power_diff_ht20`
		GET_TX_POWER_DIFF_OFDM=`cat $CONFIG_DIR/tx_power_diff_ofdm`
		GET_THER=`cat $CONFIG_DIR/11n_ther`
		GET_XCAP=`cat $CONFIG_DIR/11n_xcap`
		echo "configure TX power"  
		$SET_WLAN set_mib pwrlevelCCK_A=$GET_TX_POWER_CCK_A
		$SET_WLAN set_mib pwrlevelHT40_1S_A=$GET_TX_POWER_HT40_1S_A
		$SET_WLAN set_mib pwrdiffHT20=$GET_TX_POWER_DIFF_HT20
		$SET_WLAN set_mib pwrdiffOFDM=$GET_TX_POWER_DIFF_OFDM
		$SET_WLAN set_mib ther=0x$GET_THER
		$SET_WLAN set_mib xcap=0x$GET_XCAP
	else
		echo "tx_power_cck_a & tx_power_cck_b is NULL!" 
		set_default_parameters		
	fi
fi

echo "finished setting rf parameters!" 

$SET_WLAN set_mib opmode=16
$SET_WLAN set_mib trswitch=0
$SET_WLAN set_mib ampdu=1
$SET_WLAN set_mib amsdu=0
$SET_WLAN set_mib stbc=0
$SET_WLAN set_mib nat25_disable=0
$SET_WLAN set_mib macclone_enable=0
$SET_WLAN set_mib preamble=0
$SET_WLAN set_mib countrycode=1
$SET_WLAN set_mib wsc_enable=1
# set WiFi specific mode
$SET_WLAN set_mib wifi_specific=2
# for WMM
$SET_WLAN set_mib qos_enable=1
$SET_WLAN set_mib apsd_enable=1
# for guest access
$SET_WLAN set_mib guest_access=0
$SET_WLAN set_mib gk_rekey=86400
$SET_WLAN set_mib shortGI20M=1
$SET_WLAN set_mib shortGI40M=1
$SET_WLAN set_mib shortGI80M=1
#disable wlan0 fun and use vap
$SET_WLAN set_mib func_off=1
$SET_WLAN set_mib vap_enable=1

echo "load wifi end"