/**
 * Router设置
 * @module lan
 * @class lan
 */
define([ 'jquery', 'knockout', 'config/config', 'service'],
    function ($, ko, config, service) {

        var ddnsProviderList = _.map(config.DDNSDDP, function(item){
            return new Option(item.name, item.value);
        });

        var ddns_mode_select = _.map(config.ddns_Modeselect, function(item){
            return new Option(item.name, item.value);
        });
        function ddnsSettingsVM() {
            var self = this;

            var data = service.getDdnsParams();
            self.ddnsFucEnable = ko.observable(data.DDNS_Enable);
            self.ddnsModes = ko.observable(ddns_mode_select);
            self.ddnsSelectedMode = ko.observable(data.DDNS_Mode);
            self.ddnsProviders = ko.observable(ddnsProviderList);
            self.ddnsSelectedProvider = ko.observable("dyndns.org");
            $.each(config.DDNSDDP,function(i,n){
                if(data.DDNSProvider == n.value){
                    self.ddnsSelectedProvider(data.DDNSProvider);
                    /*if(data.DDNSProvider!="other"){
                     self.customProvider("");
                     }*/
                }
            });
            self.ddnsAccount = ko.observable(data.DDNSAccount);
            self.ddnsPassword = ko.observable(data.DDNSPassword);
            self.ddnsDomainName = ko.observable(data.DDNS);
            self.ddnsHashValue = ko.observable(data.DDNS_Hash_Value);
            self.showDdnsState = ko.observable(false);
            self.ddnsState = ko.observable();

            self.showPassword = ko.observable(false);
            self.showPasswordHandler = function () {
                $("#ddnsPassword").parent().find(".error").hide();
				$("#ddnsPassShow").parent().find(".error").hide();
                var checkbox = $("#showPassword:checked");
                if (checkbox && checkbox.length == 0) {
                    self.showPassword(true);
                } else {
                    self.showPassword(false);
                }
            };
            /**
             * 提交
             * @method setDDNSForward
             */
            self.apply = function() {
                showLoading();
                var params = {};
                params.goformId = "DDNS";
                params.DDNS_Enable = self.ddnsFucEnable();
                if(self.ddnsFucEnable() == "1") {
                    params.DDNS_Mode = self.ddnsSelectedMode();
                    params.DDNSProvider = self.ddnsSelectedProvider();

                    if(self.ddnsSelectedProvider() != "") {
                        params.DDNSAccount = self.ddnsAccount();
                        params.DDNSPassword = self.ddnsPassword();
                        params.DDNS = self.ddnsDomainName();
                    }
                    if(self.ddnsSelectedProvider() == "freedns.afraid.org") {
                        params.DDNS_Hash_Value = self.ddnsHashValue();
                    }

                }

                service.setDDNSForward(params, function(result) {
                    if (result.result == "success") {
                        successOverlay();
                    } else {
                        errorOverlay();
                    }
                });
            };


            updateScanStatus();

            function updateScanStatus() {
                var trans = "";
                $.getJSON("/goform/goform_get_cmd_process", {
                    cmd : "getddns_status",
                    "_" : new Date().getTime()
                }, function(data) {

                    if (data.getddns_status == "0") {
                        trans = "register_successful";
                        self.showDdnsState(true);
                    }else if(data.getddns_status == "1"){
                        trans = "login_error";
                        self.showDdnsState(true);
                    }else if(data.getddns_status == "2"){
                        trans = "network_error";
                        self.showDdnsState(true);
                    }else if(data.getddns_status == "3"){
                        trans = "registering";
                        self.showDdnsState(true);
                    }else if(data.getddns_status == "4"){
                        trans = "not_registered";
                        self.showDdnsState(true);
                    }else if(data.getddns_status == "5"){
                        trans = "error_registering";
                        self.showDdnsState(true);
                    }else if(data.getddns_status == "-1"){
                        trans = "";
                        self.showDdnsState(true);
                    }
                    self.ddnsState($.i18n.prop(trans));
                    addTimeout(updateScanStatus, 1000);
                });
            }
        }

        function init() {
            var container = $('#container');
            ko.cleanNode(container[0]);
            var vm = new ddnsSettingsVM();
            ko.applyBindings(vm, container[0]);

            $('#frmDDNS').validate({
                submitHandler:function () {
                    vm.apply();
                },
                rules: {
                    ddnsPassword:"password_check",
                    ddns_HashValue:"ddns_hashvalue_check",
                    ddnsPassShow:"password_check"
                }
            });

        }

        return {
            init:init
        }
    }
);
