#!/bin/sh
# build by zhangyuelong10100551 for ipacm config update - 2016.09.05

ipacm_cfg_file="/etc/IPACM_cfg.xml"

lan_ip_addr=`cfg get lan_ipaddr`
lan_netmask=`cfg get lan_netmask`

# update IPACM_cfg.xml
ip_prefix=${lan_ip_addr%*.*}.0

if cat $ipacm_cfg_file | grep -q \<SubnetAddress\>$ip_prefix\<\/SubnetAddress\>
then
    echo "$0: no need update"
    echo "$0: no need update" >> /dev/kmsg
else
    sed -i "s/<SubnetAddress>.*<\/SubnetAddress>/<SubnetAddress>$ip_prefix<\/SubnetAddress>/" $ipacm_cfg_file
    sed -i "s/<SubnetMask>.*<\/SubnetMask>/<SubnetMask>$lan_netmask<\/SubnetMask>/" $ipacm_cfg_file
    echo "$0: update done"
    echo "$0: update $ip_prefix done" >> /dev/kmsg
fi

start-stop-daemon -S -b -a ipacm
echo "$0: start ipacm done"
echo "$0: start ipacm done" >> /dev/kmsg
