/**
 * mac filter
 * @module mac filter
 * @class mac filter
 */

define(['knockout', 'service', 'jquery', 'config/config', 'underscore'],
    function (ko, service, $, config, _) {
		 var isWifi = false;
		/**
         * macFilterVM
         * @class macFilterVM
         */
        function macFilterVM() {
			var info = service.getMacFilterInfo();
			var basicInfo = service.getWifiBasic();
            var self = this;
			self.macFilterEnable = ko.observable(info.ACL_mode);
			self.blackListEnabled = ko.observable(info.ACL_mode == "2");
			self.blackList = ko.observable(parseStringToArray(info.wifi_hostname_black_list,info.wifi_mac_black_list));
			self.deviceInfo = ko.observable([]);
            self.macAddressName = ko.observable('');
			self.hasWifiSwitch = config.WIFI_SWITCH_SUPPORT;
			self.hasMultiSSID = config.HAS_MULTI_SSID;
			self.hasApStation = config.AP_STATION_SUPPORT;
			self.isUfi = ko.observable(config.DEVICE.toLowerCase().indexOf("ufi") !=-1);
			self.hasMacFilter = config.HAS_MAC_FILTER;
            self.macAddress = ko.observable('');
			self.origin_wifi_enable = basicInfo.wifi_enable;
			self.wifi_enable = ko.observable(basicInfo.wifi_enable);
			self.isShowSSIDInfoDiv = ko.observable(false);
			if(config.WIFI_SWITCH_SUPPORT) {
				if(basicInfo.wifi_enable == "1") {
					self.isShowSSIDInfoDiv(true);
				} else {
					self.isShowSSIDInfoDiv(false);
				}
			} else {
				self.isShowSSIDInfoDiv(true);//如果不支持软开关，整个SSID信息块显示
			}
			self.multi_ssid_enable = ko.observable(basicInfo.multi_ssid_enable);
			refreshDeviceInformation();
				
			addInterval(function(){
				refreshDeviceInformation();
			}, 3000);

			self.setMacFilter = function() {
				var macStr = "";
				_.map(self.blackList(), function(item){
					macStr = macStr==""?item.macAddress:macStr+';'+item.macAddress;
				});
				var requestParams = {
					ACL_mode: self.macFilterEnable(),
					wifi_mac_black_list: macStr
				};
				apply(requestParams);
			}
			
			addToBlackList = function(mac,ipAddr,id) {
                if(info.user_ip_addr == ipAddr) {
                    showAlert("black_yourself_tip");
                    return false;
                }

                if(self.blackList().length >= 32) {
					showAlert("black_list_max");
					return false;
				}
				var macStr = info.wifi_mac_black_list == "" ?  mac : mac + ';' + info.wifi_mac_black_list;
				var requestParams = {
					ACL_mode: self.macFilterEnable(),
					wifi_mac_black_list: macStr
				};
				apply(requestParams,id);
			};
			
			removeFromBlackList = function(id){
				var macStr = "";
				var tempArray = self.blackList();
				tempArray.splice(parseInt(id, 10), 1);
				_.map(tempArray, function(item){
					macStr = macStr== ''?item.macAddress:macStr+';'+item.macAddress;
				});
				var requestParams = {
					ACL_mode: self.macFilterEnable(),
					wifi_mac_black_list: macStr
				};
				apply(requestParams);
			}
			
			//�ύ����
			function apply(params, id) {
				/*if(info.RadioOff == "0") {
					showAlert("wps_wifi_off");
					return false;
				}*/
				var wpsState = service.getWpsInfo();
				if(wpsState.wpsFlag == "1") {
					showAlert('wps_on_info');
					return false;
				}
				var requestParams = $.extend({
				},params);
				service.setMacFilter(requestParams, function(data){
					if(data.result == "success") {
						successOverlay();
						self.macFilterEnable(requestParams.ACL_mode);
						self.blackList(parseStringToArray(requestParams.wifi_hostname_black_list,requestParams.wifi_mac_black_list));
						self.blackListEnabled(requestParams.ACL_mode == "2");
						info.ACL_mode = requestParams.ACL_mode;
						info.wifi_hostname_black_list = requestParams.wifi_hostname_black_list;
						info.wifi_mac_black_list = requestParams.wifi_mac_black_list;
						$('#blacklist').translate();
                        if(id!=""){
                            $('#'+id).attr("disabled", true);
                        }else{
                            self.macAddressName('');
                            self.macAddress('');
                        }
					} else {
						errorOverlay();
					}
				});
			}
			
			function parseStringToArray(strHostName,strMac) {
				if(strMac == "") {
					return [];
				}
				var tempMac = strMac.split(';');
				var result = [];
				for(var i = 0; i < tempMac.length; i++) {
					var obj = {};
					obj.macAddress = tempMac[i];
					result.push(obj);
				}
				return result;
			}
			
			function refreshDeviceInformation() {
				if(info.ACL_mode == "2") {
					service.getCurrentlyAttachedDevicesInfo({}, function(devices){
						//self.deviceInfo(devices.attachedDevices);
						var resultArray = [];
						var deviceInfoArr = [];
						_.map(devices.attachedDevices,function(item){
							deviceInfoArr.push(item.macAddress);
							var obj = $.extend({
								enabled: true
							}, item);
							resultArray.push(obj);
						});
						var blackMacArr = info.wifi_mac_black_list.split(';');
						for(var i = 0;i < blackMacArr.length; i++){
							var index = $.inArray(blackMacArr[i], deviceInfoArr);
							if(index != -1){
								resultArray[index].enabled = false;
							}
						}
						self.deviceInfo(resultArray);
						$('#deviceInfo').translate();
					});
				}
			}

            /**
             * 手动添加规则
             * @method save
             */
            self.saveManual = function() {
                if(info.wifi_mac_black_list != ""){
                    var macList = info.wifi_mac_black_list.split(';');
                    for(var i=0;i<macList.length;i++){
                        if(self.macAddress().toLowerCase() == macList[i].toLowerCase()){
                            showAlert('item_is_exist');
                            return false;
                        }
                    }
                }

                addToBlackList(self.macAddress(),'','');
            };
			
			self.setMultiSSIDSwitch = function () {
				if (self.checkSettings("switch")) {
					return;
				}

				var dirverCount = 0;
				function checkWifiDirver() {
					service.getWpsInfo({},function(data){
						if (data.radioFlag=='0' || data.radioFlag=='1') {
							successOverlay();
							clearTimer();
							clearValidateMsg();
							init(self);
						} else {
							if (dirverCount <= 20) {
								dirverCount = dirverCount + 1;
								addTimeout(function(){
									checkWifiDirver();
								}, 2000);
							} else {
								successOverlay();
								clearTimer();
								clearValidateMsg();
								init(self);
							}
						}
					})
				}

				var setSwitch = function () {
					var setSwitchIn = function() {
						showLoading();
						var params = {};
						params.m_ssid_enable = self.multi_ssid_enable();
						if(config.WIFI_SWITCH_SUPPORT) {
							params.wifiEnabled = self.wifi_enable();
						}
						service.setWifiBasicMultiSSIDSwitch(params, function (result) {
							if (result.result == "success") {
								setTimeout(function () {
									if (isWifi) {
										successOverlay();
										setTimeout(function () {
											window.location.reload();
										}, 1000);
									} else {
										setTimeout(function(){
											checkWifiDirver();
										},2000);
									}
								}, isWifi ? 15000 : 0);
							} else {
								errorOverlay();
							}
						});

					}
					if(self.isUfi() && service.getStatusInfo().wifi_onoff_func_control == "1" && self.wifi_enable() == "0"){
						showConfirm("wifi_off_alert", function () {
							setSwitchIn();
						});
					}else{
						setSwitchIn();
					}
				};

				var checkAlertCloseAP = function(){
						if (self.multi_ssid_enable() == "1" && self.wifi_enable() == "1") {
							var info = service.getAPStationBasic();
							if (config.AP_STATION_SUPPORT && info.ap_station_enable == "1") {
								showConfirm("multi_ssid_enable_confirm", function () {
									setSwitch();
								});
							} else {
								setSwitch();
							}
						} else {
							setSwitch();
						}
					}

					if(self.origin_wifi_enable == "1" && self.wifi_enable() == "1" && config.HAS_MULTI_SSID){
						showConfirm("wifi_disconnect_confirm", function () {
							checkAlertCloseAP();
						});
					} else {
						checkAlertCloseAP();
					}
			};
			self.checkSettings = function (ssid) {
				var wifi_dfs_status = service.getStatusInfo().wifi_dfs_status;
				if(wifi_dfs_status == '1'){
					showAlert('cannot_set_when_radar_scaning');
					return true;
				}

				var status = getWpsInfo();
				if (status.wpsFlag == '1') {
					showAlert('wps_on_info');
					return true;
				}

				return false;
			};
			
			function getWpsInfo() {
				return service.getWpsInfo();
			}
			
			function checkConnectedDevice(){
				service.getParams({nv: 'user_ip_addr'}, function (dataIp) {
					service.getParams({nv: 'station_list'}, function (dataList) {
						isWifi = isWifiConnected(dataIp.user_ip_addr, dataList.station_list);
					});
				});
			}
		}

        /**
         * ��ʼ�� ViewModel�������а�
         * @method init
         */
        function init() {
			var container = $("#container");
			ko.cleanNode(container[0]);
			var vm = new macFilterVM();
            ko.applyBindings(vm, container[0]);
			
			 $('#frmWifiSwitch').validate({
				submitHandler:function () {
					vm.setMultiSSIDSwitch();
				}
			});
			
			$('#macFilterForm').validate({
				submitHandler:function () {
                    vm.setMacFilter();
                }
			});

            $('#setBlackListFrm').validate({
                submitHandler : function() {
                    vm.saveManual();
                },
                rules: {
                    txtMacAddress: {
                        white_list_optional: true,
                        mac_check: true
                    }
                },

                errorPlacement: function(error, element) {
                    if(element.attr("name") == "txtMacAddress") {
                        error.insertAfter("#macExamLabel");
                    }
                    else
                        error.insertAfter(element);
                }
            });
        }

        $.validator.addMethod("white_list_optional", function (value, element, param) {
            var result = _.any(['#txtMacAddress'],
                function(item) {
                    return $(item+':visible').length > 0 && $(item).val() != '';
                }
            );

            return result;
        });

        return {
            init:init
        };
    });
