/**
 * restore 模块
 * @module restore
 * @class restore
 */

define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore' ],

    function ($, ko, config, service, _) {
        /**
         * restoreViewModel
         * @class restoreVM
         */
        function othersVM() {
            var self = this;
            self.wanMode = config.opms_wan_mode;
            self.isUFI = config.DEVICE.toLowerCase().indexOf("ufi") != -1;
            self.hasFastboot = config.HAS_FASTBOOT;
            self.showFastboot = self.isUFI && self.hasFastboot;
            self.showUSSD = config.HAS_USSD;
            self.showSTK = config.HAS_STK;
            self.showDDNS = config.HAS_DDNS;
            var inChildGroup = false;
            if (config.HAS_PARENTAL_CONTROL) {
                inChildGroup = service.checkCurrentUserInChildGroup().result;
            }
            self.currentUserInChildGroup = ko.observable(inChildGroup);
        }
        /**
         * 初始化 ViewModel，并进行绑定
         * @method init
         */
        function init() {
            var vm = new othersVM();
            ko.applyBindings(vm, $('#container')[0]);
        }

        return {
            init:init
        }
    });