/**
 * HOME模块
 * @module Home
 * @class Home
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore', 'status/statusBar' ],

function($, ko, config, service, _, statusBar) {

	/**
	 * connection information ViewModel
	 * 
	 * @class connectInfoVM
	 */
	function connectInfoVM() {
		var self = this;
		var info = service.getConnectionInfo();
		self.connectStatus = ko.observable(info.connectStatus);
		if (checkConnectedStatus(info.connectStatus)) {
			self.current_Flux = ko.observable(transUnit(parseInt(info.data_counter.currentReceived, 10) + parseInt(info.data_counter.currentSent, 10), false));
			//self.total_Flux = ko.observable(transUnit(parseInt(info.data_counter.totalSent, 10) + parseInt(info.data_counter.totalReceived, 10), false));
			self.connected_Time = ko.observable(transSecond2Time(info.data_counter.currentConnectedTime));
			self.up_Speed = ko.observable(transUnit(info.data_counter.uploadRate, true));
			self.down_Speed = ko.observable(transUnit(info.data_counter.downloadRate, true));
		} else {
			self.current_Flux = ko.observable(transUnit(0, false));
			self.connected_Time = ko.observable(transSecond2Time(0));
			self.up_Speed = ko.observable(transUnit(0, true));
			self.down_Speed = ko.observable(transUnit(0, true));
		}
        self.hasWifi = ko.observable(config.HAS_WIFI);
		self.transText = ko.dependentObservable(function() {
			if (checkConnectedStatus(self.connectStatus())) {
				return "disconnect";
			} else {
				return "connect";
			}
		});
		
		self.canConnect = ko.observable(getCanConnectNetWork());
		self.connectStatusText = ko.dependentObservable(function() {
			self.canConnect();
			
			if (checkConnectedStatus(self.connectStatus())) {
				return $.i18n.prop("disconnect");
			} else {
				return $.i18n.prop("connect");
			}
		});
		self.imagePath = ko.dependentObservable(function() {
			if (checkConnectedStatus(self.connectStatus())) {
				return "img/connect.png";
			} else if(self.connectStatus() == 'ppp_disconnected'){
				return "img/disconnect.png";
			} else if(self.connectStatus() == 'ppp_connecting'){
				return "img/connecting.gif";
			} else {
				return "img/disconnecting.gif";
			}
		});

        //var devices = service.getCurrentlyAttachedDevicesInfo();
        var dev = fixAttachedDevicesInfo([]);
        self.deviceInfo = ko.observable(dev);
		
		self.supportQrCode = ko.observable(config.WIFI_SUPPORT_QR_CODE);
		self.qrcode_ssid1 = ko.observable(getRQCodeImage(true));
		//联网状态下显示当前APN的profile
		var settings = service.getApnSettings();
		self.showAPNv4 = ko.observable(settings.pdpType == 'IP' || settings.pdpType == 'IPv4v6');
		self.curAPNv4 = ko.observable(settings.wanApn);
		self.curAPNv6 = ko.observable(settings.wanApnV6);
		self.showAPNv6 = ko.observable(settings.pdpType == 'IPv6');
		self.showProfile = ko.observable(checkConnectedStatus(self.connectStatus()));

        function getRQCodeImage(isSSID1) {
            if (self.supportQrCode()) {
                var timestamp = new Date().getTime();
                if (isSSID1) {
                    return './img/qrcode_ssid_wifikey.png?_=' + timestamp;
                } else if (config.HAS_MULTI_SSID) {
                    return './img/qrcode_multi_ssid_wifikey.png?_=' + timestamp;
                } else {
                    return './img/menu_normal1.png';
                }
            } else {
                return './img/menu_normal1.png';
            }
        }

		/**
		 * 响应连接按钮事件
		 * 
		 * @event connectHandler
		 */
		self.connectHandler = function() {
			if (checkConnectedStatus(self.connectStatus())) {
                showLoading('disconnecting');
				service.disconnect({}, function(data) {
					if(data.result){
						successOverlay();
					} else {
						errorOverlay();
					}
				});
			} else {
                if(service.getStatusInfo().roamingStatus) {
                    showConfirm('dial_roaming_connect', function(){
                        self.connect();
                    });
                } else {
                    self.connect();
                }
			}
		};

        self.connect = function() {
            var statusInfo = service.getStatusInfo();
            var trafficResult = statusBar.getTrafficResult(statusInfo);
            if(statusInfo.limitVolumeEnable && trafficResult.showConfirm){
                var confirmMsg = null;
                if(trafficResult.usedPercent > 100){
                    confirmMsg = {msg: 'traffic_beyond_connect_msg'};
                    statusBar.setTrafficAlertPopuped(true);
                } else {
                    confirmMsg = {msg: 'traffic_limit_connect_msg', params: [trafficResult.limitPercent]};
                    statusBar.setTrafficAlert100Popuped(false);
                }
                showConfirm(confirmMsg, function(){
                    doConnect();
                });
            }else{
                doConnect();
            }
        };
	}

    function doConnect(){
        showLoading('connecting');
        service.connect({}, function(data) {
            if(data.result){
                successOverlay();
            } else {
                errorOverlay();
            }
        });
    }

    function fixAttachedDevicesInfo(devices) {
        var emptyInfo = {
            macAddress:"",
            ipAddress:"",
            hostName:"",
            timeConnected:""
        };
        var deviceNum = 0;
        if (devices) {
            deviceNum = devices.length;
        } else {
            devices = [];
        }
        var maxNumber = config.MAX_STATION_NUMBER <= 10 ? config.MAX_STATION_NUMBER : 10;
        if (config.MAX_STATION_NUMBER <= 10) {
            for (var i = 0; i < maxNumber - deviceNum; i++) {
                devices.push(emptyInfo);
            }
        } else {
            if (deviceNum <= 10) {
                for (var j = 0; j < 10 - deviceNum; j++) {
                    devices.push(emptyInfo);
                }
            }
        }
        return devices;
    }

    function getCanConnectNetWork(){
        var status = service.getStatusInfo();
        if (status.simStatus != "modem_init_complete") {
            return false;
        }
        
        if (checkConnectedStatus(status.connectStatus)) {
        /*    if (config.AP_STATION_SUPPORT) {
                if (status.ap_station_enable == true) {
                    var result = service.getConnectionMode();
                    if (result.connectionMode == "auto_dial") {
                        return false;
                    }
                }
            }*/
            return true;
        }
	
	    //2g/3g 情况下，如果没有注册到PS域,连网按钮需禁灰
        if(status.networkType != 'LTE'){
            if(status.domain_stat == 'CS_ONLY' || status.domain_stat == ''){
                return false;
            }
        }
	//如果已联网，但是没有信号，断网按钮需要可以用
        if (status.signalImg == "0") {
            return false;
        }
        var networkTypeTmp = status.networkType.toLowerCase();
        if (networkTypeTmp == '' || networkTypeTmp == 'limited_service' || networkTypeTmp == 'no_service') {
            return false;
        }
        if("ppp_connecting"==status.connectStatus || "ppp_disconnecting"==status.connectStatus){
            return false;
        }
        if (config.AP_STATION_SUPPORT) {
            if (status.connectWifiStatus == "connect") {
                if (status.ap_station_mode == "wifi_pref") {
                    return false;
                }
            }
        }

        return true;
    }

    function refreshHomeData(connectionVM){
        var info = service.getConnectionInfo();
        connectionVM.connectStatus(info.connectStatus);
        if (checkConnectedStatus(info.connectStatus)) {
            connectionVM.current_Flux(transUnit(parseInt(info.data_counter.currentReceived, 10) + parseInt(info.data_counter.currentSent, 10), false));
            //connectionVM.total_Flux(transUnit(parseInt(info.data_counter.totalSent, 10) + parseInt(info.data_counter.totalReceived, 10), false));
            connectionVM.connected_Time(transSecond2Time(info.data_counter.currentConnectedTime));
            connectionVM.up_Speed(transUnit(info.data_counter.uploadRate, true));
            connectionVM.down_Speed(transUnit(info.data_counter.downloadRate, true));
        } else {
            connectionVM.current_Flux(transUnit(0, false));
            //connectionVM.total_Flux(transUnit(parseInt(info.data_counter.totalSent, 10) + parseInt(info.data_counter.totalReceived, 10), false));
            connectionVM.connected_Time(transSecond2Time(0));
            connectionVM.up_Speed(transUnit(0, true));
            connectionVM.down_Speed(transUnit(0, true));
        }
        connectionVM.canConnect(getCanConnectNetWork());
		//new add for showing the info of APN
		connectionVM.showProfile(checkConnectedStatus(info.connectStatus));
		var settings = service.getApnSettings();
		connectionVM.showAPNv4(settings.pdpType == 'IP' || settings.pdpType == 'IPv4v6');
		connectionVM.curAPNv4(settings.wanApn);
		connectionVM.curAPNv6(settings.wanApnV6);
		connectionVM.showAPNv6(settings.pdpType == 'IPv6');
    }

    var attachedMacAddresses = [];
    function refreshAttachedDevicesInfo(connectionVM, callback) {
        service.getCurrentlyAttachedDevicesInfo({}, function (devices) {
            var needRefresh = false;
            if (!$.isArray(devices.attachedDevices)) {
                devices.attachedDevices = [];
            }
            if (devices.attachedDevices.length == 0) {
                attachedMacAddresses = [];
            }
            if (devices.attachedDevices.length != 0 && devices.attachedDevices.length == attachedMacAddresses.length && attachedMacAddresses[0] != "" ) {
                for (var i = 0; i < devices.attachedDevices.length; i++) {
                    if (!$.inArray(devices.attachedDevices[0].macAddress, attachedMacAddresses)) {
                        needRefresh = true;
                        break;
                    }
                }
            } else {
                needRefresh = true;
            }
            if(needRefresh){
                attachedMacAddresses = [];
                for(var i = 0; i < devices.attachedDevices.length; i++){
                    attachedMacAddresses.push(devices.attachedDevices[0].macAddress);
                }
                var dev = fixAttachedDevicesInfo(devices.attachedDevices);
                connectionVM.deviceInfo(dev);
                if ($.isFunction(callback)) {
                    callback();
                }
            }
        });
    }

    function refreshAttachedDevicesInterval(connectionVM) {
        refreshAttachedDevicesInfo(connectionVM, function () {
            addTimeout(function () {
                refreshAttachedDevicesInterval(connectionVM);
            }, 1000);
        });
    }

    function initRedirectPath(){
        function redirectNoConPath(){
            var curentHref = window.location.href;
            window.location.href = curentHref.slice(0,curentHref.indexOf("?no_connect")) + "#home";
        }

        var info = service.getStatusInfo();
        var curentHref = window.location.href;
        if(window.location.href.indexOf("?no_connect") != -1){
            if(service.getEthernetConnect().is_rj45_connected){
                showPromptNoImg("pppoe_error_jump_login",function(){
                    window.location.href = curentHref.slice(0,curentHref.indexOf("?no_connect")) + (config.hasRJ45?"#ethernet_settings":"#home");
                });

            } else {
                if(info.simStatus == "modem_sim_undetected"){
                    showPromptNoImg("no_simcard_jump",function(){
                        redirectNoConPath();
                    });
                } else if(info.simStatus == "modem_sim_destroy" || info.simStatus == "modem_destroy") {
                    showPromptNoImg("invalid_simcard_jump",function(){
                        redirectNoConPath();
                    });
                }else if(info.simStatus == "modem_imsi_waitnck"  || info.simStatus == "modem_waitpin"|| info.simStatus == "modem_waitpuk") {
                    showPromptNoImg("locked_simcard_jump_login",function(){
                        redirectNoConPath();
                    });
                } else {
                    if(info.ppp_dial_conn_fail_counter == '0' || info.ppp_dial_conn_fail_counter == ''){
                        showPromptNoImg("no_connect_jump_login",function(){
                            redirectNoConPath();
                        });
                    } else {
                        showPromptNoImg("connect_failed_jump_login",function(){
                            redirectNoConPath();
                        });
                    }
                }
            }
        } else if(window.location.href.indexOf("?flow_beyond") != -1){
            showPromptNoImg("flow_beyond_jump_login",function(){
                service.setRedirectOff();
                window.location.href = curentHref.slice(0,curentHref.indexOf("?flow_beyond")) + "#traffic_alert";
            });
        } else if(window.location.href.indexOf("?fota_upgrade") != -1){
            showPromptNoImg("fota_upgrade_jump_login",function(){
                service.setRedirectOff();
                window.location.href = curentHref.slice(0,curentHref.indexOf("?fota_upgrade")) + "#ota_update";

            });
        }
    }

    /**
	 * 初始化vm
	 * 
	 * @method init
	 */
	function init() {
		var container = $('#container')[0];
		ko.cleanNode(container);

		var connectionVM = new connectInfoVM();
		ko.applyBindings(connectionVM, container);
        initRedirectPath();

		$('#frmHome').validate({
			submitHandler : function() {
				connectionVM.connectHandler();
			}
		});

        refreshHomeData(connectionVM);
		addInterval(function() {
            refreshHomeData(connectionVM);
        }, 1000);

        refreshAttachedDevicesInterval(connectionVM);
	}

    return {
        init:init,
        refreshAttachedDevicesInfo:refreshAttachedDevicesInfo,
        initRedirectPath:initRedirectPath
    };
});