#!/bin/sh
#
# created by zhangyuelong10100551 for control ssid B access webUI
#
second_ssid_dev_name=`cfg get wifi_m_ap_net`
lan_sec_ssid_control=`cfg get lan_sec_ssid_control`
lan_ipaddr_for_current=`cfg get lan_ipaddr_for_current`
cur_mod=`cfg get apsta_type`     # ap / apsta / apap

ebtables -D INPUT -j second_ssid_access_control
ebtables -F second_ssid_access_control
ebtables -X second_ssid_access_control

if [ "$cur_mod" != "apap" ]
then
  echo "cur_mod is [$cur_mod], not [apap], exit"
  exit
fi

if [ "$lan_sec_ssid_control" == "1" ]
then
  echo "lan_sec_ssid_control [$lan_sec_ssid_control] drop webUI"
  ebtables -N second_ssid_access_control
  ebtables -A INPUT -j second_ssid_access_control
  ebtables -A second_ssid_access_control -i $second_ssid_dev_name -p IPv4 --ip-destination $lan_ipaddr_for_current --ip-proto tcp --ip-dport 80 -j DROP
else
  echo "lan_sec_ssid_control [$lan_sec_ssid_control] allow webUI"
fi
