#!/bin/sh

#usuage:$0 type

WlanType=$1
echo wlan config with wlan type $WlanType

#step 1 : load wlan driver begin
rmmod dhd
echo msm_hsic_host > /sys/bus/platform/drivers/msm_hsic_host/unbind
sleep 1
echo msm_hsic_host > /sys/bus/platform/drivers/msm_hsic_host/bind
sleep 1
bcmdl -n /etc/bcm43241/nvram_hsic.txt /etc/bcm43241/fw_hsic.bin.trx
insmod /etc/bcm43241/dhd.ko
ifconfig eth0 up
#step 1 : load wlan driver   end

export WlanBand=`cfg get wifi_band`
export WlanMode=`cfg get WirelessMode`
export WlanChannel=`cfg get Channel`


bcm_wlan_auto_channel()
{
	wl down
	wl spect 0
	wl ssid ""
	wl up
	wl autochannel 1
	wl channel
	sleep 6
	wl autochannel
	sleep 1
	wl autochannel 2
	sleep 1
	wl channel
	wl down
}

bcm_wlan_config_channel()
{
	if [ "$WlanChannel" = "0" ]; then
		bcm_wlan_auto_channel
	else
		wl channel $WlanChannel
	fi
}

bcm_wlan_config_n_channel()
{
	ht_cap=`cfg get wifi_11n_cap`
	
	wl mimo_bw_cap $ht_cap
	if [ "$WlanBand" = "a" ]; then
		wl sgi_tx -1
		wl sgi_rx 3
		bcm_wlan_auto_channel
		return 0
	fi
	if [ "$ht_cap" = "1" ]; then
		wl obss_coex 1
		wl sgi_tx -1
		wl sgi_rx 3
		if [ "$WlanChannel" = "0" ]; then
			bcm_wlan_auto_channel
			return 0
		fi
		if [ "$WlanChannel" -gt "0" ] && [ "$WlanChannel" -lt "7" ]; then
			wl chanspec ${WlanChannel}l
		elif [ "$WlanChannel" -gt "6" ] && [ "$WlanChannel" -lt "14" ]; then
			wl chanspec ${WlanChannel}u
		fi
	else
		wl obss_coex 0
		wl sgi_tx -1
		wl sgi_rx 3
		if [ "$WlanChannel" = "0" ]; then
			bcm_wlan_auto_channel
			return 0
		fi
		wl channel $WlanChannel
	fi
}
bcm_wlan_config_band_phymode()
{	
	if [ "$WlanBand" = "a" ]; then
		wl band a
	else
		wl band b
	fi	
	
	if [ "$WlanMode" = "0" ] && [ "$WlanBand" = "b" ]; then
		echo "config b mode"
		wl nmode 0
		wl gmode 0
		bcm_wlan_config_channel
	elif [ "$WlanMode" = "1" ] && [ "$WlanBand" = "b" ]; then
		echo "config g only mode"
		wl nmode 0
		wl gmode 2
		bcm_wlan_config_channel
	elif [ "$WlanMode" = "2" ] && [ "$WlanBand" = "b" ]; then
		echo "config bg mode"
		wl nmode 0
		wl gmode 1
		bcm_wlan_config_channel
	elif [ "$WlanMode" = "3" ]; then
		echo "config n only mode"
		wl nmode 1
		wl nreqd 1
		bcm_wlan_config_n_channel
	elif [ "$WlanMode" = "5" ] && [ "$WlanBand" = "a" ]; then
		wl nmode 0
		bcm_wlan_config_channel
	else
		echo "config abgnn auto mode"
		wl nmode 1
		wl nreqd 0
		bcm_wlan_config_n_channel
	fi
	
}
wait_interface()
{
	i=0
	interface="$1"
	ifconfig "$interface"
	while true
	do
	i=$(($i+1))
	if [ $? -neq 0 ]; then
		sleep 1
		ifconfig "$interface"
	else
		return
	fi
	if [ "$i" -eq 10 ]; then
		echo "wait 10 seconds for $interface to show up, timeout"
		return
	fi
	done
}
bcm_wlan_config_acl()
{
	interface=$1
	acl_mode=`cfg get ACL_mode`
	wl -i $interface mac none
	if [ "$acl_mode" -eq 0 ]; then
		wl -i $interface macmode 0
		return
	elif [ "$acl_mode" -eq 2 ]; then
		wl -i $interface macmode 1
		maclist=`cfg get wifi_mac_black_list`
	elif [ "$acl_mode" -eq 1 ]; then
		wl -i $interface macmode 2
		maclist=`cfg get wifi_mac_white_list`
	else
		wl -i $interface macmode 0
		return
	fi	
	wl -i $interface mac `echo $maclist | sed 's/;/ /g'`
}
bcm_wlan_config_security_main()
{
	interface=$1
	cmd="wl -i $interface"
	auth_mode=`cfg get AuthMode`
	encry_type=`cfg get EncrypType`
	if [ "NONE" = "$encry_type" ]; then
		$cmd auth 0
		$cmd wsec 0
	elif [ "WEP" = "$encry_type" ]; then
		if [ "SHARED" = "$auth_mode" ]; then
			$cmd auth 1
		else
			$cmd auth 0
		fi
		$cmd wsec 1
		$cmd wpa_auth 0
		$cmd sup_wpa 0
		key_id='cfg get DefaultKeyID'
		wep_key=`cfg get Key$(($key_id+1))Str1`
		$cmd addwep $key_id $wep_key
		$cmd primary_key $key_id
	elif [ "TKIP" = "$encry_type" ]; then		
		if [ "WPAPSK" = "$auth_mode" ]; then
			$cmd wpa_auth 4
		elif [ "WPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 128
		elif [ "WPAPSKWPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 132
		else
			$cmd wpa_auth 4
		fi
		$cmd wsec 2
		$cmd sup_wpa 1
		$cmd set_pmk `cfg get WPAPSK1`			
	elif [ "CCMP" = "$encry_type" ]; then
		if [ "WPAPSK" = "$auth_mode" ]; then
			$cmd wpa_auth 4
		elif [ "WPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 128
		elif [ "WPAPSKWPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 132
		else
			$cmd wpa_auth 128
		fi
		$cmd wsec 4
		$cmd sup_wpa 1
		$cmd set_pmk `cfg get WPAPSK1`
	else
		if [ "WPAPSK" = "$auth_mode" ]; then
			$cmd wpa_auth 4
		elif [ "WPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 128
		elif [ "WPAPSKWPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 132
		else
			$cmd wpa_auth 132
		fi
		$cmd wsec 6
		$cmd sup_wpa 1
		$cmd set_pmk `cfg get WPAPSK1`
	fi

}
bcm_wlan_config_security_sub()
{
	interface=$1
	cmd="wl -i $interface"
	auth_mode=`cfg get m_AuthMode`
	encry_type=`cfg get m_EncrypType`
	if [ "NONE" = "$encry_type" ]; then
		$cmd auth 0
		$cmd wsec 0
	elif [ "WEP" = "$encry_type" ]; then
		if [ "SHARED" = "$auth_mode" ]; then
			$cmd auth 1
		else
			$cmd auth 0
		fi
		$cmd wsec 1
		$cmd wpa_auth 0
		$cmd sup_wpa 0
		key_id=`cfg get m_DefaultKeyID`
		wep_key=`cfg get m_Key$(($key_id+1))Str1`
		$cmd addwep $key_id $wep_key
		$cmd primary_key $key_id
	elif [ "TKIP" = "$encry_type" ]; then		
		if [ "WPAPSK" = "$auth_mode" ]; then
			$cmd wpa_auth 4
		elif [ "WPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 128
		elif [ "WPAPSKWPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 132
		else
			$cmd wpa_auth 4
		fi
		$cmd wsec 2
		$cmd sup_wpa 1
		$cmd set_pmk `cfg get m_WPAPSK1`			
	elif [ "CCMP" = "$encry_type" ]; then
		if [ "WPAPSK" = "$auth_mode" ]; then
			$cmd wpa_auth 4
		elif [ "WPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 128
		elif [ "WPAPSKWPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 132
		else
			$cmd wpa_auth 128
		fi
		$cmd wsec 4
		$cmd sup_wpa 1
		$cmd set_pmk `cfg get m_WPAPSK1`
	else
		if [ "WPAPSK" = "$auth_mode" ]; then
			$cmd wpa_auth 4
		elif [ "WPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 128
		elif [ "WPAPSKWPA2PSK" = "$auth_mode" ]; then
			$cmd wpa_auth 132
		else
			$cmd wpa_auth 132
		fi
		$cmd wsec 6
		$cmd sup_wpa 1
		$cmd set_pmk `cfg get m_WPAPSK1`
	fi

}
#step 2 : send wlan parameter begin

wl ver
brctl delif br0 eth0
brctl delif br0 wl0.1
ifconfig eth0 up
ifconfig wl0.1 down

if [ "$WlanType" = "apsta" ]; then
	wl down
	
	wl ap 1
	wl apsta 1
	wl mbss 1
	wl mpc 0

	
	wl country `cfg get CountryCode`
	bcm_wlan_config_band_phymode
	wl bg_rate auto	
	wl bss -C 1 down
	wl ssid -C 1 "`cfg get SSID1`"
	wait_interface "wl0.1"
	wl -i wl0.1 closed `cfg get HideSSID`	
	wl -i wl0.1 ap_isolate `cfg get NoForwarding`
	wl -i wl0.1 maxassoc `cfg get MAX_Access_num`
	bcm_wlan_config_acl "wl0.1"
	bcm_wlan_config_security_main "wl0.1"	
	wl up
	wl bss -C 1 up	
	ifconfig wl0.1 hw ether `wl -i wl0.1 cur_etheraddr | cut -b 15-32`	
	
elif [ "$WlanType" = "ap" ]; then
	wl down
	wl ap 1
	wl apsta 0
	wl mbss 0
	wl mpc 0
	
	wl country `cfg get CountryCode`	
	bcm_wlan_config_band_phymode
	wl bss -C 0 down
	wl ssid -C 0 "`cfg get SSID1`"
	wl closed `cfg get HideSSID`
	
	wl ap_isolate `cfg get NoForwarding`
	wl maxassoc `cfg get MAX_Access_num`
	bcm_wlan_config_acl "eth0"		
	bcm_wlan_config_security_main "eth0"
	wl up
	wl bss -C 0 up
elif [ "$WlanType" = "apap" ]; then
	wl down
	wl ap 1
	wl apsta 0
	wl mbss 1
	wl mpc 0
	
	wl country `cfg get CountryCode`	
	bcm_wlan_config_band_phymode
	wl bss -C 0 down
	wl ssid -C 0 "`cfg get m_SSID1`"
	wl closed `cfg get m_HideSSID`	
	wl ap_isolate `cfg get m_NoForwarding`
	wl bss_maxassoc `cfg get m_MAX_Access_num`
	bcm_wlan_config_acl "eth0"		
	bcm_wlan_config_security_sub "eth0"
	
	wl bss -C 1 down
	wl ssid -C 1 "`cfg get SSID1`"
	wl closed `cfg get HideSSID`	
	wl ap_isolate `cfg get NoForwarding`
	wl bss_maxassoc `cfg get MAX_Access_num`
	bcm_wlan_config_acl "wl0.1"		
	bcm_wlan_config_security_main "wl0.1"
	wl up
	wl bss -C 1 up
	wl bss -C 0 up
	
	ifconfig wl0.1 hw ether `wl -i wl0.1 cur_etheraddr | cut -b 15-32`
	
fi
#step 2 : send wlan parameter   end

