#!/bin/sh
# Syslog mode control script by qianying

CACHE_DIR=/mnt/zte/cache
DEFAULT_SYSLOG_PATH_1=$CACHE_DIR/zte_log
DEFAULT_SYSLOG_PATH_2=/usr/zte_web/web/zte_log
ENMERGE_LEVEL=1
INFO_LEVEL=7
DEFAULT_SYSLOG_SIZE=1024

#Set syslog default location
if [ -d $CACHE_DIR ]
then
      if [ -d $DEFAULT_SYSLOG_PATH_1 ]
      then 
        path=$DEFAULT_SYSLOG_PATH_1
      else
        mkdir $DEFAULT_SYSLOG_PATH_1
        path=$DEFAULT_SYSLOG_PATH_1 
      fi
else
      path=$DEFAULT_SYSLOG_PATH_2
fi

#Set syslog default level
level=$ENMERGE_LEVEL

#Set syslog default size
size=$DEFAULT_SYSLOG_SIZE

para1=$1

if [ "$para1" = "-L" -o "$para1" = "-R" ]
then
  echo "Start syslog setting"
else
  echo "Comand usage:"
  echo "./zte_syslog.sh -L -o <Path> -l Level <Level> -s <Size>"
  echo "                -R <HostIP>"
  exit 1
fi

if [ "$para1" = "-L" ]
then
  shift 
  if [ $# = 0 ]
  then
     cfg set syslog_to_local=1
     cfg set syslog_path=$path
     cfg set syslog_level=$level
     cfg set syslog_size=$size
     cfg save
     killall -9 syslogd
     sleep 1
     syslogd -O $path/syslog  -l $level -s $size  
     exit 0
  fi
  
  while getopts "o:l:s:" arg
  do
     case $arg in
        o)
          if [ -d $OPTARG ]
          then   
             path=$OPTARG
          else
             echo "Wrong path=$OPTARG"
             exit 1   
          fi
          ;;
        l)
          if [ $OPTARG = $ENMERGE_LEVEL -o $OPTARG = $INFO_LEVEL ]
          then   
             echo $OPTARG 
             level=$OPTARG
          else
             echo "Wrong level=$OPTARG"
             exit 1   
          fi
          ;;   
        s)      
          if [ $OPTARG -gt 0 ]
          then
          #echo $OPTARG   
             size=$OPTARG
          else
             echo "Wrong size=$OPTARG"
             exit 1   
          fi
          ;;            
        *)
           echo $OPTARG 
           echo "Comand usage:"
           echo "./zte_syslog.sh -L -o <Path> -l Level <Level> -s <Size>"
          exit 1   
        esac
      
    done
    
    cfg set syslog_to_local=1
    cfg set syslog_path=$path
    cfg set syslog_level=$level
    cfg set syslog_size=$size
    cfg save 
 
    killall -9 syslogd
    sleep 1
    syslogd -O $path/syslog  -l $level -s $size 
    sleep 1
    exit 0    
fi

if [ "$para1" = "-R" ]
then
    echo "Start sylog remote setting"
    if [ $# = 1 ]
    then
        echo "Comand usage:"
        echo "./zte_syslog.sh -R <Hostip>"
        exit 1   
   fi
fi 
   
  hostip=$2
  echo "Enable remote syslog hostip=$hostip"
  
  cfg set syslog_to_local=0
  cfg set syslog_host_ip=$hostip
  cfg save
  
  killall -9 syslogd
  sleep 1
  syslogd -R $hostip 
  sleep 1
  exit 0
fi

 