#!/bin/sh
#=====================================================
#set_dns_resolv.sh
#create by hebin10099125 2012.05.15
#modify by zhangyuelong10100551
DNS_RESOLV_FILE="/mnt/zte/zte_conf/config/resolv.conf"
DNS_RESOLV_FILE_PPP="/mnt/zte/zte_conf/config/resolv.conf-ppp"
route_wifi_flag="/tmp/route_wifi.flag"
   
   
echo "" > $DNS_RESOLV_FILE_PPP

mtu_set=`cfg get mtu_config_set`
if [ -n "$mtu_set" ];then
  ifconfig ccmni0 mtu $mtu_set
fi


# ipv4 dns set
dnsmode=`cfg get dns_mode`
if [ "$dnsmode" = "auto" ] ; then
    echo "auto dnsmode"
    dns1=`cfg get prefer_dns_auto`
    if [ -n "$dns1" ];then
    	echo "nameserver" $dns1 >> $DNS_RESOLV_FILE_PPP
    fi
 
    dns2=`cfg get standby_dns_auto`
    if [ -n "$dns2" ];then
    	echo "nameserver" $dns2 >> $DNS_RESOLV_FILE_PPP
    fi
fi

if [ "$dnsmode" = "manual" ] ; then
    echo "manual dns mode"
    
    dns1=`cfg get prefer_dns_manual`
    if [ -n "$dns1" ];then
    	echo "nameserver" $dns1 >> $DNS_RESOLV_FILE_PPP
    fi
    
    dns2=`cfg get standby_dns_manual`
    if [ -n "$dns2" ];then
    	echo "nameserver" $dns2 >> $DNS_RESOLV_FILE_PPP
    fi
fi

# ipv4 ipaddr set
wan_ipaddr=`cfg get wan_ipaddr`
ifconfig ccmni0 $wan_ipaddr 
ifconfig ccmni0 up

#by cyj
echo 1 > /proc/sys/net/ipv4/ip_forward
iptables -t nat -D POSTROUTING 1
iptables -t nat -A POSTROUTING -o ccmni0 -j MASQUERADE
ip route del default
ip route del default
ip route del default
ip route add default dev ccmni0

#DNSMASQ_FILE="/usr/zte/zte_conf/config/dnsmasq.conf"
#echo "no-hosts" > $DNSMASQ_FILE
#echo "address=/m.home/192.168.0.1" >> $DNSMASQ_FILE
#echo "resolv-file="$DNS_RESOLV_FILE >> $DNSMASQ_FILE

#create char device:/dev/urandom for dnsmasq rand_init
#mknod /dev/urandom c 1 9
#killall -9 dnsmasq
#dnsmasq -C $DNSMASQ_FILE
#by cyj end

 # ipv6 dns set
ipv6_dns_mode=`cfg get ipv6_dns_mode`
echo "ipv6_dns_mode: $ipv6_dns_mode"
    
if [ "$ipv6_dns_mode" = "auto" ];then

	ipv6_prefer_dns_auto=`cfg get ipv6_prefer_dns_auto`
	ipv6_standby_dns_auto=`cfg get ipv6_standby_dns_auto`
				
		if [ -n "$ipv6_prefer_dns_auto" ]&& [ "$ipv6_prefer_dns_auto" != "::" ];then
			echo nameserver $ipv6_prefer_dns_auto >> $DNS_RESOLV_FILE_PPP
		fi
				
	if [ -n "$ipv6_standby_dns_auto" ] && [ "$ipv6_standby_dns_auto" != "::" ];then
		echo nameserver $ipv6_standby_dns_auto >> $DNS_RESOLV_FILE_PPP
	fi
	
elif [ "$ipv6_dns_mode" = "manual" ];then
    
	ipv6_prefer_dns_manual=`cfg get  ipv6_prefer_dns_manual`
	ipv6_standby_dns_manual=`cfg get ipv6_standby_dns_manual`
			
	if [ -n "$ipv6_prefer_dns_manual" ] && [ "$ipv6_prefer_dns_manual" != "::" ];then
		echo nameserver $ipv6_prefer_dns_manual >> $DNS_RESOLV_FILE_PPP
	fi
			
	if [ -n "$ipv6_standby_dns_manual" ] && [ "$ipv6_standby_dns_manual" != "::" ];then
		echo nameserver $ipv6_standby_dns_manual >> $DNS_RESOLV_FILE_PPP 
	fi
			
fi




# if route is on wifi, don't change resolv.conf
if [ -f $route_wifi_flag ]; then
  echo "Router is wifi"
else
  echo "Router is 3G/4G"
  cp -fr $DNS_RESOLV_FILE_PPP $DNS_RESOLV_FILE
fi
