
#by zhuhaiyan 20120712
export PATH="$PATH:/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin"
# check device
if [ "$1" = "" ]; then
    echo "device is null. exit 1."
    exit 1
fi

dev_str=`echo $1 | grep "tty"`
if [ "$dev_str" = "" ]; then
    echo "$1 is a invalid device! exit 1."
    exit 1
fi

dev_str=`ls /dev/tty* | grep "$1"`
if [ "$dev_str" = "" ]; then
    echo "$1 is not exist! exit 1."
    exit 1
fi

# check ppp0
ppp0_str=`ifconfig | grep "ppp0"`

if [ "$ppp0_str" != "" ]; then
    echo "ppp0 is exist! exit 0"
    exit 0
fi

# init comm port.
atinit /dev/ttyUSB0
atinit /dev/ttyUSB1
atinit /dev/ttyUSB2

# unlock device lock.
if [ -f /usr/bin/deviceunlock.sh ]; then
    /usr/bin/deviceunlock.sh $1
fi

tries=0
string_OK=""
while [ $tries -le 3 -a "$string_OK" = "" ]; do
#===================================do=================
#get all data from modem.
#`cat /dev/$1 > /tmp/cfun & sleep 1` 1>/dev/null 2>&1
#killall cat

#`cat /dev/$1 > /tmp/cfun & chat -V "" "AT+CFUN=1" < /dev/$1 > /dev/$1` 1>/dev/null 2>&1
#sleep 1
#killall cat

atcmd /dev/$1 "AT+CFUN=1" > /tmp/cfun

string_OK=`grep "OK" /tmp/cfun`

tries=$((tries + 1))
#=================================done=================
done

if [ "$string_OK" = "" ]; then
    echo fail to execute at+cfun=1
    exit 1
fi

echo successfull to trun on radio.

# read all data form device.
echo "clear rx buffer form /dev/$1..."
`cat /dev/$1 > /tmp/atrxbuff & sleep 3` 1>/dev/null 2>&1
killall cat

echo "check sim pin status..."

#check pin sim status.
#`cat /dev/$1 > /tmp/cpin & sleep 1` 1>/dev/null 2>&1
#killall cat
#`cat /dev/$1 > /tmp/cpin & chat -V "" "AT+CPIN?" < /dev/$1 > /dev/$1` 1>/dev/null 2>&1 
#sleep 1
#killall cat

atcmd /dev/$1 "AT+CPIN?" > /tmp/cpin

at_return=`grep "READY" /tmp/cpin`

if [ "$at_return" = "" ]; then
    echo "Invalid SIM card, please check sim pin status."
    exit 1
fi

echo "SIM is ready!!"

#for auto find apn and connect to internet.

#get apn profile

tries=0
string_plmn=""

while [ $tries -le 3 -a "$string_plmn" = "" ]; do
#============================do======================
echo get plmn by +bmhplmn tries=$tries
#get all data from modem.
#`cat /dev/$1 > /tmp/bmhplmn & sleep 1` 1>/dev/null 2>&1
#killall cat
#get PLMN
#`cat /dev/$1 > /tmp/bmhplmn & chat -V "" "AT+BMHPLMN" < /dev/$1 > /dev/$1` 1>/dev/null 2>&1
#sleep 1
#killall cat

# echo AT RETURN:
# cat /tmp/bmhplmn

atcmd /dev/$1 "AT+BMHPLMN" > /tmp/bmhplmn

at_return=`grep "+BMHPLMN:" /tmp/bmhplmn`
#by zhuhaiyan 20130402 --- get plmn
echo $at_return | awk '{print $2}' > /tmp/plmn

if [ "$at_return" != "" ]; then
    
    string_plmn=`echo $at_return | awk '{print $2}'`
    if [ "$string_plmn" = "" ]; then
        tries=$((tries + 1))
        continue
    fi
    
    string_plmn=`expr substr $string_plmn 1 5`
    break
fi

tries=$((tries + 1))
#==================================done==========
done

tries=0

while [ $tries -le 3 -a "$string_plmn" = "" ]; do
#=============================do=======================

if [ "$string_plmn" = "" ]; then
    echo get imsi by +cimi tries=$tries
    #get all data from modem.
    #`cat /dev/$1 > /tmp/cimi & sleep 1` 1>/dev/null 2>&1
    #killall cat

    #get cimi
    #`cat /dev/$1 > /tmp/cimi & chat -V "" "AT+CIMI" < /dev/$1 > /dev/$1` 1>/dev/null 2>&1
    #sleep 1
    #killall cat

    atcmd /dev/$1 "AT+CIMI" > /tmp/cimi

    echo AT RETURN:
    cat /tmp/cimi
    at_return=`grep "[0-9]" /tmp/cimi`

    if [ "$at_return" = "" ]; then
        echo invalid imsi. 
        tries=$((tries + 1))
        continue
    fi
    
    string_cimi=`echo $at_return | awk '{print $1}'`
    if [ "$string_cimi" = "" ]; then
        echo fail to get cimi.
        tries=$((tries + 1))
        continue
    fi
    
    #get 5 num for plmn form imsi.
    string_plmn=`expr substr $string_cimi 1 5`
    
fi
#=========================done===================
done

if [ "$string_plmn" = "" ]; then
    echo "fail to get PLMN."
    exit 1
fi

echo success to get PLMN=$string_plmn

echo "start to wait for register network..."

tries=0
string_RegHome=""
string_RegRoaming=""
string_Reg="0"

while [ $tries -le 45 -a "$string_Reg" = "0" ]; do
#===================================do=================
echo "wait for network registered...,tries=$tries"
#get all data from modem.
#`cat /dev/$1 > /tmp/cgatt & sleep 1` 1>/dev/null 2>&1
#killall cat

#`cat /dev/$1 > /tmp/cgatt & chat -V "" "AT+CREG?" < /dev/$1 > /dev/$1` 1>/dev/null 2>&1
#sleep 1
#killall cat

sleep 1
atcmd /dev/$1 "AT+CREG?" > /tmp/cgatt

string_RegHome=`grep ",1" /tmp/cgatt`
string_RegRoaming=`grep ",5" /tmp/cgatt`
if [ "$string_RegHome" != "" -o "$string_RegRoaming" != "" ]; then
    string_Reg="1"
fi

tries=$((tries + 1))
#=================================done=================
done

if [ "$string_Reg" = "0" ]; then
    echo "fail to register network, please check."
    exit 1
fi

echo "successfull to register network."

#by zhuhaiyan 20130402 -- get cellid and lac

tries=0
strlac=""
strcellid=""
stridok="0"

while [ $tries -le 10 -a "$stridok" = "0" ]; do
#==================================================
#`cat /dev/$1 > /tmp/creg & sleep 1` 1>/dev/null 2>&1
#killall cat

#`cat /dev/$1 > /tmp/creg & chat -V "" "AT+CREG=2" < /dev/$1 > /dev/$1` 1>/dev/null 2>&1
#sleep 1
#killall cat

atcmd /dev/$1 "AT+CREG=2" > /tmp/creg

#`cat /dev/$1 > /tmp/creg & chat -V "" "AT+CREG?" < /dev/$1 > /dev/$1` 1>/dev/null 2>&1
#sleep 1
#killall cat

atcmd /dev/$1 "AT+CREG?" > /tmp/creg

strlac=`grep "+CREG:" /tmp/creg | awk '{print $2}' | awk -F, '{print $3}'`
strcellid=`grep "+CREG:" /tmp/creg | awk '{print $2}' | awk -F, '{print $4}'`
 
if [ "$strlac" != "" -a "$strcellid" != "" ]; then
    stridok="1"
fi
tries=$((tries + 1))
#=====================done=========================
done

if [ "$stridok" = "1" ]; then
    echo $strlac > /tmp/lac
    echo $strcellid > /tmp/cellid
else
    echo "fail to geti lac and cell id."
    exit 1
fi

#`cat /dev/$1 > /tmp/creg & chat -V "" "AT+CREG=0" < /dev/$1 > /dev/$1` 1>/dev/null 2>&1
#sleep 1
#killall cat

atcmd /dev/$1 "AT+CREG=0" > /tmp/creg

#by zhuhaiyan 20130402 -- get imei
tries=0
strimei=""

while [ $tries -le 10 -a "$strimei" = "" ]; do
#========================================================
#`cat /dev/$1 > /tmp/cgsn & sleep 1` 1>/dev/null 2>&1
#killall cat

#`cat /dev/$1 > /tmp/cgsn & chat -V "" "AT+CGSN" < /dev/$1 > /dev/$1` 1>/dev/null 2>&1
#sleep 1
#killall cat

atcmd /dev/$1 "AT+CGSN" > /tmp/cgsn

strimei=`sed -n "2p" /tmp/cgsn`
if [ "$strimei" = "" ]; then
    strimei=`sed -n "3p" /tmp/cgsn`
fi
tries=$((tries + 1))
#==================done==================================
done

if [ "$strimei" != "" ]; then
    echo $strimei > /tmp/imei
else
    echo "fail to get imei."
    exit 1
fi

#by zhuhaiyan 20130402 -- get swver
#`cat /dev/$1 > /tmp/cgmr & chat -V "" "AT+CGMR" < /dev/$1 > /dev/$1` 1>/dev/null 2>&1
#sleep 1
#killall cat

#atcmd /dev/$1 "AT+CGMR" > /tmp/cgmr
#grep "+CGMR:" /tmp/cgmr | awk '{print $2}' > /tmp/swver

grep Version /etc/cm.version | awk -F= '{print $2}' > /tmp/swver
grep Model /etc/cm.version | awk -F= '{print $2}' > /tmp/model
grep HW /etc/cm.version | awk -F= '{print $2}' > /tmp/hw

#get apn profile
apn_profile=`grep $string_plmn /etc/3g_modem_connection/apn.dat`
echo get apn profile = $apn_profile
apn_dial=`echo $apn_profile | awk -F, '{ print $3 }'`
apn_user=`echo $apn_profile | awk -F, '{ print $4 }'`
apn_pass=`echo $apn_profile | awk -F, '{ print $5 }'`
apn_apn=`echo $apn_profile | awk -F, '{ print $6 }'`
apn_auth=`echo $apn_profile | awk -F, '{ print $7 }'`

echo apn_dial=$apn_dial
echo apn_user=$apn_user
echo apn_pass=$apn_pass
echo apn_apn=$apn_apn
echo apn_auth=$apn_auth

#make a chat script
cp /etc/3g_modem_connection/3g.template /etc/3g_modem_connection/3g
sed -i "s/__DIAL__/$apn_dial/g" /etc/3g_modem_connection/3g
if [ "$apn_apn" != "" ]; then
    sed -i "s/__APN__/$apn_apn/g" /etc/3g_modem_connection/3g
    sed -i "s/__NO_APN__/OK/g" /etc/3g_modem_connection/3g
else
    sed -i "s/__NO_APN__/#/g" /etc/3g_modem_connection/3g
fi

#ppp ipv4/v6
ppp_ipv4v6=`grep ppp_ipv4v6 /etc/device.conf | awk -F= '{print $2}'`
if [ "$ppp_ipv4v6" = "1" ]; then
    sed -i "s/\"IP\"/\"IPV4V6\"/g" /etc/3g_modem_connection/3g
fi


#make a pppd connection script.
cp /etc/ppp/peers/3g.template /etc/ppp/peers/3g
sed -i "s/__DEVICE__/$1/g" /etc/ppp/peers/3g
sed -i "s/__USER__/$apn_user/g" /etc/ppp/peers/3g
sed -i "s/__DIAL__/$apn_dial/g" /etc/ppp/peers/3g
sed -i "s/__APN__/$apn_apn/g" /etc/ppp/peers/3g
#make pap-secrets
cp /etc/ppp/pap-secrets.template /etc/ppp/pap-secrets
sed -i "s/__USER__/$apn_user/g" /etc/ppp/pap-secrets
sed -i "s/__PASSWORD__/$apn_pass/g" /etc/ppp/pap-secrets
#make chap-secrets
cp /etc/ppp/chap-secrets.template /etc/ppp/chap-secrets
sed -i "s/__USER__/$apn_user/g" /etc/ppp/chap-secrets
sed -i "s/__PASSWORD__/$apn_pass/g" /etc/ppp/chap-secrets

tries_pppd_call_3g=0
ppp0_str=""

while [ $tries_pppd_call_3g -le 3 -a "$ppp0_str" = "" ]; do 
#==========================================================
#connect to internet
pppd call 3g

tries=0
echo "pppd connecting...(timeout=120 seconds)"
ppp0_str=`ifconfig | grep "ppp0"`

while [ "$ppp0_str" = "" -a $tries -le 120 ]; do
    sleep 1
    echo "pppd connecting...,tries=$tries"
    ppp0_str=`ifconfig | grep "ppp0"`
    dev_str=`ls /dev/$1`
    if [ "$dev_str" = "" ]; then
        echo "$1 is missing. exit"
        killall pppd
        exit 0
    fi
    tries=$((tries + 1))
done

if [ "$ppp0_str" != "" ]; then
    #check OS
    #if [ "$(cat /etc/issue | grep Fedora)" != "" -o "$(cat /etc/issue | grep Mandriva)" != "" ]; then
        if [ -f /etc/resolv.conf ]; then
	      cp /etc/resolv.conf /etc/resolv.conf.bak 
	  fi
        #get DNS
	if [ "$(cat /etc/issue | grep Fedora)" != "" -o "$(cat /etc/issue | grep Mandriva)" != "" ]; then
            grep -rnw "DNS address" /var/log/messages > /tmp/dns
        else
            grep -rnw "DNS address" /var/log/syslog > /tmp/dns
        fi	
        lastline=`cat /tmp/dns | wc -l`
        dns2=$(sed -n "$lastline"p /tmp/dns | sed 's/.*DNS address //g')
        dns1=$(sed -n "`expr $lastline - 1`"p /tmp/dns | sed 's/.*DNS address //g')
        echo "get dns1=$dns1, dns2=$dns2"
        if [ "$dns1" != "" -a "$dns2" != "" ]; then
            echo "nameserver $dns1" > /etc/resolv.conf
            echo "nameserver $dns2" >> /etc/resolv.conf
        fi
    #fi
    
else
    killall pppd
    sleep 1
    modemtoatmode
    sleep 2
fi
#===========================done============================
tries_pppd_call_3g=$((tries_pppd_call_3g + 1))

done

if [ "$ppp0_str" = "" ]; then
    echo "pppd connection timeout! exit 1."
    killall -9 pppd
    exit 1
else
    echo "pppd is connected."
    
    #sales tracking
    if [ -f /usr/bin/salestracking.sh ]; then
        /usr/bin/salestracking.sh ttyUSB1 &
    fi
fi


#end

