var    g_otafeature = null;
var    g_ota_enable = null;
var    g_ota_activetype = null;
var    g_ota_autoactivenum = null;
var    g_ota_esnmeid_enable = null;
var    g_ota_esnmeid_type = null;
var    g_ota_mdn_enable = null;
var    g_ota_mdn_length = null;
var    g_ota_min_enable = null;
var    g_ota_min_length = null;
var    g_ota_sid_enable = null;
var    g_ota_sid_length = null;
var    g_ota_prl_enable = null;

var MARCO_ENABLE = 1;
var MARCO_DISABLE = 0;
var MARCO_ACTIVETYPE_MANUAL = 0;
var MARCO_ACTIVETYPE_AUTO = 1;
var MARCO_ACTIVETYPE_AUTOMANUAL = 2;
var MARCO_OTKSLTYPE_NOPASSWORD = 0;
var MARCO_OTKSLTYPE_OTKSL = 1;
var MARCO_OTKSLTYPE_MSL = 2;
var MARCO_OTKSLUNLOCK_OTKSL = 0;
var MARCO_OTKSLUNLOCK_MSL = 1;

var MARCO_ESNMEID_TYPE_DEC = 0;
var MARCO_ESNMEID_TYPE_HEX = 1;

var MARCO_OTA_AUTO_STATUS_INIT = 0;
var MARCO_OTA_AUTO_STATUS_STARTED = 1;
var MARCO_OTA_AUTO_STATUS_LOCK_UNLOCK = 2;
var MARCO_OTA_AUTO_STATUS_NAM_DOWNLOADED = 3;
var MARCO_OTA_AUTO_STATUS_MDN_DOWNLOADED = 4;
var MARCO_OTA_AUTO_STATUS_IMSI_DOWNLOADED = 5;
var MARCO_OTA_AUTO_STATUS_PRL_DOWNLOADED = 6;
var MARCO_OTA_AUTO_STATUS_SUCCESSFUL= 7;
var MARCO_OTA_AUTO_STATUS_COMPLETE= 8;
var MARCO_OTA_AUTO_STATUS_FAILURE= 9;

var PASSWORD_TYPE_OTKSL = 1;
var PASSWORD_TYPE_MDN = 2;
var PASSWORD_TYPE_MIN = 3;
var PASSWORD_TYPE_SID = 4;


var RELOAD_PAGE_DELAY = 600;

var OTA_INTERVAL = 3000;
var g_timerReboot = 1000;

var g_otaStatus = null;
var g_ota_otksl = null;
var g_deviceInfo = null;

var    g_ota_auto_status = -1;
var    g_ota_status_No = 0;
 

var g_dialog_show_flag = true;
var g_activate_status = false;

var g_submitData = {
    AutoActivate : '',
    Number : '',
    Mdn : '',
    Min : '',
    HomeSid : ''            
};


function reloadPage()
{
    setTimeout(function(){window.location.reload();},RELOAD_PAGE_DELAY);
}

function showRebootDialog() {
    showWaitingDialog(common_waiting, IDS_ota_info_successfully);
    setTimeout(startPing, 50000);
}

function setGatewayIP(){
    var request = {
        Control: 1
    };
    var DEFAULT_GATEWAY_IP = '';
     // get current settings gateway address
    getAjaxData('api/dhcp/settings', function($xml) {
        var ret = xml2object($xml);
        if ('response' == ret.type) {
            DEFAULT_GATEWAY_IP = ret.response.DhcpIPAddress;
        }
    }, {
        sync: true
    }
    );
    ping_setPingAddress(DEFAULT_GATEWAY_IP);
}

function ota_FailedDialog(){
    $('#wait_table').hide();
    $('#wait_table').remove();
    showConfirmDialog(ota_auto_info_failed,function(){gotoPageWithoutHistory(HOME_PAGE_URL);});    
}

function ota_SuccessDialog(){
    $('#wait_table').hide();
    $('#wait_table').remove();
    showRebootDialog();    
}


function ota_AutoStateDialog(){
    $('.ota_dialog').hide();
    if ($('#div_wrapper').size() < 1) 
    {
        $('.body_bg').before("<div id='div_wrapper'></div>");
    }
    reputPosition($('#ota_auto_state'), $('#div_wrapper'));
    $('.dialog_close_btn').bind('click', function(){
        $('#ota_auto_state,#div_wrapper').hide();
        reloadPage();
    });  
}

function ota_ShowStateAdd(ota_state_content,ota_state_number){
    ota_li_list = "<tr><td class='ota_list_content'><label for='ota_state" + ota_state_number + "'>" + ota_state_number +". " +ota_state_content + "</label></td></tr>";
    $('#ota_state_list').append(ota_li_list);

}

function ota_GetStatus(CurrentAutoStatus){
    var ota_auto_state = null;
    switch (CurrentAutoStatus)
    {
        //The content in log debug is just for test, it can be ignored.
        case MARCO_OTA_AUTO_STATUS_INIT:
        case MARCO_OTA_AUTO_STATUS_STARTED:
        case MARCO_OTA_AUTO_STATUS_LOCK_UNLOCK:
        case MARCO_OTA_AUTO_STATUS_NAM_DOWNLOADED:
        case MARCO_OTA_AUTO_STATUS_MDN_DOWNLOADED:
        case MARCO_OTA_AUTO_STATUS_IMSI_DOWNLOADED:
        case MARCO_OTA_AUTO_STATUS_PRL_DOWNLOADED:
             break;
        case MARCO_OTA_AUTO_STATUS_SUCCESSFUL:
             ota_auto_state = ota_auto_otasp_successful;
             setTimeout(ota_SuccessDialog,OTA_INTERVAL);
             break;
        case MARCO_OTA_AUTO_STATUS_COMPLETE:
            ota_auto_state = ota_auto_otasp_complete;
            setTimeout(ota_SuccessDialog,OTA_INTERVAL);
             break;
        case MARCO_OTA_AUTO_STATUS_FAILURE:
            ota_auto_state = ota_auto_otasp_failure;
            setTimeout(ota_FailedDialog,OTA_INTERVAL);
             break;
        default:
            setTimeout(ota_FailedDialog,OTA_INTERVAL);
            break;
    }
}

function ota_CheckStatus(){
    getAjaxData('api/ota/otamsg',
        function($xml) {
            var ota_ret = xml2object($xml);
            if (ota_ret.type == 'response')
            {
                g_otaStatus = ota_ret.response;
                var otaStatus = parseInt(g_otaStatus.Otamsg, 10);
                g_ota_auto_status = otaStatus;          
                ota_GetStatus(g_ota_auto_status);                                      
                  if(!(g_ota_auto_status == MARCO_OTA_AUTO_STATUS_FAILURE||g_ota_auto_status == MARCO_OTA_AUTO_STATUS_COMPLETE||g_ota_auto_status == MARCO_OTA_AUTO_STATUS_SUCCESSFUL))
                   {
                       setTimeout(ota_CheckStatus, OTA_INTERVAL);    
                   }
            }
        },
        {
            errorCB: function() {
                setTimeout(ota_checkStatus, OTA_INTERVAL);
            }
        }
    );     
}


function postData(active_type)
{
    setGatewayIP();
    g_submitData.AutoActivate = active_type;
    if(active_type == MARCO_ACTIVETYPE_AUTO){
        showWaitingDialog(common_ota,IDS_ota_auto_active_process);
    }
    var res = object2xml('request', g_submitData);
    saveAjaxData('api/ota/activate', res, function($xml) {
        var ota_ret = xml2object($xml);
        if(ota_ret.type == 'response')
        {
            if(isAjaxReturnOK(ota_ret))
            {
                if(active_type == MARCO_ACTIVETYPE_AUTO){
                    ota_CheckStatus();
                 }
                 else{
                     ota_SuccessDialog(); 
                }
            }
            else
            {
                ota_FailedDialog();
            }
        }
        else
        {
            ota_FailedDialog();
        }
    },
    {
         errorCB: function()
        {
            ota_FailedDialog();
            log.error('OTA: post api/ota/activate file failed');
        }
    });
}

function PasswordCheck(id_input,RegExpType,err_label,id_button)
{
    var input_val = $('#' + id_input).val();
    //var patrn = /^[0-9]{length_min,length_max}$/;
    var patrn = /^[0-9]{0,10}$/;    
    if(RegExpType == PASSWORD_TYPE_OTKSL){
        patrn = /^[0-9]{6,6}$/;    
    }
    else if(RegExpType == PASSWORD_TYPE_MDN){
        patrn = /^[0-9]{1,20}$/;    
    }
    else if(RegExpType == PASSWORD_TYPE_MIN){
        patrn = /^[0-9]{1,20}$/;    
    }
    else if(RegExpType == PASSWORD_TYPE_SID){
        patrn = /^[0-9]{1,20}$/;    
    }
    
    if (input_val == '' || input_val == ' ' || input_val == null)
    {
        showErrorUnderTextbox(id_input, err_label, 'input_wrong');
        $('#' + id_input).val('');
        $('#' + id_input).focus();
        button_enable(id_button, '0');
        return false;
    }
    else if (!patrn.exec(input_val))
    {
        showErrorUnderTextbox(id_input, err_label, 'input_wrong');
        $('#' + id_input).val('');
        $('#' + id_input).focus();
        button_enable(id_button, '0');
        return false;
    }
    else
    {
        button_enable(id_button, '1');
        return true;
    }    
}
function ota_bindButtonClick(){
    $('#auto_apply').click(function() {
        if (isButtonEnable('auto_apply'))
        {
            if(g_ota_enable == MARCO_ENABLE)
            {
                postData(MARCO_ACTIVETYPE_AUTO);
            }
        }
    });

    $('#ota_manual_otksl').click(function() {
        if (isButtonEnable('ota_manual_otksl'))
        {
            var validate = null;
            clearAllErrorLabel();
            if(MARCO_OTKSLTYPE_OTKSL == g_ota_otksl.OtkslStatus)
            {
                validate = PasswordCheck('input_otksl',PASSWORD_TYPE_OTKSL,IDS_ota_otksl_err_label,'ota_manual_otksl');
            }
            else if(MARCO_OTKSLTYPE_MSL == g_ota_otksl.OtkslStatus)
            {
                validate = PasswordCheck('input_msl',PASSWORD_TYPE_OTKSL,IDS_ota_msl_err_label,'ota_manual_otksl');
            }    
                    
            var unlockSubmitData = {
                Type : '',
                Password : ''
            };
            unlockSubmitData.Type = g_ota_otksl.OtkslStatus;
            if(validate)
            {
                if(MARCO_OTKSLTYPE_OTKSL == g_ota_otksl.OtkslStatus)
                {
                    unlockSubmitData.Type = MARCO_OTKSLUNLOCK_OTKSL;
                    
                    unlockSubmitData.Password = $('#input_otksl').val();
                }
                else if(MARCO_OTKSLTYPE_MSL == g_ota_otksl.OtkslStatus)
                {
                    unlockSubmitData.Type = MARCO_OTKSLUNLOCK_MSL;
                    unlockSubmitData.Password = $('#input_msl').val();
                }
                var xmlstr = object2xml('request', unlockSubmitData);
                saveAjaxData('api/ota/otksl', xmlstr, function($xml) {
                var ret = xml2object($xml);
                if (isAjaxReturnOK(ret))
                {
                    show_ota_info_page();
                }
                else
                {
                   showInfoDialog(ota_otksl_wrong);
                   show_ota_manual_page();      
                }
                });
            }
        }
    });

    $('#ota_manual_activate').click(function() {
        if (isButtonEnable('ota_manual_activate'))
        {
            g_submitData.Mdn = $('#input_mdn').val();
            g_submitData.Min = $('#input_min').val();
            g_submitData.HomeSid = $('#input_sid').val();
            clearAllErrorLabel();
            var mdn_value = g_ota_mdn_enable?PasswordCheck('input_mdn',PASSWORD_TYPE_MDN,IDS_ota_mdn_err_label,'ota_manual_activate'):true;
            var min_value = g_ota_min_enable?PasswordCheck('input_min',PASSWORD_TYPE_MIN,IDS_ota_min_err_label,'ota_manual_activate'):true;
            var sid_value = g_ota_sid_enable?PasswordCheck('input_sid',PASSWORD_TYPE_SID,IDS_ota_sid_err_label,'ota_manual_activate'):true;
            if(mdn_value && min_value && sid_value)
            {
                postData(MARCO_ACTIVETYPE_MANUAL);
            }
        }
    });
}

function show_ota_auto_page(){
    $('#ota_active_page').css('display', 'block');
    $('#ota_info_page').css('display', 'none');
	$('#ota_auto_note').show();
	$('#ota_manual_note').hide();
	$('#ota_esn').hide();
	$('#ota_otksl').hide();
	$('#ota_msl').hide();
	$('#ota_remainTimes').hide();
	$('#auto_apply').show();
	$('#ota_manual_otksl').hide();	
}

function show_ota_manual_page(){
    $('#ota_auto_note').hide();
    $('#ota_manual_note').show();
    $('#ota_esn').show();
    $('#esn_val').show();
    $('#auto_apply').hide();
    $('#ota_manual_otksl').show();	
    button_enable('ota_manual_otksl', '0');
    button_enable('ota_manual_activate', '0');  
	
    var ret = null;
    getAjaxData('api/ota/otksl', function($xml) {
    ret = xml2object($xml);    
    if (ret.type == 'response') {
        g_ota_otksl = ret.response;
        if(MARCO_OTKSLTYPE_NOPASSWORD == g_ota_otksl.OtkslStatus)
        {
            show_ota_info_page();
        }
        else if(MARCO_OTKSLTYPE_OTKSL == g_ota_otksl.OtkslStatus)
        {
            if(MARCO_DISABLE == g_ota_esnmeid_enable){
                $('#ota_esn').hide();
                $('#esn_val').hide();
            }
	        $('#ota_otksl').show();
	        $('#ota_msl').hide();
	        $('#ota_remainTimes').show();
            $('#input_otksl').val('');
            $('#input_otksl').focus();
        }
        else if(MARCO_OTKSLTYPE_MSL ==g_ota_otksl.OtkslStatus)
        {
            if(MARCO_DISABLE == g_ota_esnmeid_enable){
                $('#ota_esn').hide();
                $('#esn_val').hide();
            }
	        $('#ota_otksl').hide();
	        $('#ota_msl').show();
	        $('#ota_remainTimes').hide();
            $('#input_msl').val('');
            $('#input_msl').focus();
        }
        $('.remainingtime').html(ret.response.RetryTimes);                
    }
    }, {
        sync: true
    });    
}

function show_ota_info_page(){    

    if(MARCO_DISABLE == g_ota_mdn_enable){
        $('#ota_mdn').hide();
    }
    if(MARCO_DISABLE == g_ota_min_enable){
        $('#ota_min').hide();    
    }
    if(MARCO_DISABLE == g_ota_sid_enable){
        $('#ota_sid').hide();    
    }
    $('#input_mdn').val('');
    $('#input_min').val('');
    $('#input_sid').val('');    
    $('#ota_active_page').css('display', 'none');
    $('#ota_info_page').css('display', 'block');
}

function ota_bindSelectChange(){
    $('#ota_active_select').change(function() {
        if($('#ota_active_select').val() == MARCO_ACTIVETYPE_AUTO)
        {
            show_ota_auto_page();
        }
        else if($('#ota_active_select').val() == MARCO_ACTIVETYPE_MANUAL)
        {
            show_ota_manual_page();
        }
    });
}

function getOtaStatus(){
    var ret = null;
    getAjaxData('api/ota/status', function($xml) {
        ret = xml2object($xml);
        if (ret.type == 'response') {
            g_activate_status = ret.response.OtaStatus=='1'?true:false;
        }
    }, {
        sync: true
    });    
}

function getOtaConfig(){
    getConfigData('config/ota/config.xml', function($xml) {
        g_otafeature = _xml2feature($xml);
        g_ota_enable = g_otafeature.enable;
        g_ota_activetype = g_otafeature.activetype;
        g_ota_autoactivenum = g_otafeature.autoactivenum;
        g_ota_esnmeid_enable = g_otafeature.esnmeid.enable;
        g_ota_esnmeid_type = g_otafeature.esnmeid.type;
        g_ota_mdn_enable = g_otafeature.mdn.enable;
        g_ota_mdn_length = g_otafeature.mdn.length;
        g_ota_min_enable = g_otafeature.min.enable;
        g_ota_min_length = g_otafeature.min.length;
        g_ota_sid_enable = g_otafeature.sid.enable;
        g_ota_sid_length = g_otafeature.sid.length;
        g_ota_prl_enable = g_otafeature.prl;        
        g_submitData.Number = g_ota_autoactivenum;
    
	}, {
        sync: true
    });
}

function s16to10(SourceStr){
    var ResultArray = [];  
    var n16Array = new Array(1,6);
    var NumberArray = new Array(0,0);
    var nDigit = 0;
    var ResultStr = ''; 
    if(SourceStr.length>0)
    {
        var count = 0;
        for(count = 0;count<SourceStr.length;count++)
        {
            if(SourceStr.charCodeAt(count) >= 48 && SourceStr.charCodeAt(count) <= 57)
            {
                nDigit = SourceStr.charCodeAt(count) - 48;
            }
            else if(SourceStr.charCodeAt(count) >= 65 && SourceStr.charCodeAt(count) <= 70)
            {
                nDigit = SourceStr.charCodeAt(count)- 55;
	        }
	        else if(SourceStr.charCodeAt(count) >= 97 && SourceStr.charCodeAt(count) <= 102)
            {
                nDigit = SourceStr.charCodeAt(count) - 87;
	        }
	        else
	        {
	            nDigit = 0;   
            }
            ResultArray = BigDataMultiply(ResultArray,n16Array);
            NumberArray[0] = Math.floor(nDigit / 10);
            NumberArray[1] = nDigit % 10;
            ResultArray = BigDataAdd(ResultArray,NumberArray);
        }
    }
    else 
    {
       return 0;
    }
    if(ResultArray[0] == 0){
        ResultArray.shift();
    }
    var i = 0;
    for(i = 0;i<ResultArray.length;i++)
    {
       ResultStr += ResultArray[i].toString();
    }
    return ResultStr;
}

function BigDataMultiply(BigDataA,BigDataB)
{
    var ResultData = [];
    var i = 0;
    var j = 0;
    for(i=0;i<BigDataA.length+BigDataB.length;i++)
    {
        ResultData[i] =0;
    }  
    for(i=BigDataA.length;i>0;--i)
    {
        for(j=BigDataB.length;j>0;--j)
	    {
	        ResultData[BigDataA.length+BigDataB.length-i-j] += BigDataA[i-1]*BigDataB[j-1];
	    }
    }
    if(BigDataA.length>0&&BigDataB.length>0){
        for(i=0;i<BigDataA.length+BigDataB.length;i++)
        {
           ResultData[i+1] += Math.floor(ResultData[i]/10);
           ResultData[i] %= 10;   
        }
    }	
    if(ResultData.length>0)
    {
       for(i = 0;ResultData[i]<=9&&0<=ResultData[i];)
       {
           i++;
       }
       ResultData = ResultData.slice(0,i);
       for(i=0;ResultData[ResultData.length-1]==0;i++)
       {
           ResultData.pop();
       }
    }
    return  ResultData.reverse();
}

function BigDataAdd(BigDataA,BigDataB)
{
    var nCarry = 0;
    var nIndex = 0;
    var BigDataALength = BigDataA.length;
    var BigDataBLength = BigDataB.length;
    var ResultData = [];
    while((BigDataALength>0)&&(BigDataBLength>0))
    {
        ResultData[nIndex] = BigDataA[--BigDataALength] + BigDataB[--BigDataBLength] + nCarry;
        nCarry = Math.floor(ResultData[nIndex] / 10);
        ResultData[nIndex++] %= 10; 
    }
    while(BigDataALength-- > 0)
    {
        ResultData[nIndex] = BigDataA[BigDataALength] + nCarry;
        nCarry = Math.floor(ResultData[nIndex] / 10);
        ResultData[nIndex++] %= 10; 
    } 
    while(BigDataBLength-- > 0)
    {
        ResultData[nIndex] = BigDataB[BigDataBLength] + nCarry;
        nCarry = Math.floor(ResultData[nIndex] / 10);
        ResultData[nIndex++] %= 10; 
    } 
    if(nCarry>0)
    {
        ResultData[nIndex++] = nCarry; 
    }
    return  ResultData.reverse();
}
function initPage(){
    var ret = null;
    var esnValue= null;
    if(MARCO_ENABLE == g_ota_esnmeid_enable){
        getAjaxData('api/device/information', function($xml) {
            ret = xml2object($xml);
            if (ret.type == 'response') {
                esnValue = ret.response.Esn;
                if((esnValue.charAt(0) == '8') && (esnValue.charAt(1) == '0'))
                {
                    $("#ota_esnmeid_title").html("MEID" + common_colon);
                    if(MARCO_ESNMEID_TYPE_HEX == g_ota_esnmeid_type){
                        $('#esn_val').html(ret.response.Meid);            
                    }    
                    else{
                        $('#esn_val').html(s16to10(ret.response.Meid));            
                    }    
                }
                else
                {
                    $("#ota_esnmeid_title").html("ESN" + common_colon);
                    if(MARCO_ESNMEID_TYPE_HEX == g_ota_esnmeid_type){
                        $('#esn_val').html(ret.response.Esn);            
                    }    
                    else{
                        $('#esn_val').html(s16to10(ret.response.Esn));            
                    }    
                }
            }
        }, {
            sync: true
        });
    }
    if(MARCO_ACTIVETYPE_AUTO == g_ota_activetype){
        $('#ota_active_select').append("<option value='1' selected='selected'>" + common_auto + '</option>');
        show_ota_auto_page();
        
    }
    else if(MARCO_ACTIVETYPE_MANUAL == g_ota_activetype){
        $('#ota_active_select').append("<option value='0' selected='selected'>" + common_manual + '</option>'); 
        show_ota_manual_page();
    }
    else{
        $('#ota_active_select').append("<option value='1' selected='selected'>" + common_auto + '</option>');
        $('#ota_active_select').append("<option value='0'>" + common_manual + '</option>');
        show_ota_auto_page();
    }
    $('#input_mdn').attr('maxlength',g_ota_mdn_length);
    $('#input_min').attr('maxlength',g_ota_min_length);
    $('#input_sid').attr('maxlength',g_ota_sid_length);
}

function main_executeBeforeDocumentReady(){
    getOtaConfig();
    redirectOnCondition(null,'ota');
}

main_executeBeforeDocumentReady();
$(document).ready(function() {
    initPage();
    ota_bindButtonClick();
    ota_bindSelectChange();
    getOtaStatus();
    if(g_activate_status){
        showInfoDialog(ota_already_active);
    }
    
    $('#input_otksl,#input_msl').live('keyup change input paste cut keydown', function() {
        if(('undefined' != typeof($('#input_otksl').val()) && ($('#input_otksl').val()).length == 6) ||
            ('undefined' != typeof($('#input_msl').val()) && ($('#input_msl').val()).length == 6))
        {
            button_enable('ota_manual_otksl', '1');
        }
        else
        {
            button_enable('ota_manual_otksl', '0');
        }
    });
    
    $('#input_mdn,#input_min,#input_sid').live('keyup change input paste cut keydown', function() {
        var mdn_value = g_ota_mdn_enable?('undefined' != typeof($('#input_mdn').val()) && ($('#input_mdn').val()).length == g_ota_mdn_length):true;
        var min_value = g_ota_min_enable?('undefined' != typeof($('#input_min').val()) && ($('#input_min').val()).length == g_ota_min_length):true;
        var sid_value = g_ota_sid_enable?('undefined' != typeof($('#input_sid').val()) && ($('#input_sid').val()).length >= 1 && ($('#input_sid').val()).length <= g_ota_sid_length):true;
        if (mdn_value && min_value && sid_value)
        {
            button_enable('ota_manual_activate', '1');
        }
        else
        {
            button_enable('ota_manual_activate', '0');
        }
    });    
    button_enable('ota_manual_otksl', '0');
    button_enable('ota_manual_activate', '0');    
    button_enable('auto_apply', '1');
    $('#ota_active_select').attr('disabled', false);
    $('#input_otksl').attr('disabled', false);
    $('#input_msl').attr('disabled', false);
    $('#input_mdn').attr('disabled', false);
    $('#input_min').attr('disabled', false);
    $('#input_sid').attr('disabled', false);
});