var g_priority_wifi_ap_info_list = [];
var g_wifipriorityscanresult = [];
var WiFi_PRIORITY_NUM = 16;

var ap_priority_info = {
    WifiSsid : null,
    WifiSecMode : null,
    Preset : null,
    Index : null,
    Order : null
};

$(document).ready( function() {
    button_enable('wifi_priority_apply', '0');

    $('#wifi_priority_apply').click( function() {
        apply();
    });
    $('.wifidelete').live("click", function() {
        button_enable('wifi_priority_apply', '1');
        var string = $(this).parent().parent().attr("id");
        string = string.split("_");
        var Index = string[2];
        g_priority_wifi_ap_info_list.splice(Index,1);
        creatWifiPriorityList();
    });
    $('.wifiup').live("click", function() {
        button_enable('wifi_priority_apply', '1');
        var string = $(this).attr("id");
        string = string.split("_");
        var Index = string[2];
        Index = parseInt(Index, 10);
        change_list(Index,Index-1);
        creatWifiPriorityList();
    });
    $('.wifidown').live("click", function() {
        button_enable('wifi_priority_apply', '1');
        var string = $(this).attr("id");
        string = string.split("_");
        var Index = string[2];
        Index = parseInt(Index, 10);
        change_list(Index,Index+1);
        creatWifiPriorityList();
    });
    getWiFiPriorityAPinfo();
});
function change_list(obj,src) {
    var ap_priority_info_temp = {
        WifiSsid : null,
        WifiSecMode : null,
        Preset : null,
        Index : null,
        Order : null
    };

    ap_priority_info_temp = g_priority_wifi_ap_info_list[obj];
    g_priority_wifi_ap_info_list[obj] = g_priority_wifi_ap_info_list[src];
    g_priority_wifi_ap_info_list[src] = ap_priority_info_temp;
}

function apply() {
    if (!isButtonEnable('wifi_priority_apply')) {
        return;
    }
        var tempValue = g_priority_wifi_ap_info_list;
        for(var i=0; i<tempValue.length; i++){
            tempValue[i].WifiSsid = wifiSsidResolveCannotParseChar(tempValue[i].WifiSsid);
	}
    var postData = {
        SsidLists: {
                        sidList: tempValue
        }
    };

    var priority_xml = object2xml('request', postData);
    saveAjaxData('api/wlan/wifiprofile', priority_xml, function($xml) {
        var ret = xml2object($xml);
        if(isAjaxReturnOK(ret)) {
            button_enable('wifi_priority_apply', '0');
            showInfoDialog(common_success);
            log.debug('api/wlan/wifiprofile ok');
        } else {
            showInfoDialog(common_failed);
            log.debug('api/wlan/wifiprofile error');
        }
        getWiFiPriorityAPinfo();
    });
}

function getWiFiPriorityAPinfo() {
    getAjaxData("api/wlan/wifiprofile", function($xml) {
        var ret = xml2object($xml);
        if(ret.type == "response") {
            g_wifipriorityscanresult = ret.response.SsidLists.SsidList;
            $("#noavaiableap").remove();
            if($.isArray(g_wifipriorityscanresult) ||
            ((typeof (g_wifipriorityscanresult) != 'undefined') && g_wifipriorityscanresult != null && g_wifipriorityscanresult != '')) {
                setWiFiPriorityList();
            } else {
                $('.wifipriority_settings').after("<span id='noavaiableap'>" + IDS_wifi_message_priority_list_none + "</span>");
            }
        } else {
            g_wifipriorityscanresult = [];
            $('.wifipriority_settings').after("<span id='noavaiableap'>" + IDS_wifi_message_priority_list_none + "</span>");
            log.error("WiFi network: get api/wlan/profile-information data error");
        }
    });
}

function setWiFiPriorityList() {
    g_priority_wifi_ap_info_list = [];
    if($.isArray(g_wifipriorityscanresult)) {
        $.each(g_wifipriorityscanresult, function(i) {
            var ap_priority_info = {
                WifiSsid : g_wifipriorityscanresult[i].WifiSsid,
                WifiSecMode : g_wifipriorityscanresult[i].WifiSecMode,
                Preset : g_wifipriorityscanresult[i].Preset,
                Index : g_wifipriorityscanresult[i].Index,
                Order : g_wifipriorityscanresult[i].Order
            };
            g_priority_wifi_ap_info_list.push(ap_priority_info);
            creatWifiPriorityList();
        });
    } else {
        var ap_priority_info = {
            WifiSsid : g_wifipriorityscanresult.WifiSsid,
            WifiSecMode : g_wifipriorityscanresult.WifiSecMode,
            Preset : g_wifipriorityscanresult.Preset,
            Index : g_wifipriorityscanresult.Index,
            Order : g_wifipriorityscanresult.Order
        };
        g_priority_wifi_ap_info_list.push(ap_priority_info);
        creatWifiPriorityList();
    }
}

function creatWifiPriorityList() {
    var wifiTableHtml = "";
    var i = 0;

    for(i; i < g_priority_wifi_ap_info_list.length; i++) {
        g_priority_wifi_ap_info_list[i].Index = i +1;
        var wifiTrId = "wifi_ap_" + i;
        var wifiUp = "wifi_up_" + i;
        var wifiDown = "wifi_down_" + i;
        var wifiDelete = "wifi_delete" + i;
        var SecurityMode = g_priority_wifi_ap_info_list[i].WifiSecMode;
        wifiTableHtml += "<tr class='wifi_ap' id='" + wifiTrId + "'>";
        wifiTableHtml += "<td width='180'>";
        wifiTableHtml += "<div class='wifiName'><span>" + replaceSpaceOther(g_priority_wifi_ap_info_list[i].WifiSsid) + "</span></div>";
        wifiTableHtml += "<div>" + SecurityMode + "</div>";
        wifiTableHtml += "</td>";
        wifiTableHtml += "<td width='140'>";
        if(g_priority_wifi_ap_info_list[i].Preset != 1) {
            wifiTableHtml += "<label class = 'wifidelete'>";
            wifiTableHtml += create_button_html(common_delete, 'wifiDelete');
            wifiTableHtml += "</label>";
        }
        wifiTableHtml += "</td>";
        if(g_priority_wifi_ap_info_list[i].Preset != 1) {
            if(i<g_priority_wifi_ap_info_list.length-1) {
                if( !((i>0)&&(g_priority_wifi_ap_info_list[i-1].Preset != 1)) ) {
                    wifiTableHtml += "<td width='50'><div  class='wifidown' id='" + wifiDown + "'><img src='../res/wifi_down.gif'></div></td>";
                } else {
                    wifiTableHtml += "<td width='50'><div  class='wifidown' id='" + wifiDown + "'><img src='../res/wifi_down.gif'></div></td>";
                }
            }
            else{
                wifiTableHtml += "<td width='50'></td>";  
            }
            if((i>0)&&(g_priority_wifi_ap_info_list[i-1].Preset != 1)) {
                if( !(i<g_priority_wifi_ap_info_list.length-1) ) {
                    wifiTableHtml += "<td width='50'><div  class='wifiup'  id='" +  wifiUp + "' ><img src='../res/wifi_up.gif'></div></td>";
                } else {
                    wifiTableHtml += "<td width='50'><div  class='wifiup'  id='" +  wifiUp + "' ><img src='../res/wifi_up.gif'></div></td>";
                }
            }
            else{
                wifiTableHtml += "<td width='50'></td>";  
            }
        }
        else {
             wifiTableHtml += "<td width='50'></td><td width='50'></td>";
        }
        wifiTableHtml += "</tr>";
    }
    $('.wifipriority_settings').html(wifiTableHtml);
}
