var USSD_RETURN_RESULT = 2001;
var USSD_OUT_TIME = 2003;
var USSD_HAVE_USSD_DIALOG = 1;
var USSD_HAVE_NOT_USSD_DIALOG = 0;
var g_ussd_preconfig = '';
var g_ussd_postconfig = '';
var g_ussd_btnStr = '';
var g_ussd_currentFun = null;
var g_ussd_chargeLimitText = '*0123456789#';
var g_ussd_generalLimitText = '*0123456789#';
var g_ussd_generalCommandList = [];
var g_ussd_timeout = false;
var g_ussd_timer_maxDialog = null;
var balance_html = '';
var general_html = '';
var g_ussd_sms_number = '';
var g_ussd_send_type = '';
var g_ussd_status_timer = '';
//muilvalue
var g_ussd_muilvalue_timeout = '';
var MACRO_USSD_TIMER = 2 * 60 * 1000;
var g_ussd_timer_muilvale = null;
var g_ussd_dialogstatus_finished = true;

redirectOnCondition(null, 'ussd');
//get value g_ussd_preconfig&g_ussd_postconfig...
function ussd_initVar() {

    getConfigData('config/ussd/prepaidussd.xml', function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'config') {
            g_ussd_preconfig = ret.config.USSD;
        } else {
            log.error('USSD: get data configurations/prepaidussd.xml error');
        }
    }, {
        sync: true
    });


    getConfigData('config/ussd/postpaidussd.xml', function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'config') {
            g_ussd_postconfig = ret.config.USSD;
        } else {
            log.error('USSD: get data configurations/postpaidussd.xml error');
        }
    }, {
        sync: true
    });
}

ussd_initVar();



//fun inint_show list
function ussd_show_ActivateInternetService(value)
{
    $('.ussd_content > div').hide();
    $('#cur_ussd_type').text(ussd_label_ActivateInternetService_title);
    ussd_getDialogStatus();
    ussd_activateInternetService(value);
    $('#fun_activateInternetService').show();
}

function ussd_show_BalanceInquiry(value)
{
    $('.ussd_content > div').hide();
    $('#cur_ussd_type').text(ussd_label_BalanceInquiry_title);
    ussd_getDialogStatus();
    balance_html = '';
    $('#balance_inquiry_result').html(balance_html);
    ussd_balanceInquiry(value);
    $('#fun_balanceInquiry').show();
}

function ussd_show_Charge(value)
{
    $('.ussd_content > div').hide();
    $('#cur_ussd_type').text(ussd_label_Charge_title);
    ussd_getDialogStatus();
    ussd_charge(value);
    $('#fun_charge').show();
}

function ussd_show_General(value)
{
    $('.ussd_content > div').hide();
    $('#cur_ussd_type').text(ussd_label_Universal_title);
    ussd_getDialogStatus();
    general_html = '';
    $('#general_result_table').html(general_html);
    g_ussd_generalCommandList.length = 0;
    ussd_general(value);
    $('#fun_general').show();
    $('#general_command_select_input').focus();
}

//fun first page
function ussd_initShow() {

    switch (g_ussdLeftmenu[0])
    {
        case 'activate_internet_service':
            ussd_show_ActivateInternetService(g_ussd_preconfig.ActivateInternetService);
        break;
        case 'balanceInquiry':
            ussd_show_BalanceInquiry(g_ussd_preconfig.BalanceInquiry);
        break;
        case 'charge':
            ussd_show_Charge(g_ussd_preconfig.Charge);
        break;
        case 'general':
            ussd_show_General(g_ussd_preconfig.General);
        break;
        default:
        break;
    }
}

 //prepaid click
function ussd_initPreClick() {

   $('#pre_service_title').live('click', function() {
        $('#ussd_setting_menu li').removeClass('subClick');
        $('#pre_service_title').addClass('subClick');
        ussd_show_ActivateInternetService(g_ussd_preconfig.ActivateInternetService);
    });

    $('#pre_fun_balanceInquiry').live('click', function() {
        $('#ussd_setting_menu li').removeClass('subClick');
        $('#pre_fun_balanceInquiry').addClass('subClick');
        ussd_show_BalanceInquiry(g_ussd_preconfig.BalanceInquiry);
    });

    $('#pre_fun_charge').live('click', function() {
        $('#ussd_setting_menu li').removeClass('subClick');
        $('#pre_fun_charge').addClass('subClick');
        //show error info
        clearAllErrorLabel();
        ussd_show_Charge(g_ussd_preconfig.Charge);
    });

    $('#pre_fun_general').live('click', function() {
        $('#ussd_setting_menu li').removeClass('subClick');
        $('#pre_fun_general').addClass('subClick');

        //show error info
        clearAllErrorLabel();
        ussd_show_General(g_ussd_preconfig.General);
    });
}

//postpaid click
function ussd_initPostClick() {
    $('#post_service_title').live('click', function() {
        $('#ussd_setting_menu li').removeClass('subClick');
        $('#post_service_title').addClass('subClick');
        ussd_show_ActivateInternetService(g_ussd_postconfig.ActivateInternetService);
    });

    $('#post_fun_balanceInquiry').live('click', function() {
        $('#ussd_setting_menu li').removeClass('subClick');
        $('#post_fun_balanceInquiry').addClass('subClick');
        ussd_show_BalanceInquiry(g_ussd_postconfig.BalanceInquiry);
    });

    $('#post_fun_charge').live('click', function() {
        $('#ussd_setting_menu li').removeClass('subClick');
        $('#post_fun_charge').addClass('subClick');

        //show error info
        clearAllErrorLabel();
        ussd_show_Charge(g_ussd_postconfig.Charge);
    });

    $('#post_fun_general').live('click', function() {
        $('#ussd_setting_menu li').removeClass('subClick');
        $('#post_fun_general').addClass('subClick');

        //show error info
        clearAllErrorLabel();
        ussd_show_General(g_ussd_postconfig.General);
    });

}

//fun sms and multi global variable init
function ussd_sms_multi_init(value)
{
    if ('undefined' != typeof(value.Type)) {
        g_ussd_send_type = value.Type.toLocaleLowerCase();
        g_ussd_sms_number = value.Number;
    } else {
        g_ussd_send_type = '';
        g_ussd_sms_number = '';
    }
    if ('undefined' != typeof(value.timeout)) {
        g_ussd_muilvalue_timeout = value.timeout;
    }else {
        g_ussd_muilvalue_timeout = '0';
    }
}

// fun ActivateInternetService
function ussd_activateInternetService(value) {
    var config_list = [];
    if (value.Items) {
        if (value.Items.Item) {
            if ($.isArray(value.Items.Item)) {
                config_list = value.Items.Item;
            } else {
                config_list.push(value.Items.Item);
            }
        }
    }
    if (0 == config_list.length) {
        return;
    }

    ussd_sms_multi_init(value);
    $('#activate_internet_service_description').html(regURL(eval(value.Description)));
    var subTr = '';

    /*
     * create select
     */
    var selectHtml = '';
    selectHtml = "<select id='activate_internet_service_select'>";

    $.each(config_list, function(n, value) {
        selectHtml += "<option value='" + $.trim(value.Command) + "'>" + eval(value.Subject).replace('%d', '1') + '</option>';
    });
    selectHtml += '</select>';

    /*
     * create button
     */
    var btnHTML = '';
    btnHTML = create_button_html(eval(config_list[0].Action), 'ActivateInternetServiceBtn', 'ActivateInternetServiceBtn');

    subTr += "<tr><td height='36'><label>" + selectHtml + '<label></td>';
    subTr += '<td class=\"align_right\">' + btnHTML + '</td></tr>';

    $('#activate_internet_service table').html(subTr);

    /*
     * define button action
     */
    $('#ActivateInternetServiceBtn').bind('click', function() {
        ussd_sendCommand('ActivateInternetService',
        $('#activate_internet_service_select').val(),
        'CodeType');
    });
}

//fun BalanceInquiry
function ussd_balanceInquiry(value) {
    ussd_sms_multi_init(value);
    $('#balance_inquiry_title').text(eval(value.Title));
    $('#balance_inquiry_description').text(eval(value.Description));
    ussd_creatBtn('BalanceInquiry', $.trim(value.Command), value.Action, 'BalanceInquiry');
    $('#balance_inquiry_action').html(g_ussd_btnStr);
}

//fun Charge
function ussd_charge(value) {
    ussd_sms_multi_init(value);
    $('#charge_title').text(eval(value.Title));
    $('#charge_description').text(eval(value.Description));
    g_ussd_chargeLimitText = $.trim(value.LimitText);
    $('#charge_command').val(value.Command);
    ussd_creatBtn('Charge', $.trim(value.Command), value.Action, 'Charge');
    $('#charge_action').html(g_ussd_btnStr);
}


//fun General
function ussd_general(value) {
    ussd_sms_multi_init(value);
    $('#general_title').text(eval(value.Title));
    $('#general_description').text(eval(value.Description));
    g_ussd_generalLimitText = $.trim(value.LimitText);
    var config_list = [];
    if (value.Menu) {
        if (value.Menu.MenuItem) {
            if ($.isArray(value.Menu.MenuItem)) {
                config_list = value.Menu.MenuItem;
            } else {
                config_list.push(value.Menu.MenuItem);
            }
        }
    }
    $.each(config_list, function(n, subValue) {
        subValue.Command = $.trim(subValue.Command);//.substring(0,40);
        subValue.Name = $.trim(subValue.Name);
        if (subValue.Name.length == 0) {
            subValue.Name = subValue.Command;
        }
        g_ussd_generalCommandList.push([subValue.Command, subValue.Name]);

    });
    $('#general_command_select').createSelect({
        maxlength: 40,
        direction_up: true,
        onlyread: false,
        maxheight: 240
    });
    $('#general_command_select').createOptions(g_ussd_generalCommandList);

    //
    ussd_creatBtn('General', value.Command, value.Action, 'general_btn');
    $('#general_action').html(g_ussd_btnStr);
}

//
function ussd_creatBtn(funName, content, action, btnId) {
    g_ussd_btnStr = "<span class='button_wrapper' id='" + btnId + "' onclick = \"javascript:ussd_sendCommand('" + funName + "','" + content + "','CodeType');return false;\">";
    g_ussd_btnStr += "<span class='button_left'>";
    g_ussd_btnStr += "<span class='button_right'>";
    g_ussd_btnStr += "<span class='button_center'>" + eval(action) + '</span></span></span></span>';
}

function ussd_checkChargeCommand(Content) {
    var reg = null;
    if (g_ussd_chargeLimitText != '') {
    try {
            reg = new RegExp(g_ussd_chargeLimitText);
            if (reg.exec(Content) != Content) {
                showErrorUnderTextbox('charge_hint', ussd_label_hint_wrong_command);
                $('#charge_command').focus().select();
                $('.button_wrapper').removeClass('disable_btn');
                return false;
            }
    } catch (exception) {
        log.error(exception);
        showErrorUnderTextbox('charge_hint', ussd_label_hint_wrong_command);
        $('#charge_command').focus().select();
        $('.button_wrapper').removeClass('disable_btn');
        return false;
    }

    }
    return true;
}

function ussd_checkGeneralCommand(Content) {
    var reg = null;
    if (g_ussd_generalLimitText != '') {
        try {
        reg = new RegExp(g_ussd_generalLimitText);
        if (reg.exec(Content) != Content) {
            showErrorUnderTextbox('general_hint', ussd_label_hint_wrong_command);
            $('#general_command_select').select();
            $('.button_wrapper').removeClass('disable_btn');
            return false;
        }

        } catch (exception) {
            log.error(exception);
            showErrorUnderTextbox('general_hint', ussd_label_hint_wrong_command);
            $('#general_command_select').select();
            $('.button_wrapper').removeClass('disable_btn');
            return false;
        }
    }
    return true;
}
//
function resolveXMLEntityReference(xmlStr)
{
    return xmlStr.replace(/(\<|\>|\&|\'|\")/g,
                          function($0, $1)
                          {
                              return{
                                  '<' : '&lt;'
                                , '>' : '&gt;'
                                , '&' : '&amp;'
                                , "'" : '&#39;'
                                , '\"': '&quot;'
                              }[$1];
                          }
                         );
}

Date.prototype.Format = function(format) {
    var o = {
        'M+' : this.getMonth() + 1,
        'd+' : this.getDate(),
        'h+' : this.getHours(),
        'm+' : this.getMinutes(),
        's+' : this.getSeconds()
    };
    var k;
    if (/(y+)/.test(format)) {
        format = format.replace(RegExp.$1, (this.getFullYear() + '').substr(4 - RegExp.$1.length));
    }

    for (k in o) {
        if (new RegExp('(' + k + ')').test(format)) {
            format = format.replace(RegExp.$1, RegExp.$1.length == 1 ? o[k] : ('00' + o[k]).substr(('' + o[k]).length));
        }
    }
    return format;
};

//send Common by sms
function sendCommonBySms(Content, CodeType) {
    clearInterval(g_ussd_status_timer);
    var messageContent = resolveXMLEntityReference(Content);
    var now = new Date().Format('yyyy-MM-dd hh:mm:ss');
    var scaValue = '';
    var submitXmlObject = {
        Index: -1,
        Phones: {
            Phone: g_ussd_sms_number
        },
        Sca: scaValue,
        Content: messageContent,
        Length: messageContent.length,
        Reserved: 0,
        Date: now,
        SendType: 1
    };

    var submitData = object2xml('request', submitXmlObject);

    saveAjaxData('api/sms/send-sms', submitData);
    showInfoDialog(ussd_info_dialog_to_sms);
    g_ussd_status_timer = setInterval(function() {
        ussd_getDialogStatus();
    },g_feature.update_interval);
}

function ussdDialogStatusFinished() {
    closeWaitingDialog();
    g_ussd_currentFun = null;
    g_ussd_dialogstatus_finished = true;
}

function ussdTimeOutByGetResult() {
    g_ussd_timeout = false;
    g_ussd_timer_maxDialog = setTimeout(function() {
        g_ussd_timeout = true;
        ussdDialogStatusFinished();
        showInfoDialog(common_timeout);
        ussd_releaseUssdDialog();
    }, MACRO_USSD_TIMER);
}

//send Common by ussd
function sendCommonByUssd(Content, CodeType) {
    //
    if ('0' == g_ussd_muilvalue_timeout) {
        g_ussd_muilvalue_timeout = '';
    }
    var send = {
        content: Content,
        codeType: CodeType,
        timeout: g_ussd_muilvalue_timeout
    };
    var ussdSend = object2xml('request', send);
    showWaitingDialog(common_waiting, IDS_ussd_label_wait_response);
    g_ussd_dialogstatus_finished = false;
    $('#wait_dialog_btn').show().bind('click', function() {
        g_ussd_timeout = true;
        clearTimeout(g_ussd_timer_maxDialog);
        clearTimeout(g_ussd_timer_muilvale);
        ussd_releaseUssdDialog();
        g_ussd_dialogstatus_finished = true;
        g_ussd_currentFun = null;
    });
    saveAjaxData('api/ussd/send', ussdSend, function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            if (isAjaxReturnOK(ret)) {
                //
                g_ussd_muilvalue_timeout = parseInt(g_ussd_muilvalue_timeout, 10);
                if (g_ussd_muilvalue_timeout > 0) {
                    g_ussd_timer_muilvale = setTimeout(function() {
                        ussdTimeOutByGetResult();
                        ussd_getResult();
                    }, g_ussd_muilvalue_timeout * 1000);
                } else {
                    ussdTimeOutByGetResult();
                    ussd_getResult();
                }
                startLogoutTimer();
            } else {
                sendCommandFailed();
            }
        } else if (ret.error.code == '111022') {//network nonsupport
            closeWaitingDialog();
            g_ussd_dialogstatus_finished = true;
            showInfoDialog(IDS_security_pin_code_management);
        } else  //failed
        {
            sendCommandFailed();
        }
    }, {
        errorCB: function(XMLHttpRequest, textStatus) {
            sendCommandFailed();
        }
    });
    //
    function sendCommandFailed() {
        ussdDialogStatusFinished();
        $('.button_wrapper').removeClass('disable_btn');
        showInfoDialog(common_failed);
        startLogoutTimer();
    }

}

//
function ussd_sendCommand(funName, Content, CodeType) {
    if ($('.button_wrapper').hasClass('disable_btn')) {
        return;
    } else {
        $('.button_wrapper').removeClass('disable_btn').addClass('disable_btn');
    }
    cancelLogoutTimer();
    clearAllErrorLabel();
    var checkContent = 0;
    switch (funName) {
        case 'Charge':
            Content = $.trim($('#charge_command').val());
            checkContent = Content;
            Content = Content.replace(/[\[\]]/g, '');
            if (Content == null || Content == '') {
                showErrorUnderTextbox('charge_hint', ussd_label_hint_wrong_command);
                $('#charge_command').focus().select();
                $('.button_wrapper').removeClass('disable_btn');
                return;
            } else {
                if (false == ussd_checkChargeCommand(Content)) {
                    return;
                }
            }
            break;
        case 'General':
            Content = $.trim($('#general_command_select').sVal());
            checkContent = Content;
            //
            if (Content == null || Content == '') {
                showErrorUnderTextbox('general_hint', ussd_label_hint_wrong_command);
                $('#general_command_select').select();
                $('.button_wrapper').removeClass('disable_btn');
                return;
            } else {
                if (false == ussd_checkGeneralCommand(Content)) {
                    return;
                }
            }
            g_ussd_currentFun = funName;
            Content = resolveXMLEntityReference(Content);
            $('#general_command_select').sVal(null);
            general_html += "<tr><td class='general_status'>" + common_sent + common_colon;
            general_html += "</td><td><div class='general_content'>" + Content + '</div></td></tr>';
            $('#general_result_table').html(general_html);
            var lastTrH = $('#general_result_table tr:last').height();
            var tableH = $('#general_result_table').height();
            $('#general_result').scrollTop(tableH - lastTrH);
            break;
        case 'BalanceInquiry':
            g_ussd_currentFun = funName;
            break;
        default:
            break;
    }
    if (40 < checkContent.length) {
        showInfoDialog(IDS_ussd_label_illegal_command_hint);
        return;
    }
    if ('sms' == g_ussd_send_type) {
        sendCommonBySms(Content, CodeType);
    } else {
        sendCommonByUssd(Content, CodeType);
    }
}

//
function ussd_getResult() {
    if (g_ussd_timeout == true) {
        return;
    }
    //
    getAjaxData('api/ussd/get', function($xml) {
        if (g_ussd_timeout == true) {
            return;
        }
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            ret = $.trim(ret.response.content);
            ret = ret.replace(/[\n|\r]/g, '<br/>');
            if (ret.length == 0) {
                ret = common_failed;
            }
            switch (g_ussd_currentFun) {
                case 'General':
                    var lastTrH = $('#general_result_table tr:last').height();

                    general_html += "<tr class='general_result'><td class='general_status'>";
                    general_html += dialup_label_received + common_colon + "</td><td><pre class='general_content'>";
                    general_html += ret + '</pre></td></tr>';
                    $('#general_result_table').html(general_html);

                    var tableH = $('#general_result_table').height();
                    lastTrH += $('#general_result_table tr:last').height();
                    $('#general_result').scrollTop(tableH - lastTrH);
                    break;
                case 'BalanceInquiry':
                    balance_html = "<pre class = 'ussd_info_result'>" + ret + '</pre>';
                    $('#balance_inquiry_result').html(balance_html);
                    break;
                default :
                    var infoDialog = '<pre>' + ret + '</pre>';
                    clearTimeout(g_ussd_timer_maxDialog);
                    ussdDialogStatusFinished();
                    showInfoDialog(infoDialog);
                    return;
            }
            //
            clearTimeout(g_ussd_timer_maxDialog);
            ussdDialogStatusFinished();
        } else {
            if (ret.error.code == '111019') {//no response from network
                setTimeout(ussd_getResult, g_feature.update_interval);
            } else if (ret.error.code == '111020') {//network timeout error
                clearTimeout(g_ussd_timer_maxDialog);
                ussdDialogStatusFinished();
                ussd_releaseUssdDialog();
                showInfoDialog(common_timeout);
            } else {
                clearTimeout(g_ussd_timer_maxDialog);
                ussdDialogStatusFinished();
                showInfoDialog(common_failed);
                log.error('USSD:get api/ussd/get data error');
            }
        }

    }, {
        errorCB: function() {
            clearTimeout(g_ussd_timer_maxDialog);
            ussdDialogStatusFinished();
            showInfoDialog(common_failed);
            log.error('USSD:get api/ussd/get file failed');
        }
    });
}

// to check if there is ussd dialog
function ussd_getDialogStatus(haveDialogFun, noDialogFun) {
    getAjaxData('api/ussd/status', function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            if (ret.response.result == USSD_HAVE_USSD_DIALOG) {
                if (false == g_ussd_dialogstatus_finished) {
                    $('.button_wrapper').removeClass('disable_btn').addClass('disable_btn');
                }
                if (typeof(haveDialogFun) == 'function') {
                    haveDialogFun();
                }

            } else {
                if (true == g_ussd_dialogstatus_finished) {
                    $('.button_wrapper').removeClass('disable_btn');
                }
                if (typeof(noDialogFun) == 'function') {
                    noDialogFun();
                }
            }
        }
    });
}

//release USSD dialog   (api/ussd/release)
function ussd_releaseUssdDialog() {
    getAjaxData('api/ussd/release', function($xml) {
        var ret = xml2object($xml);
        if (isAjaxReturnOK(ret)) {
        g_ussd_currentFun = null;
            $('.button_wrapper').removeClass('disable_btn');
        } else {
            //showInfoDialog(common_failed);
            log.debug('USSD:<release> not return response');
        }
    }, {
        //sync:true,
        errorCB: function() {
            log.debug('USSD:<release> file is not find');
        }
    });
}

$(document).ready(function() {

    ussd_initPreClick();
    ussd_initPostClick();

    ussd_initShow();

    ussd_releaseUssdDialog();
    g_ussd_status_timer = setInterval(function() {
        ussd_getDialogStatus();
    },g_feature.update_interval);
    startLogoutTimer();
});
