<html>
<head>
<title><% asp_get("pageTitle"); %></title>
<link href="../style/webgui.css" rel="stylesheet" type="text/css">
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<link href="../style/dialog.css" rel="stylesheet" type="text/css" media="screen">
<script language="JavaScript" src="../js/jquery-1.6.2.min.js"></script>
<script type="text/javascript" src="../js/dialog.js"></script>   
<script language="JavaScript" src="../js/prompt.js"></script>
<script language="JavaScript" src="../js/overlib.js"></script>
<script language="JavaScript" src="../js/validate.js"></script>
<script language="JavaScript" src="../js/lang.js"></script>
<script language="JavaScript" src="../js/protect.js"></script>
<script language="JavaScript" type="text/javascript">
Butterlate.setTextDomain("router");
/*
var lan_ipaddr = ' asp_get("lan_ipaddr"); %>';
var lan_netmask = ' asp_get("lan_netmask"); %>';
var lanMac = ' asp_get("mac_address"); %>';
var dhcpStart = ' asp_get("dhcpStart"); %>';
var dhcpEnd = ' asp_get("dhcpEnd"); %>';
var dhcpLease_hour = ' asp_get("dhcpLease_hour"); %>';
*/
var dhcpType = '<% asp_get("dhcpEnabled"); %>';
var pppstate = '<% asp_get("ppp_status"); %>';

var secs;
var timerID = null;
var timerRunning = false;
function StartTheTimer()
{
	if (secs==0)
	{
		TimeoutReload(5);
		window.location.href=window.location.href;
    }
	else
	{
        self.status = secs;
        secs = secs - 1;
        timerRunning = true;
        timerID = self.setTimeout("StartTheTimer()", 1000);
    }
}

function TimeoutReload(timeout)
{
	secs = timeout;
	if(timerRunning)
	{
		clearTimeout(timerID);
	}
	timerRunning = false;
	StartTheTimer();	
}

function dhcpTypeSwitch()
{
	if (document.lanCfg.lanDhcpType.options.selectedIndex == 1)
	{
		document.getElementById("tb_dhcp").style.display = "";
		document.lanCfg.dhcpStart.disabled = false;
		document.lanCfg.dhcpEnd.disabled = false;
		document.lanCfg.dhcpLease.disabled = false;
	}
	else
	{
		document.getElementById("tb_dhcp").style.display = "none";
		document.lanCfg.dhcpStart.disabled = true;
		document.lanCfg.dhcpEnd.disabled = true;
		document.getElementById("dhcpLease").disabled = true;
	}
}

function initTranslation()
{
	var e;// = document.getElementById("RouterLanTitle");
	//e.innerHTML = Get_string("Router Lan Title");

	//e = document.getElementById("adv_sec_title_status");
	//e.innerHTML = Get_string('adv sec title status');
	
	//e = document.getElementById("adv_sec_title_statistics");
	//e.innerHTML = Get_string('adv statistics title statistics');
	
	//e = document.getElementById("adv_sec_title_restore");
	//e.innerHTML = Get_string('adv sec title restore');
	
	//e = document.getElementById("adv_sec_title_pin_manage");
	//e.innerHTML = Get_string('adv sec title pin manage');
	
	//e = document.getElementById("adv_sec_title_router");
	//e.innerHTML = Get_string('adv_sec_title_router');
	
	e = document.getElementById("RouterLanSubTitle");
	e.innerHTML = Get_string("Router Lan Sub Title");
	
	e = document.getElementById("RouterLanIPAddress");
	e.innerHTML = Get_string("Router Lan IP Address");
	
	e = document.getElementById("RouterLanSubnetMask");
	e.innerHTML = Get_string("Router Lan Subnet Mask");
	
	e = document.getElementById("RouterLanMACAddress");
	e.innerHTML = Get_string("Router Lan MAC Address");

	e = document.getElementById("RouterLanDHCPType");
	e.innerHTML = Get_string("Router Lan DHCP Type");
	
	e = document.getElementById("RouterLanDHCPTypeDisable");
	e.innerHTML = Get_string("Router Lan DHCP Type Disable");
	
	e = document.getElementById("RouterLanDHCPTypeServer");
	e.innerHTML = Get_string("Router Lan DHCP Type Server");
	
	e = document.getElementById("RouterLanDHCPIpPool");
	e.innerHTML = Get_string("Router Lan DHCP IP Pool");
	
	e = document.getElementById("RouterLanDHCPLease");
	e.innerHTML = Get_string("Router Lan DHCP Lease");
	
	e = document.getElementById("RouterLanDHCPLeaseUnit");
	e.innerHTML = Get_string("Router Lan DHCP Lease Unit");
	
	e = document.getElementById("DHCP_Apply_Notice");
	e.innerHTML = Get_string("Router Lan DHCP Notice");
	
	e = document.getElementById("RouterLanApply");
	e.value = Get_string("Router Lan Apply");
	
	e = document.getElementById("RouterLanCancel");
	e.value = Get_string("Router Lan Cancel");	
}

function initValue()
{
	document.lanCfg.lanDhcpType.options.selectedIndex = 1*dhcpType;
	dhcpTypeSwitch();
	/*
	document.getElementById("lanIp").value = lan_ipaddr;
	document.getElementById("lanNetmask").value = lan_netmask;
	document.getElementById("lanMacAddress").innerHTML = lanMac.toUpperCase() + "&nbsp;";
	document.getElementById("dhcpStart").value = dhcpStart;
	document.getElementById("dhcpEnd").value = dhcpEnd;
	document.getElementById("dhcpLease").value = dhcpLease_hour;
	*/
}

var alertbox;
function initPage()
{
	if (pppstate == "ppp_connecting")
	{
		 alertbox = new dialog("","iframe:/air_network/pppconnecting.asp","300px","300px","iframe");		 
	}
	else if (pppstate == "ppp_disconnecting")
	{
		alertbox = new dialog("","iframe:/air_network/pppdisconnecting.asp","300px","300px","iframe");	
	}

	initTranslation();
	initValue();

	if (pppstate == "ppp_connected")
	{
	    document.lanCfg.lanIp.disabled = true;
		document.lanCfg.lanNetmask.disabled = true;
		if(document.lanCfg.lanDhcpType.options.selectedIndex == 1)
		{
		    document.lanCfg.dhcpStart.disabled = true;		
		    document.lanCfg.dhcpEnd.disabled = true;
			document.lanCfg.dhcpLease.disabled = true;
		}		
		document.lanCfg.lanDhcpType.disabled = true;
		document.getElementById('RouterLanApply').disabled = true;	
	}
	else
	{
		document.lanCfg.lanIp.disabled = false;
		document.lanCfg.lanNetmask.disabled = false;
		if(document.lanCfg.lanDhcpType.options.selectedIndex == 1)
		{
		    document.lanCfg.dhcpStart.disabled = false;		
		    document.lanCfg.dhcpEnd.disabled = false;
			document.lanCfg.dhcpLease.disabled = false;
		}		
		document.lanCfg.lanDhcpType.disabled = false;
		document.getElementById('RouterLanApply').disabled = false;	
	}

}

function atoi(str, num)
{
	i = 1;
	if (num != 1) {
		while (i != num && str.length != 0) {
			if (str.charAt(0) == '.') {
				i++;
			}
			str = str.substring(1);
		}
		if (i != num)
			return -1;
	}

	for (i=0; i<str.length; i++) {
		if (str.charAt(i) == '.') {
			str = str.substring(0, i);
			break;
		}
	}
	
	if (str.length == 0)
		return -1;
	if(('0' == str.charAt(0)) && (1 != str.length))
	    return -1;
	 	
	return parseInt(str, 10);
}

function checkRange(str, num, min, max)
{
	d = atoi(str, num);
	if (d > max || d < min)
		return false;
	return true;
}

function isAllNum(str)
{
	for (var i=0; i<str.length; i++) {
		if ((str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) == '.' ))
			continue;
		return 0;
	}
	return 1;
}

function checkIpAddr(field, ismask)
{
	if (field.value == "") {
		ShowError(field, "Router Lan IP Empty");
		//field.value = field.defaultValue;
		field.focus();
		return false;
	}

	if (isAllNum(field.value) == 0) {
		ShowError(field, 'Router Lan IP Format Error');
		//field.value = field.defaultValue;
		field.focus();
		return false;
	}

	if (ismask) {
		if ((!checkRange(field.value, 1, 0, 256)) ||
				(!checkRange(field.value, 2, 0, 256)) ||
				(!checkRange(field.value, 3, 0, 256)) ||
				(!checkRange(field.value, 4, 0, 256)))
		{
			ShowError(field, 'Router Lan IP Format Error');
			//field.value = field.defaultValue;
			field.focus();
			return false;
		}
	}
	else {
		var fields = field.value.split('.');   
		if ((!checkRange(field.value, 1, 1, 223))  ||
			(checkRange(field.value, 1, 127, 127)) ||
			(!checkRange(field.value, 2, 0, 255))  ||
			(!checkRange(field.value, 3, 0, 255))  ||
			(!checkRange(field.value, 4, 1, 254))  ||
			(fields.length != 4))     
		{
			ShowError(field, 'Router Lan IP Format Error');
			//field.value = field.defaultValue;
			field.focus();
			return false;
		}
	}
	return true;
}
function hex(val)
{
	var h = (val-0).toString(16);
	if(h.length==1) h='0'+h;
	return h.toUpperCase();
}
function Op_AND_4Byte(v1, v2) {
	var i;
	var var1 = new Array();
	var var2 = new Array();
	var result='0x';

	for (i=2,j=0;i<10;i+=2,j++) {
		var1[j]='0x'+v1.substring(i,i+2);
		var2[j]='0x'+v2.substring(i,i+2);
	}
	
	for (i=0;i<4;i++) {
		result = result + hex(var1[i]&var2[i]);
	}
	
	result = result-0;
	return result;
}
function validateGateway(wanIp,netmaskIp,gatewayIp) {

	var i1,i2,i3, wip, nip, gip;
	var lan4, mask4, pool4, net_no, lo_broadcast;

	i1=wanIp.indexOf('.');
	i2=wanIp.indexOf('.',(i1+1));
	i3=wanIp.indexOf('.',(i2+1));
	wip = hex(wanIp.substring(0,i1)) + hex(wanIp.substring((i1+1),i2)) +hex(wanIp.substring((i2+1),i3))+hex(wanIp.substring((i3+1),wanIp.length));
	wip = '0x'+wip;
	lan4 = wanIp.substring((i3+1),wanIp.length)-0;

	i1=netmaskIp.indexOf('.');
	i2=netmaskIp.indexOf('.',(i1+1));
	i3=netmaskIp.indexOf('.',(i2+1));
	nip = hex(netmaskIp.substring(0,i1)) + hex(netmaskIp.substring((i1+1),i2)) +hex(netmaskIp.substring((i2+1),i3)) +hex(netmaskIp.substring((i3+1),netmaskIp.length));
	nip = '0x'+nip;
	mask4 = netmaskIp.substring((i3+1),netmaskIp.length)-0;

	i1=gatewayIp.indexOf('.');
	i2=gatewayIp.indexOf('.',(i1+1));
	i3=gatewayIp.indexOf('.',(i2+1));
	gip = hex(gatewayIp.substring(0,i1)) + hex(gatewayIp.substring((i1+1),i2)) +hex(gatewayIp.substring((i2+1),i3)) +hex(gatewayIp.substring((i3+1),gatewayIp.length));
	gip = '0x'+gip;
	pool4 = gatewayIp.substring((i3+1),gatewayIp.length)-0;

	if (Op_AND_4Byte(wip, nip) != Op_AND_4Byte(gip, nip))
	{
		//alert("Invalid Ip: " +gatewayIp+" not in " + wanIp+"/"+netmaskIp+" netmask");
		return false;
	}

	net_no = (lan4 & mask4);
	lo_broadcast =  (lan4 & mask4) + (255-mask4);
	
	if (pool4==net_no) {
		//alert("Invalid Ip: " +gatewayIp+" is the Network Number.");
		return false;
	}
	if (pool4==lo_broadcast) {
		//alert("Invalid Ip: " +gatewayIp+" is the Broadcast address.");
		return false;
	}
}

function validateStartEndIp(lan_ipaddr, netip, startip, endip)
{
	i1=startip.indexOf('.');
	i2=startip.indexOf('.',(i1+1));
	i3=startip.indexOf('.',(i2+1));
	sip = hex(startip.substring(0,i1)) + hex(startip.substring((i1+1),i2)) +hex(startip.substring((i2+1),i3))+hex(startip.substring((i3+1),startip.length));
	sip = '0x'+sip;

	i1=endip.indexOf('.');
	i2=endip.indexOf('.',(i1+1));
	i3=endip.indexOf('.',(i2+1));
	eip = hex(endip.substring(0,i1)) + hex(endip.substring((i1+1),i2)) +hex(endip.substring((i2+1),i3))+hex(endip.substring((i3+1),endip.length));
	eip = '0x'+eip;
	
	i1=lan_ipaddr.indexOf('.');
	i2=lan_ipaddr.indexOf('.',(i1+1));
	i3=lan_ipaddr.indexOf('.',(i2+1)); 
	lan_ipaddr = hex(lan_ipaddr.substring(0,i1)) + hex(lan_ipaddr.substring((i1+1),i2)) +hex(lan_ipaddr.substring((i2+1),i3))+hex(lan_ipaddr.substring((i3+1),lan_ipaddr.length));
	lan_ipaddr = '0x'+lan_ipaddr;

	if(sip>eip)
	{
		//alert("Invalid start and end IP address, end IP should be larger than start IP.");
		return 1;
	}
	
	if(lan_ipaddr >= sip && lan_ipaddr <= eip)
	{
	    return 2;
	}
	
	return 0;
}

function isNetmaskIPValid(ip)
{
	if (ip == 255 || ip == 254 || ip == 252 || ip == 248
	|| ip == 240 || ip == 224 || ip == 192 || ip == 128 || ip == 0)
	{
		return true;
	}
	else
	{
		return false;
	}
}

function validateNetmask(netmask)
{
	var array = new Array();
	array = netmask.split(".");
	
	if (array.length != 4)
	{
		return false;
	}
	
	array[0] = parseInt(array[0]);
	array[1] = parseInt(array[1]);
	array[2] = parseInt(array[2]);
	array[3] = parseInt(array[3]);

	if (array[3] != 0)
	{
		if (array[2] != 255 || array[1] != 255 || array[0] != 255)
		{
			return false;
		}
		else
		{
			if (!isNetmaskIPValid(array[3]))
			{
				return false;
			}
		}
	}
	
	if (array[2] != 0)
	{
		if (array[1] != 255 || array[0] != 255)
		{
			return false;
		}
		else
		{
			if (!isNetmaskIPValid(array[2]))
			{
				return false;
			}
		}
	}
	
	if (array[1] != 0)
	{
		if (array[0] != 255)
		{
			return false;
		}
		else
		{
			if (!isNetmaskIPValid(array[1]))
			{
				return false;
			}
		}
	}
	
	if ( "0.0.0.0" == netmask || "255.255.255.255" == netmask)
	{
		return false;
	}
	
	return true;
}

function CheckValue()
{
	if (!checkIpAddr(document.lanCfg.lanIp, false))
		return false;
	if (!checkIpAddr(document.lanCfg.lanNetmask, true))
		return false;
		
	// check the netmask address by LiuWei184577
	if ( !validateNetmask(document.lanCfg.lanNetmask.value) )
	{
		ShowError(document.lanCfg.lanNetmask, 'Router Lan NetMask Invalid');
		document.lanCfg.lanNetmask.focus();
		return false;
	}
	
	if (document.lanCfg.lanDhcpType.options.selectedIndex == 1) {
		if (!checkIpAddr(document.lanCfg.dhcpStart, false))
			return false;
		if (!checkIpAddr(document.lanCfg.dhcpEnd, false))
			return false;
			
		if(validateGateway(document.lanCfg.lanIp.value, document.lanCfg.lanNetmask.value, document.lanCfg.dhcpStart.value)==false)
		{
		    ShowError(document.lanCfg.dhcpStart, "Router Lan DHCP SIP Out Range");
		    return false;
		}
		
		if(validateGateway(document.lanCfg.lanIp.value, document.lanCfg.lanNetmask.value, document.lanCfg.dhcpEnd.value)==false)
		{
		    ShowError(document.lanCfg.dhcpEnd, "Router Lan DHCP EIP Out Range");
		    return false;
		}	
		
		if(validateStartEndIp(document.lanCfg.lanIp.value, document.lanCfg.lanNetmask.value,
		    document.lanCfg.dhcpStart.value, document.lanCfg.dhcpEnd.value)==1)
		{
		    ShowError(document.lanCfg.dhcpEnd, "Router Lan DHCP Pool Error");
			return false;
		}
		else if(validateStartEndIp(document.lanCfg.lanIp.value, document.lanCfg.lanNetmask.value,
		    document.lanCfg.dhcpStart.value, document.lanCfg.dhcpEnd.value)==2)
		{
			ShowError(document.lanCfg.lanIp, "Router Lan DHCP Pool Conflict" );
			return false;
		}
		//20090401
		if (validateDhcpLease(document.lanCfg.dhcpLease.value)==false
			|| parseInt(document.lanCfg.dhcpLease.value) > 65535) 
		{
			ShowError(document.getElementById("dhcpLease"),"Router Lan DHCP Lease Error" );
			return false;
		}
	}
	writeHiddenNum("lucknum_DHCP_SET");
	return true;
}

function lan2_enable_switch()
{
	if (document.lanCfg.lan2enabled[1].checked == true)
	{
		document.lanCfg.lan2Ip.disabled = true;
		document.lanCfg.lan2Netmask.disabled = true;
	}
	else
	{
		document.lanCfg.lan2Ip.disabled = false;
		document.lanCfg.lan2Netmask.disabled = false;
	}
}

function checklanip()
{
	var strIp   = /^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])(\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])){3}$/;

	if (!(strIp.test(document.lanCfg.lanIp.value)))
	{
		return false;
	}
	return true;
}

function commitDhcp()
{
	TimeoutReload(10);
}
</script>
</head>

<body class="subpage_body_web" onLoad="initPage();">
<!-- ================= showerror div begin================= -->
<div id="MsgLayer1" onClick="setinner('hidden')"></div>
<div id="MsgLayer2" onClick="setinner('hidden')">
    <div id="errLayer" >
        <table height="48" width="320" border="0">
            <tr>
                <td width="320" align="center"><div id="errmsg" name="errmsg"></div></td>
            </tr>
        </table>
    </div>
</div>
<iframe id="ifr" name="ifr" src="about:blank">	</iframe>
<!-- ================= showerror div end================= -->
<!-- ================= toptip div begin================= -->
<div id="overDiv" name="overDiv"></div>
<!-- ================= toptip div end================= -->
<table cellspacing="0" cellpadding="10" border="0" bgcolor="#FFFFFF" class="body_table">
    <tr>
        <td valign="top">
        <form method="post" name="lanCfg" action="/goform/goform_process" onSubmit="return CheckValue()" autocomplete="off">
		<input type="hidden" value="DHCP_SET" name="goformId" id="goformId">
        <input type="hidden" value="" name="lucknum_DHCP_SET" id="lucknum_DHCP_SET">
        <table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td class="labelfont" colspan="2" id="RouterLanSubTitle">LAN Interface Setup</td>
        </tr>
        <tr>
          <td width="35%" class="top_head" id="RouterLanIPAddress">IP Address</td>
          <td class="top_tail"><input id="lanIp" name="lanIp" maxlength="15" value="<% getLanIp(); %>"></td>
        </tr>
        <tr>
          <td class="head" id="RouterLanSubnetMask">Subnet Mask</td>
          <td class="tail"><input id="lanNetmask" name="lanNetmask" maxlength="15" value="<% getLanNetmask(); %>"></td>
        </tr>
        
        <tr>
          <td class="head" id="RouterLanMACAddress">MAC Address</td>
          <td class="tail" id="lanMacAddress">&nbsp;<% getLanMac(); %></td>
        </tr>
        <tr>
          <td class="head" id="RouterLanDHCPType">DHCP Type</td>
          <td class="tail">
            <select name="lanDhcpType" size="1" onChange="dhcpTypeSwitch();">
              <option value="DISABLE" id="RouterLanDHCPTypeDisable">Disable</option>
              <option value="SERVER" id="RouterLanDHCPTypeServer">Server</option>
            </select>
          </td>
        </tr>
        </table>
        <table width="100%" border="0" cellpadding="0" cellspacing="0" id="tb_dhcp">
        <tr>
          <td class="head" id="RouterLanDHCPIpPool" width="35%">DHCP IP Pool</td>
          <td class="tail">
            <input id="dhcpStart" name="dhcpStart" maxlength="15" value="<% asp_get('dhcpStart'); %>">&nbsp;&nbsp;-&nbsp;&nbsp;
            <input id="dhcpEnd" name="dhcpEnd" maxlength="15" value="<% asp_get('dhcpEnd'); %>"></td>
        </tr>
        <tr >
          <td class="head" id="RouterLanDHCPLease">DHCP Lease Time</td>
          <td class="tail" ><input name="dhcpLease" id="dhcpLease" maxlength="5" value="<% asp_get('dhcpLease_hour'); %>">
            &nbsp;<span id="RouterLanDHCPLeaseUnit">hour(s)</span>
          </td>
        </tr>
        </table>
        <table width="100%" border="0">
            <tr >
              <td colspan="2">&nbsp;</td>
            </tr>
        </table>
        <span id="DHCP_Apply_Notice" class='warningInfo'>Note: Your settings will be effective after rebooting your device.</span>
        <div class="div_btn">
            <input type="submit" class="btn" value="Apply" id="RouterLanApply" name="RouterLanApply" onClick="commitDhcp();"onMouseOver="this.className='menu_over'" onMouseOut="this.className='menu_out'">
            <input type="reset" class="btn" value="Cancel" id="RouterLanCancel" onClick="window.location.reload()" onMouseOver="this.className='menu_over'" onMouseOut="this.className='menu_out'">
        </div>
        </form>
        </td>
    </tr>
</table>

</body>
</html>

